/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels;

import com.inet.report.config.Configuration;
import com.inet.report.config.ConfigurationManager;
import com.inet.report.config.gui.widget.IPFilterComponentPanel;
import com.inet.report.config.gui.widget.IPFilterModel;
import com.inet.report.config.gui.widget.IPFilterValidator;
import com.inet.setup.panels.AbstractPanel;
import com.inet.setup.panels.FilteredVariables;
import com.inet.setup.panels.util.IPFilterValueInterface;
import com.inet.setup.panels.util.IPFilterValues5;
import com.inet.setup.panels.util.JsonCreator;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.util.Debug;
import java.awt.GraphicsEnvironment;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class IPFilterPanel
extends AbstractPanel {
    private static final long serialVersionUID = 1L;
    private IPFilterComponentPanel localPanel;
    private FilteredVariables filteredVariables;
    private Object chosenConfigId;
    private boolean alreadyAddedDefaults;

    public IPFilterPanel(InstallerFrame parent, InstallData idata) {
        this(parent, idata, new IPFilterModel(), new IPFilterValidator());
    }

    IPFilterPanel(InstallerFrame parent, InstallData data, IPFilterModel model, IPFilterValidator validator) {
        super(parent, data, parent.langpack.getString("IPFilterPanel.heading"), null, null, "com/inet/setup/images/Database48.png");
    }

    @Override
    public Map<String, String> getRequiredVariables() {
        Map<String, String> requiredVariables = super.getRequiredVariables();
        requiredVariables.put("SELECTED", null);
        requiredVariables.put("SELECTED_PROPERTY", null);
        requiredVariables.put("ADD_TO_CONFIG", null);
        requiredVariables.put("CONFIG_NAME", null);
        requiredVariables.put("SCOPE_INT", null);
        return requiredVariables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void panelActivate() {
        String ipFilter;
        boolean configIsNewOrChanged;
        this.idata.getStatHandler().notifyPanelActivation(this);
        this.filteredVariables = this.readFilteredVariables(this.getRequiredVariables());
        super.panelActivate();
        String selectedConfigImport = this.filteredVariables.getVariable("SELECTED");
        String selectedProperty = this.filteredVariables.getVariable("SELECTED_PROPERTY");
        int selectedScope = -1;
        try {
            selectedScope = Integer.parseInt(this.filteredVariables.getVariable("SCOPE_INT"));
        }
        catch (Exception e2) {
            selectedScope = 4;
        }
        String selectedConfig = this.filteredVariables.getVariable("CONFIG_NAME");
        boolean bl2 = configIsNewOrChanged = !selectedProperty.equals(this.chosenConfigId);
        if (configIsNewOrChanged) {
            this.alreadyAddedDefaults = false;
        }
        this.chosenConfigId = selectedProperty;
        if (!this.alreadyAddedDefaults && selectedConfigImport != null && selectedConfigImport.equalsIgnoreCase("CREATE_FROM_PROPS")) {
            Properties properties = new Properties();
            FileInputStream fis = null;
            try {
                String ipFilter2;
                fis = new FileInputStream(selectedProperty);
                properties.load(fis);
                if (properties.isEmpty() || !configIsNewOrChanged || properties.getProperty("remoteInterface.ipfilter").length() <= 0 || GraphicsEnvironment.isHeadless() || this.localPanel == null || (ipFilter2 = properties.getProperty("remoteInterface.ipfilter")) == null || ipFilter2.length() <= 0) return;
                this.localPanel.setFilter(ipFilter2);
                return;
            }
            catch (Exception e3) {
                Debug.error(e3, this.getClass());
                return;
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e4) {
                        Debug.error(e4, this.getClass());
                    }
                }
            }
        }
        if (!this.alreadyAddedDefaults && selectedConfigImport != null && selectedConfigImport.equalsIgnoreCase("CREATE_FROM_LOCAL")) {
            String ipFilter3;
            this.alreadyAddedDefaults = true;
            String[] config = selectedProperty.split("::");
            if (config.length != 2) return;
            int scope = config[0].equalsIgnoreCase("system") ? 1 : 2;
            Configuration configuration = ConfigurationManager.getInstance().get(scope, config[1]);
            if (configuration == null || this.localPanel == null || (ipFilter3 = configuration.get("remoteInterface.ipfilter")) == null || ipFilter3.length() <= 0) return;
            this.localPanel.setFilter(ipFilter3);
            return;
        }
        if (!this.alreadyAddedDefaults && selectedConfigImport != null && selectedConfigImport.equalsIgnoreCase("USE_OLD")) {
            String ipFilter4;
            this.alreadyAddedDefaults = true;
            Configuration configuration = ConfigurationManager.getInstance().get(selectedScope, selectedConfig);
            if (configuration == null || this.localPanel == null || (ipFilter4 = configuration.get("remoteInterface.ipfilter")) == null || ipFilter4.length() <= 0) return;
            this.localPanel.setFilter(ipFilter4);
            return;
        }
        if (selectedConfigImport == null || !selectedConfigImport.equalsIgnoreCase("CREATE_NEW") || this.alreadyAddedDefaults) return;
        this.alreadyAddedDefaults = true;
        IPFilterValueInterface ipfetcher = null;
        try {
            ipfetcher = (IPFilterValueInterface)Class.forName("com.inet.setup.panels.util.IPFilterValues6").newInstance();
        }
        catch (Exception e5) {
            ipfetcher = new IPFilterValues5();
        }
        if (this.localPanel == null || (ipFilter = ipfetcher.getAvailableIPAddresses()) == null || ipFilter.length() <= 0) return;
        this.localPanel.setFilter(ipFilter);
    }

    private void panelFinish() {
        String variable = this.filteredVariables.getVariable("ADD_TO_CONFIG");
        HashMap<Object, Object> map = null;
        if (variable != null && variable.trim().length() > 0) {
            try {
                map = JsonCreator.createMapFromJson(variable);
            }
            catch (IllegalArgumentException iae) {
                map = new HashMap();
            }
            catch (NullPointerException npe) {
                map = new HashMap();
            }
        } else {
            map = new HashMap();
        }
        String ipfilter = "";
        if (this.localPanel != null) {
            ipfilter = this.localPanel.getChosenFilter();
        }
        map.put("remoteInterface.ipfilter", ipfilter);
        this.filteredVariables.setVariable("ADD_TO_CONFIG", JsonCreator.createJsonFromMap(map));
        this.putToSummary(this.parent.langpack.getString("IPFilterPanel.remoteIPFilter"), ipfilter.trim().length() == 0 ? this.parent.langpack.getString("IPFilterPanel.noIPFilter") : ipfilter, 2);
    }

    @Override
    public boolean isValidated() {
        if (this.localPanel != null && !this.localPanel.validateChoice()) {
            return false;
        }
        this.panelFinish();
        return super.isValidated();
    }

    @Override
    public JPanel initPanelGUI() {
        if (GraphicsEnvironment.isHeadless()) {
            return new JPanel();
        }
        this.localPanel = new IPFilterComponentPanel();
        this.localPanel.setBorder(BorderFactory.createEmptyBorder(20, 30, 10, 30));
        this.localPanel.invalidate();
        return this.localPanel;
    }
}

