/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels;

import com.inet.setup.GUIUtils;
import com.inet.setup.panels.AbstractPanel;
import com.inet.setup.panels.FilteredVariables;
import com.inet.setup.panels.widget.ContextPanel;
import com.inet.setup.panels.widget.JBossServerPanel;
import com.inet.setup.panels.widget.PathPanel;
import com.inet.setup.panels.widget.PortPanel;
import com.inet.setup.panels.widget.ServletVersionPanel;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class JBossPanel
extends AbstractPanel {
    private static final long serialVersionUID = 1L;
    private JPanel localPanel;
    private PathPanel pnlPath;
    private ServletVersionPanel pnlServletVersion;
    private JBossServerPanel pnlServer;
    private ContextPanel pnlContext;
    private FilteredVariables filteredVariables;
    private PortPanel pnlPort;
    private File checkPath;

    public JBossPanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata, parent.langpack.getString("JBossPanel.heading"), null, null, "com/inet/setup/images/Database48.png");
    }

    @Override
    public Map<String, String> getRequiredVariables() {
        Map<String, String> requiredVariables = super.getRequiredVariables();
        requiredVariables.put("JBOSS_CONTEXT_NAME", null);
        requiredVariables.put("JBOSS_INSTALL_PATH", this.idata.getInstallPath() + File.separatorChar + "jboss");
        requiredVariables.put("SERVLET_REMOTE_INSTALL", null);
        requiredVariables.put("JBOSS_SERVLET_VERSION", null);
        requiredVariables.put("JBOSS_SERVER_NAME", "default");
        requiredVariables.put("JBOSS_INSTALL_PORT", null);
        return requiredVariables;
    }

    @Override
    public void panelActivate() {
        this.idata.getStatHandler().notifyPanelActivation(this);
        this.filteredVariables = this.readFilteredVariables(this.getRequiredVariables());
        super.panelActivate();
        this.checkPath = new File(this.filteredVariables.getVariable("JBOSS_INSTALL_PATH"));
        this.pnlPath.isRemoteInstallation(this.filteredVariables.getVariable("SERVLET_REMOTE_INSTALL"));
    }

    public void panelFinish() {
        this.filteredVariables.setVariable("JBOSS_CONTEXT_NAME", this.pnlContext.getContext());
        this.filteredVariables.setVariable("JBOSS_SERVER_NAME", this.pnlServer.getServerName());
        this.filteredVariables.setVariable("JBOSS_SERVLET_VERSION", this.pnlServletVersion.getServletVersion());
        this.filteredVariables.setVariable("JBOSS_INSTALL_PORT", this.pnlPort.getPort());
        if (this.pnlPath.getPath() != null && !"true".equalsIgnoreCase(this.filteredVariables.getVariable("SERVLET_REMOTE_INSTALL"))) {
            this.filteredVariables.setVariable("JBOSS_INSTALL_PATH", this.pnlPath.getPath());
        } else {
            this.filteredVariables.setVariable("JBOSS_INSTALL_PATH", "jboss");
        }
        this.putToSummary(this.parent.langpack.getString("JBossPanel.installPath"), this.filteredVariables.getVariable("JBOSS_INSTALL_PATH"), 4);
        this.putToSummary(this.parent.langpack.getString("ServletPanel.servletContext"), this.filteredVariables.getVariable("JBOSS_CONTEXT_NAME"), 0);
        this.putToSummary(this.parent.langpack.getString("ServletPanel.servletVersion"), this.filteredVariables.getVariable("JBOSS_SERVLET_VERSION"), 2);
        this.putToSummary(this.parent.langpack.getString("JBossPanel.server"), this.filteredVariables.getVariable("JBOSS_SERVER_NAME"), 1);
        this.putToSummary(this.parent.langpack.getString("JBossPanel.port"), this.filteredVariables.getVariable("JBOSS_INSTALL_PORT"), 3);
    }

    @Override
    public boolean isValidated() {
        JComponent reselecet = null;
        reselecet = this.pnlContext.isValidated();
        if (this.pnlContext != null && reselecet != null) {
            reselecet.requestFocus();
            return false;
        }
        if (this.pnlPath != null && !this.pnlPath.isVisible()) {
            this.pnlPath.setPath(this.idata.getInstallPath() + File.separatorChar + "jboss");
        } else {
            reselecet = this.pnlPath.isValidated();
            if (this.pnlPath != null && reselecet != null) {
                reselecet.requestFocus();
                return false;
            }
        }
        reselecet = this.pnlPort.isValidated();
        if (this.pnlPort != null && reselecet != null) {
            reselecet.requestFocus();
            return false;
        }
        if (this.pnlPath.isVisible()) {
            File check = new File(this.pnlPath.getPath() + File.separatorChar + "server");
            if (!check.exists()) {
                this.emitError(null, this.parent.langpack.getString("JBossPanel.noJBossPath"));
                return false;
            }
            String installPath = this.pnlPath.getPath().trim();
            boolean ok = true;
            if (installPath.length() == 0) {
                this.emitError(null, this.parent.langpack.getString("JBossPanel.noJBossPath"));
                return false;
            }
            if ((installPath = installPath.trim()).endsWith(String.valueOf(File.separatorChar))) {
                installPath = installPath.substring(0, installPath.length() - String.valueOf(File.separatorChar).length());
            }
            if (installPath.endsWith("server")) {
                installPath = installPath.substring(0, installPath.length() - "server".length());
            }
            File path = new File(installPath).getAbsoluteFile();
            installPath = path.toString();
            this.checkPath = new File(installPath + File.separatorChar + "server");
            if (path.exists() && !path.isDirectory()) {
                this.emitError(null, this.parent.langpack.getString("TargetPanel.nodir"));
                ok = false;
            } else if (!path.exists() || !this.checkPath.exists()) {
                this.emitError(null, this.parent.langpack.getString("ApacheTomcatPanel.noTomcatPath"));
                ok = false;
            } else if (new File(installPath + File.separatorChar + "server" + File.separatorChar + this.pnlContext.getContext()).exists()) {
                int choose = this.askQuestion(this.parent.langpack.getString("installer.Message"), this.parent.langpack.getString("ApacheTomcatPanel.contextExists"), 0);
                ok = choose == 47;
            }
            if (ok) {
                try {
                    File tempFile = File.createTempFile("ccsetup", null, this.checkPath);
                    tempFile.deleteOnExit();
                }
                catch (Exception e2) {
                    String errorMsg = this.parent.langpack.getString("installer.no_write_permissions1");
                    errorMsg = errorMsg.replace("{0}", this.checkPath.getAbsolutePath());
                    this.emitError(null, errorMsg);
                    ok = false;
                }
            }
            if (!ok) {
                return false;
            }
        }
        this.panelFinish();
        return super.isValidated();
    }

    @Override
    public JPanel initPanelGUI() {
        this.localPanel = new JPanel();
        this.localPanel.setLayout(new GridBagLayout());
        this.pnlContext = new ContextPanel(this.parent, this.filteredVariables.getVariable("JBOSS_CONTEXT_NAME"), this);
        this.pnlContext.setName("pnlContext");
        this.localPanel.add((Component)this.pnlContext, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, GUIUtils.TITLED_INSETS_TOP, 0, 0));
        this.pnlServer = new JBossServerPanel(this.parent, this.filteredVariables.getVariable("JBOSS_SERVER_NAME"));
        this.pnlServer.setName("pnlServer");
        this.localPanel.add((Component)this.pnlServer, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, GUIUtils.TITLED_INSETS_MIDDLE, 0, 0));
        this.pnlPort = new PortPanel(this.parent, this.filteredVariables.getVariable("JBOSS_INSTALL_PORT"), this);
        this.pnlPort.setName("pnlPort");
        this.localPanel.add((Component)this.pnlPort, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, GUIUtils.TITLED_INSETS_MIDDLE, 0, 0));
        this.pnlPath = new PathPanel(this.parent, this.filteredVariables.getVariable("JBOSS_INSTALL_PATH"), this);
        this.pnlPath.setName("pnlPath");
        this.localPanel.add((Component)this.pnlPath, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 18, 2, GUIUtils.TITLED_INSETS_MIDDLE, 0, 0));
        this.pnlServletVersion = new ServletVersionPanel(this.parent, this.filteredVariables.getVariable("JBOSS_SERVLET_VERSION"));
        this.pnlServletVersion.setName("pnlServletVersion");
        this.localPanel.add((Component)this.pnlServletVersion, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 18, 2, GUIUtils.TITLED_INSETS_MIDDLE, 0, 0));
        this.localPanel.add((Component)new JPanel(), new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 10, 1, GUIUtils.INSETS_NULL, 0, 0));
        this.recalcWidthForComponent(this.pnlContext.getComponentsForWidthCalculation(), this.pnlPath.getComponentsForWidthCalculation(), this.pnlServer.getComponentsForWidthCalculation(), this.pnlPort.getComponentsForWidthCalculation());
        return this.localPanel;
    }
}

