/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels;

import com.inet.setup.GUIUtils;
import com.inet.setup.panels.AbstractPanel;
import com.inet.setup.panels.FilteredVariables;
import com.inet.setup.panels.widget.ContextPanel;
import com.inet.setup.panels.widget.PathPanel;
import com.inet.setup.panels.widget.PortPanel;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class JettyPanel
extends AbstractPanel {
    private static final long serialVersionUID = 1L;
    private ContextPanel pnlContext;
    private PathPanel pnlPath;
    private File checkPath;
    private FilteredVariables filteredVariables;
    private PortPanel pnlPort;
    private File installPath;

    public JettyPanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata, parent.langpack.getString("JettyPanel.heading"), null, null, "com/inet/setup/images/Components48.png");
    }

    @Override
    public Map<String, String> getRequiredVariables() {
        Map<String, String> requiredVariables = super.getRequiredVariables();
        requiredVariables.put("JETTY_CONTEXT_NAME", null);
        requiredVariables.put("JETTY_INSTALL_PATH", Boolean.toString(true).equalsIgnoreCase(this.idata.getVariable("SERVLET_REMOTE_INSTALL")) ? this.idata.getInstallPath() + File.separatorChar + "jetty" : "");
        requiredVariables.put("SERVLET_REMOTE_INSTALL", null);
        requiredVariables.put("JETTY_INSTALL_PORT", null);
        return requiredVariables;
    }

    @Override
    public void panelActivate() {
        this.idata.getStatHandler().notifyPanelActivation(this);
        this.filteredVariables = this.readFilteredVariables(this.getRequiredVariables());
        super.panelActivate();
        String variable = this.filteredVariables.getVariable("JETTY_INSTALL_PATH");
        this.installPath = new File(variable);
        this.checkPath = new File(variable);
        this.pnlPath.isRemoteInstallation(this.filteredVariables.getVariable("SERVLET_REMOTE_INSTALL"));
    }

    public void panelFinish() {
        this.filteredVariables.setVariable("JETTY_CONTEXT_NAME", this.pnlContext.getContext());
        this.filteredVariables.setVariable("JETTY_INSTALL_PORT", this.pnlPort.getPort());
        if (this.pnlPath.getPath() != null && !"true".equalsIgnoreCase(this.filteredVariables.getVariable("SERVLET_REMOTE_INSTALL"))) {
            this.filteredVariables.setVariable("JETTY_INSTALL_PATH", this.installPath.getAbsolutePath());
        } else {
            this.filteredVariables.setVariable("JETTY_INSTALL_PATH", "jetty");
        }
        this.putToSummary(this.parent.langpack.getString("JettyPanel.installPath"), this.filteredVariables.getVariable("JETTY_INSTALL_PATH"), 3);
        this.putToSummary(this.parent.langpack.getString("ServletPanel.servletContext"), this.filteredVariables.getVariable("JETTY_CONTEXT_NAME"), 0);
        this.putToSummary(this.parent.langpack.getString("JettyPanel.port"), this.filteredVariables.getVariable("JETTY_INSTALL_PORT"), 2);
    }

    @Override
    public boolean isValidated() {
        JComponent reselecet = null;
        reselecet = this.pnlContext.isValidated();
        if (this.pnlContext != null && reselecet != null) {
            reselecet.requestFocus();
            return false;
        }
        reselecet = this.pnlPort.isValidated();
        if (this.pnlPort != null && reselecet != null) {
            reselecet.requestFocus();
            return false;
        }
        if (this.pnlPath != null && !this.pnlPath.isVisible()) {
            this.pnlPath.setPath(this.idata.getInstallPath() + File.separatorChar + "jetty");
            this.panelFinish();
            return true;
        }
        reselecet = this.pnlPath.isValidated();
        if (this.pnlPath != null && reselecet != null) {
            reselecet.requestFocus();
            return false;
        }
        this.installPath = new File(this.pnlPath.getPath());
        boolean ok = true;
        String absoluteInstallPath = this.installPath.getAbsolutePath();
        if (absoluteInstallPath.endsWith(File.separator)) {
            absoluteInstallPath = absoluteInstallPath.substring(0, absoluteInstallPath.length() - 1);
        }
        if (absoluteInstallPath.endsWith("webapps")) {
            absoluteInstallPath = absoluteInstallPath.substring(0, absoluteInstallPath.length() - "webapps".length());
        }
        this.installPath = new File(absoluteInstallPath);
        this.checkPath = new File(this.installPath.getAbsolutePath() + File.separatorChar + "webapps");
        if (this.installPath.exists() && !this.installPath.isDirectory()) {
            this.emitError(null, this.parent.langpack.getString("TargetPanel.nodir"));
            ok = false;
        } else if (!this.installPath.exists() || !this.checkPath.exists()) {
            ok = this.askQuestion(this.parent.langpack.getString("installer.Message"), this.parent.langpack.getString("JettyPanel.noJettyPath"), 0) == 47;
        } else if (new File(absoluteInstallPath + File.separatorChar + "webapps" + File.separatorChar + this.pnlContext.getContext() + ".war").exists()) {
            boolean bl2 = ok = this.askQuestion(this.parent.langpack.getString("installer.Message"), this.parent.langpack.getString("JettyPanel.contextExists"), 0) == 47;
        }
        if (ok) {
            try {
                if (this.checkPath.exists()) {
                    File tempFile = File.createTempFile("ccsetup", null, this.checkPath);
                    tempFile.deleteOnExit();
                } else {
                    File tempFile = File.createTempFile("ccsetup", null, this.installPath);
                    tempFile.deleteOnExit();
                }
            }
            catch (Exception e2) {
                String errorMsg = this.parent.langpack.getString("installer.no_write_permissions1");
                errorMsg = errorMsg.replace("{0}", this.checkPath.exists() ? this.checkPath.getAbsolutePath() : this.installPath.getAbsolutePath());
                this.emitError(null, errorMsg);
                ok = false;
            }
        }
        if (!ok) {
            return false;
        }
        this.panelFinish();
        return super.isValidated();
    }

    @Override
    public JPanel initPanelGUI() {
        JPanel localPanel = new JPanel();
        localPanel.setLayout(new GridBagLayout());
        this.pnlContext = new ContextPanel(this.parent, this.filteredVariables.getVariable("JETTY_CONTEXT_NAME"), this);
        this.pnlContext.setName("pnlContext");
        localPanel.add((Component)this.pnlContext, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, GUIUtils.TITLED_INSETS_TOP, 0, 0));
        this.pnlPort = new PortPanel(this.parent, this.filteredVariables.getVariable("JETTY_INSTALL_PORT"), this);
        this.pnlPort.setName("pnlPort");
        localPanel.add((Component)this.pnlPort, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, GUIUtils.TITLED_INSETS_MIDDLE, 0, 0));
        this.pnlPath = new PathPanel(this.parent, this.filteredVariables.getVariable("JETTY_INSTALL_PATH"), this);
        this.pnlPath.setName("pnlPath");
        localPanel.add((Component)this.pnlPath, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, GUIUtils.TITLED_INSETS_MIDDLE, 0, 0));
        localPanel.add((Component)new JPanel(), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, GUIUtils.INSETS_NULL, 0, 0));
        this.recalcWidthForComponent(this.pnlContext.getComponentsForWidthCalculation(), this.pnlPath.getComponentsForWidthCalculation(), this.pnlPort.getComponentsForWidthCalculation());
        return localPanel;
    }
}

