/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels;

import com.inet.setup.panels.ShortcutSpec;
import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.panels.ShortcutData;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.TargetFactory;
import com.izforge.izpack.util.os.Shortcut;
import com.izforge.izpack.util.xml.XMLHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class ShortcutSpecImpl
implements ShortcutSpec {
    public static final String SPEC_ATTRIBUTE_CONDITION = "condition";
    public static final String SPEC_ATTRIBUTE_KDE_USERNAME = "KdeUsername";
    public static final String SPEC_ATTRIBUTE_KDE_SUBST_UID = "KdeSubstUID";
    public static final String SPEC_ATTRIBUTE_URL = "url";
    public static final String SPEC_ATTRIBUTE_TYPE = "type";
    public static final String SPEC_ATTRIBUTE_TERMINAL_OPTIONS = "terminalOptions";
    public static final String SPEC_ATTRIBUTE_TERMINAL = "terminal";
    public static final String SPEC_ATTRIBUTE_MIMETYPE = "mimetype";
    public static final String SPEC_ATTRIBUTE_ENCODING = "encoding";
    public static final String SPEC_CATEGORIES = "categories";
    public static final String SPEC_TRYEXEC = "tryexec";
    private static final String SPEC_KEY_SKIP_IFNOT_SUPPORTED = "skipIfNotSupported";
    private static final String SPEC_KEY_NOT_SUPPORTED = "notSupported";
    private static final String SPEC_KEY_DEF_CUR_USER = "defaultCurrentUser";
    private static final String SPEC_KEY_PROGRAM_GROUP = "programGroup";
    private static final String SPEC_KEY_SHORTCUT = "shortcut";
    private static final String SPEC_KEY_PACKS = "createForPack";
    private static final String SPEC_ATTRIBUTE_DEFAULT_GROUP = "defaultName";
    private static final String SPEC_ATTRIBUTE_INSTALLGROUP = "installGroup";
    private static final String SPEC_ATTRIBUTE_LOCATION = "location";
    private static final String SPEC_ATTRIBUTE_NAME = "name";
    private static final String SPEC_ATTRIBUTE_SUBGROUP = "subgroup";
    private static final String SPEC_ATTRIBUTE_DESCRIPTION = "description";
    private static final String SPEC_ATTRIBUTE_TARGET = "target";
    private static final String SPEC_ATTRIBUTE_COMMAND = "commandLine";
    private static final String SPEC_ATTRIBUTE_ICON = "iconFile";
    private static final String SPEC_ATTRIBUTE_ICON_INDEX = "iconIndex";
    private static final String SPEC_ATTRIBUTE_WORKING_DIR = "workingDirectory";
    private static final String SPEC_ATTRIBUTE_INITIAL_STATE = "initialState";
    private static final String SPEC_ATTRIBUTE_DESKTOP = "desktop";
    private static final String SPEC_ATTRIBUTE_APPLICATIONS = "applications";
    private static final String SPEC_ATTRIBUTE_START_MENU = "startMenu";
    private static final String SPEC_ATTRIBUTE_STARTUP = "startup";
    private static final String SPEC_ATTRIBUTE_PROGRAM_GROUP = "programGroup";
    private static final String SPEC_VALUE_APPLICATIONS = "applications";
    private static final String SPEC_VALUE_START_MENU = "startMenu";
    private static final String SPEC_VALUE_NO_SHOW = "noShow";
    private static final String SPEC_VALUE_NORMAL = "normal";
    private static final String SPEC_VALUE_MAXIMIZED = "maximized";
    private static final String SPEC_VALUE_MINIMIZED = "minimized";
    public static final String CREATE_FOR_ALL = "createForAll";
    private Shortcut shortcut;
    private boolean shortcutsToCreate;
    private boolean skipIfNotSupported;
    private boolean defaultCurrentUserFlag;
    private boolean simulteNotSupported;
    private boolean hasDesktopShortcuts;
    private String suggestedProgramGroup;
    private String programGroupIconFile;
    private String programGroupComment;
    private int groupLocation;
    private List<String> shortCutNames;
    private List<ShortcutData> shortcutDatas = new ArrayList<ShortcutData>();
    private final InstallData idata;
    private final RulesEngine rules;

    ShortcutSpecImpl(InstallData idata, RulesEngine rules, IXMLElement xmlSpec) {
        this.idata = idata;
        this.rules = rules;
        try {
            this.shortcut = (Shortcut)TargetFactory.getInstance().makeObject("com.izforge.izpack.util.os.Shortcut");
            this.shortcut.initialize(1, "-");
        }
        catch (Throwable exception) {
            Debug.log((Object)"could not create shortcut instance", this.getClass());
            exception.printStackTrace();
        }
        this.analyzeShortcutSpec(xmlSpec);
    }

    private void analyzeShortcutSpec(IXMLElement spec) {
        if (spec == null) {
            this.shortcutsToCreate = false;
            return;
        }
        IXMLElement skipper = spec.getFirstChildNamed(SPEC_KEY_SKIP_IFNOT_SUPPORTED);
        this.skipIfNotSupported = skipper != null;
        this.defaultCurrentUserFlag = spec.getFirstChildNamed(SPEC_KEY_DEF_CUR_USER) != null;
        IXMLElement support = spec.getFirstChildNamed(SPEC_KEY_NOT_SUPPORTED);
        if (support != null) {
            this.simulteNotSupported = true;
        }
        IXMLElement group = null;
        Vector<IXMLElement> groupSpecs = spec.getChildrenNamed("programGroup");
        String selectedInstallGroup = this.idata.getVariable("INSTALL_GROUP");
        if (selectedInstallGroup != null) {
            for (IXMLElement g2 : groupSpecs) {
                String instGrp = g2.getAttribute(SPEC_ATTRIBUTE_INSTALLGROUP);
                if (instGrp == null || !selectedInstallGroup.equalsIgnoreCase(instGrp)) continue;
                group = g2;
                break;
            }
        }
        if (group == null) {
            group = spec.getFirstChildNamed("programGroup");
        }
        String location = null;
        this.hasDesktopShortcuts = false;
        if (group != null) {
            this.suggestedProgramGroup = group.getAttribute(SPEC_ATTRIBUTE_DEFAULT_GROUP, "");
            this.programGroupIconFile = group.getAttribute(SPEC_ATTRIBUTE_ICON, "");
            this.programGroupComment = group.getAttribute("comment", "");
            location = group.getAttribute(SPEC_ATTRIBUTE_LOCATION, "applications");
        } else {
            this.suggestedProgramGroup = "";
            location = "applications";
        }
        if (location.equals("applications")) {
            this.groupLocation = 1;
        } else if (location.equals("startMenu")) {
            this.groupLocation = 2;
        }
        Vector<IXMLElement> shortcutSpecs = spec.getChildrenNamed(SPEC_KEY_SHORTCUT);
        this.shortCutNames = new ArrayList<String>();
        for (int i2 = 0; i2 < shortcutSpecs.size(); ++i2) {
            Vector<IXMLElement> forPacks;
            IXMLElement shortcutSpec = shortcutSpecs.elementAt(i2);
            if (!OsConstraint.oneMatchesCurrentSystem(shortcutSpec)) continue;
            Debug.log((Object)("Checking Condition for " + shortcutSpec.getAttribute(SPEC_ATTRIBUTE_NAME)), this.getClass());
            if (!this.checkConditions(shortcutSpec)) continue;
            Debug.log((Object)("Checked Condition for " + shortcutSpec.getAttribute(SPEC_ATTRIBUTE_NAME)), this.getClass());
            ShortcutData data = new ShortcutData();
            data.name = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_NAME);
            data.subgroup = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_SUBGROUP, "");
            data.description = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_DESCRIPTION, "");
            data.deskTopEntryLinux_Encoding = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_ENCODING, "");
            data.deskTopEntryLinux_MimeType = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_MIMETYPE, "");
            data.deskTopEntryLinux_Terminal = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_TERMINAL, "");
            data.deskTopEntryLinux_TerminalOptions = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_TERMINAL_OPTIONS, "");
            data.deskTopEntryLinux_Type = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_TYPE, "");
            data.deskTopEntryLinux_URL = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_URL, "");
            data.deskTopEntryLinux_X_KDE_SubstituteUID = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_KDE_SUBST_UID, "false");
            data.deskTopEntryLinux_X_KDE_UserName = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_KDE_USERNAME, "root");
            data.Categories = shortcutSpec.getAttribute(SPEC_CATEGORIES, "");
            data.TryExec = shortcutSpec.getAttribute(SPEC_TRYEXEC, "");
            data.createForAll = Boolean.valueOf(shortcutSpec.getAttribute(CREATE_FOR_ALL, "false"));
            data.target = this.fixSeparatorChar(shortcutSpec.getAttribute(SPEC_ATTRIBUTE_TARGET, ""));
            data.commandLine = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_COMMAND, "");
            data.iconFile = this.fixSeparatorChar(shortcutSpec.getAttribute(SPEC_ATTRIBUTE_ICON, ""));
            data.iconIndex = Integer.parseInt(shortcutSpec.getAttribute(SPEC_ATTRIBUTE_ICON_INDEX, "0"));
            data.workingDirectory = this.fixSeparatorChar(shortcutSpec.getAttribute(SPEC_ATTRIBUTE_WORKING_DIR, ""));
            String initialState = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_INITIAL_STATE, "");
            data.initialState = initialState.equals(SPEC_VALUE_NO_SHOW) ? 0 : (initialState.equals(SPEC_VALUE_NORMAL) ? 1 : (initialState.equals(SPEC_VALUE_MAXIMIZED) ? 3 : (initialState.equals(SPEC_VALUE_MINIMIZED) ? 2 : 1)));
            if (data.name == null) continue;
            if (data.target == null) {
                data.target = "";
            }
            if (!this.shortcutRequiredFor(forPacks = shortcutSpec.getChildrenNamed(SPEC_KEY_PACKS))) continue;
            if (XMLHelper.attributeIsTrue(shortcutSpec, SPEC_ATTRIBUTE_DESKTOP)) {
                this.hasDesktopShortcuts = true;
                data.addToGroup = false;
                data.type = 3;
                this.shortcutDatas.add((ShortcutData)data.clone());
            }
            if (XMLHelper.attributeIsTrue(shortcutSpec, "applications")) {
                data.addToGroup = false;
                data.type = 1;
                this.shortcutDatas.add((ShortcutData)data.clone());
            }
            if (XMLHelper.attributeIsTrue(shortcutSpec, "startMenu")) {
                data.addToGroup = false;
                data.type = 2;
                this.shortcutDatas.add((ShortcutData)data.clone());
            }
            if (XMLHelper.attributeIsTrue(shortcutSpec, SPEC_ATTRIBUTE_STARTUP)) {
                data.addToGroup = false;
                data.type = 4;
                this.shortcutDatas.add((ShortcutData)data.clone());
            }
            if (XMLHelper.attributeIsTrue(shortcutSpec, "programGroup")) {
                data.addToGroup = true;
                data.type = 1;
                this.shortcutDatas.add((ShortcutData)data.clone());
            }
            this.shortCutNames.add(data.name == null ? "" : data.name);
        }
        if (this.shortcutDatas.size() > 0) {
            this.shortcutsToCreate = true;
        }
    }

    private boolean shortcutRequiredFor(Vector<IXMLElement> packs) {
        if (packs.size() == 0) {
            return true;
        }
        for (int i2 = 0; i2 < this.idata.getSelectedPacks().size(); ++i2) {
            String selected = this.idata.getSelectedPacks().get((int)i2).name;
            for (int k2 = 0; k2 < packs.size(); ++k2) {
                String required = packs.elementAt(k2).getAttribute(SPEC_ATTRIBUTE_NAME, "");
                if (!selected.equals(required)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkConditions(IXMLElement shortcutSpec) {
        boolean result = true;
        String conditionid = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_CONDITION);
        if (conditionid != null) {
            result = this.rules.isConditionTrue(conditionid);
        }
        return result;
    }

    @Override
    public List<String> getProgramGroups(int chosenUserType) {
        return this.shortcut.getProgramGroups(chosenUserType);
    }

    @Override
    public boolean isCurrentUser() {
        return false;
    }

    private String fixSeparatorChar(String path) {
        String newPath = path.replace('/', File.separatorChar);
        newPath = newPath.replace('\\', File.separatorChar);
        return newPath;
    }

    public List<ShortcutData> getShortcuts() {
        return this.shortcutDatas;
    }

    public int getShortcutCount() {
        return this.shortcutDatas.size();
    }

    public Shortcut getShortcut() {
        return this.shortcut;
    }
}

