/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels;

import java.util.ArrayList;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeState
implements Cloneable {
    private ArrayList<TreePath> expandedPaths = new ArrayList();
    private boolean lockState = false;
    private int[] selectedRow;
    private TreePath[] selectionState;

    public void setSelectionState(TreePath[] path) {
        if (!this.lockState) {
            this.selectionState = path;
        }
    }

    public void setSelectedRows(int[] row) {
        if (!this.lockState) {
            this.selectedRow = row;
        }
    }

    public int[] getSelectedRows() {
        return this.selectedRow;
    }

    public boolean isLockState() {
        return this.lockState;
    }

    public void setLockState(boolean lockState) {
        this.lockState = lockState;
    }

    private TreePath[] getSelectionState() {
        return this.selectionState;
    }

    private void addExpandedPath(TreePath path) {
        if (!this.lockState) {
            this.expandedPaths.add(path);
        }
    }

    public ArrayList<TreePath> getExpandedPath() {
        return this.expandedPaths;
    }

    public void lock(boolean lock) {
        this.lockState = lock;
    }

    public String toString() {
        String string = "";
        for (int i2 = 0; i2 < this.expandedPaths.size(); ++i2) {
            string = string + this.expandedPaths.get(i2).toString() + "\n";
        }
        return string;
    }

    public static TreeState getTreeState(JTree tree) {
        TreeState result = new TreeState();
        result.setSelectedRows(tree.getSelectionRows());
        result.setSelectionState(tree.getSelectionPaths());
        for (int i2 = 0; i2 < tree.getRowCount(); ++i2) {
            if (!tree.isExpanded(i2)) continue;
            result.addExpandedPath(tree.getPathForRow(i2));
        }
        return result;
    }

    public static void setTreeState(JTree tree, TreeState state) {
        if (state != null) {
            state.lockState = true;
            ArrayList<TreePath> paths = state.getExpandedPath();
            for (int i2 = 0; i2 < paths.size(); ++i2) {
                Object[] path = paths.get(i2).getPath();
                TreeNode node = (TreeNode)tree.getModel().getRoot();
                TreePath treepath = new TreePath(node);
                for (int j2 = 1; j2 < path.length && (node = TreeState.getChild(node, path[j2].toString())) != null; ++j2) {
                    if (tree.isExpanded(treepath = treepath.pathByAddingChild(node))) continue;
                    tree.expandPath(treepath);
                }
            }
            TreePath[] selectionPaths = state.getSelectionState();
            if (selectionPaths == null) {
                tree.setSelectionPaths(null);
            } else {
                TreePath[] newSelectionPaths = new TreePath[selectionPaths.length];
                for (int i3 = 0; i3 < selectionPaths.length; ++i3) {
                    Object[] path = selectionPaths[i3].getPath();
                    TreeNode node = (TreeNode)tree.getModel().getRoot();
                    TreePath treepath = new TreePath(node);
                    for (int j3 = 1; j3 < path.length && (node = TreeState.getChild(node, path[j3].toString())) != null; ++j3) {
                        treepath = treepath.pathByAddingChild(node);
                    }
                    newSelectionPaths[i3] = treepath;
                }
                tree.setSelectionPaths(newSelectionPaths);
            }
            state.lockState = false;
        }
    }

    private static final TreeNode getChild(TreeNode node, String text) {
        for (int i2 = 0; i2 < node.getChildCount(); ++i2) {
            TreeNode child = node.getChildAt(i2);
            if (!text.equals(String.valueOf(child))) continue;
            return child;
        }
        return null;
    }
}

