/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels;

import com.inet.setup.GUIUtils;
import com.inet.setup.panels.AbstractPanel;
import com.inet.setup.panels.FilteredVariables;
import com.inet.setup.panels.widget.ContextPanel;
import com.inet.setup.panels.widget.PathPanel;
import com.inet.setup.panels.widget.PortPanel;
import com.inet.setup.panels.widget.ServletVersionPanel;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class WeblogicPanel
extends AbstractPanel {
    private static final long serialVersionUID = 1L;
    private JPanel localPanel;
    private PathPanel pnlPath;
    private ServletVersionPanel pnlServletVersion;
    private ContextPanel pnlContext;
    private FilteredVariables filteredVariables;
    private PortPanel pnlPort;

    public WeblogicPanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata, parent.langpack.getString("WeblogicPanel.heading"), null, null, "com/inet/setup/images/Database48.png");
    }

    @Override
    public Map<String, String> getRequiredVariables() {
        Map<String, String> requiredVariables = super.getRequiredVariables();
        requiredVariables.put("WEBLOGIC_CONTEXT_NAME", null);
        requiredVariables.put("WEBLOGIC_INSTALL_PATH", this.idata.getInstallPath() + File.separatorChar + "weblogic");
        requiredVariables.put("SERVLET_REMOTE_INSTALL", null);
        requiredVariables.put("WEBLOGIC_SERVLET_VERSION", null);
        requiredVariables.put("WEBLOGIC_INSTALL_PORT", null);
        return requiredVariables;
    }

    @Override
    public void panelActivate() {
        this.idata.getStatHandler().notifyPanelActivation(this);
        this.filteredVariables = this.readFilteredVariables(this.getRequiredVariables());
        super.panelActivate();
        this.pnlPath.isRemoteInstallation(this.filteredVariables.getVariable("SERVLET_REMOTE_INSTALL"));
    }

    public void panelFinish() {
        this.filteredVariables.setVariable("WEBLOGIC_CONTEXT_NAME", this.pnlContext.getContext());
        this.filteredVariables.setVariable("WEBLOGIC_INSTALL_PORT", this.pnlPort.getPort());
        if (this.pnlPath.getPath() != null && !"true".equalsIgnoreCase(this.filteredVariables.getVariable("SERVLET_REMOTE_INSTALL"))) {
            this.filteredVariables.setVariable("WEBLOGIC_INSTALL_PATH", this.pnlPath.getPath());
        } else {
            this.filteredVariables.setVariable("WEBLOGIC_INSTALL_PATH", "weblogic");
        }
        this.filteredVariables.setVariable("WEBLOGIC_SERVLET_VERSION", this.pnlServletVersion.getServletVersion());
        this.putToSummary(this.parent.langpack.getString("WeblogicPanel.installPath"), this.filteredVariables.getVariable("WEBLOGIC_INSTALL_PATH"), 3);
        this.putToSummary(this.parent.langpack.getString("ServletPanel.servletContext"), this.filteredVariables.getVariable("WEBLOGIC_CONTEXT_NAME"), 0);
        this.putToSummary(this.parent.langpack.getString("ServletPanel.servletVersion"), this.filteredVariables.getVariable("WEBLOGIC_SERVLET_VERSION"), 1);
        this.putToSummary(this.parent.langpack.getString("WeblogicPanel.port"), this.filteredVariables.getVariable("WEBLOGIC_INSTALL_PORT"), 2);
    }

    @Override
    public boolean isValidated() {
        JComponent reselecet = null;
        reselecet = this.pnlContext.isValidated();
        if (this.pnlContext != null && reselecet != null) {
            reselecet.requestFocus();
            return false;
        }
        if (this.pnlPath != null && !this.pnlPath.isVisible()) {
            this.pnlPath.setPath(this.idata.getInstallPath() + File.separatorChar + "weblogic");
        } else {
            reselecet = this.pnlPath.isValidated();
            if (this.pnlPath != null && reselecet != null) {
                reselecet.requestFocus();
                return false;
            }
        }
        reselecet = this.pnlPort.isValidated();
        if (this.pnlPort != null && reselecet != null) {
            reselecet.requestFocus();
            return false;
        }
        this.panelFinish();
        return super.isValidated();
    }

    @Override
    public JPanel initPanelGUI() {
        this.localPanel = new JPanel();
        this.localPanel.setLayout(new GridBagLayout());
        this.pnlContext = new ContextPanel(this.parent, this.filteredVariables.getVariable("WEBLOGIC_CONTEXT_NAME"), this);
        this.pnlContext.setName("pnlContext");
        this.localPanel.add((Component)this.pnlContext, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, GUIUtils.TITLED_INSETS_TOP, 0, 0));
        this.pnlPort = new PortPanel(this.parent, this.filteredVariables.getVariable("WEBLOGIC_INSTALL_PORT"), this);
        this.pnlPort.setName("pnlPort");
        this.localPanel.add((Component)this.pnlPort, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, GUIUtils.TITLED_INSETS_MIDDLE, 0, 0));
        this.pnlPath = new PathPanel(this.parent, this.filteredVariables.getVariable("WEBLOGIC_INSTALL_PATH"), this);
        this.pnlPath.setName("pnlPath");
        this.localPanel.add((Component)this.pnlPath, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, GUIUtils.TITLED_INSETS_MIDDLE, 0, 0));
        this.pnlServletVersion = new ServletVersionPanel(this.parent, this.filteredVariables.getVariable("WEBLOGIC_SERVLET_VERSION"));
        this.pnlServletVersion.setName("pnlServletVersion");
        this.localPanel.add((Component)this.pnlServletVersion, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 18, 2, GUIUtils.TITLED_INSETS_MIDDLE, 0, 0));
        this.localPanel.add((Component)new JPanel(), new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 10, 1, GUIUtils.INSETS_NULL, 0, 0));
        this.recalcWidthForComponent(this.pnlContext.getComponentsForWidthCalculation(), this.pnlPath.getComponentsForWidthCalculation(), this.pnlPort.getComponentsForWidthCalculation());
        return this.localPanel;
    }
}

