/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels;

import com.inet.setup.GUIUtils;
import com.inet.setup.panels.AbstractPanel;
import com.inet.setup.panels.FilteredVariables;
import com.inet.setup.panels.widget.ContextPanel;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.util.OsVersion;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class WindowsServicePanel
extends AbstractPanel {
    private JPanel localPanel;
    private JPanel pnlVMOptions;
    private JLabel lblMaxMemory;
    private JComboBox boxMaxMemory;
    private JLabel lblVMOptions;
    private JTextField txtVMOptions;
    private JPanel pnlServerService;
    private JLabel lblServiceDisplayName;
    private JTextField txtServiceDisplayName;
    private JLabel lblServiceName;
    private JTextField txtServiceName;
    private ContextPanel pnlVirtualDir;
    private FilteredVariables filteredVariables;
    private boolean isIIS;
    private boolean isApache;
    private DllFilter dllFilter;

    public WindowsServicePanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata, parent.langpack.getString("WindowsServicePanel.heading"), null, null, "com/inet/setup/images/Database48.png");
    }

    @Override
    public Map<String, String> getRequiredVariables() {
        Map<String, String> requiredVariables = super.getRequiredVariables();
        requiredVariables.put("JVM_MEMORY", null);
        requiredVariables.put("JVM_OPTIONS", null);
        requiredVariables.put("SERVLET_REMOTE_INSTALL", null);
        requiredVariables.put("SERVICE_VIRTUAL_DIRECTORY", null);
        requiredVariables.put("FRAMEWORK_PATH", null);
        return requiredVariables;
    }

    @Override
    public void panelActivate() {
        this.idata.getStatHandler().notifyPanelActivation(this);
        this.filteredVariables = this.readFilteredVariables(this.getRequiredVariables());
        super.panelActivate();
        this.isIIS = this.idata.getRules().isConditionTrue("izpack.selected.CCIIS");
        this.isApache = this.idata.getRules().isConditionTrue("izpack.selected.CCApache");
        this.pnlVirtualDir.setVisible(this.isIIS && !this.isApache);
        if (!this.isIIS && !this.isApache) {
            new StopW3SVC().start();
        }
        new StopCCService().start();
    }

    public void panelFinish() {
        this.dllFilter = new DllFilter();
        this.check64bitVM();
        try {
            String win_dir = System.getenv("windir");
            if (new File(win_dir + "\\Microsoft.NET\\Framework64\\v2.0.50727\\aspnet_isapi.dll").exists()) {
                this.filteredVariables.setVariable("FRAMEWORK_PATH", "%windir%\\Microsoft.NET\\Framework64\\v2.0.50727\\aspnet_isapi.dll");
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        String memoryString = this.boxMaxMemory.getSelectedItem().toString().trim();
        this.filteredVariables.setVariable("JVM_MEMORY", memoryString);
        this.filteredVariables.setVariable("JVM_OPTIONS", this.txtVMOptions.getText());
        this.filteredVariables.setVariable("SERVICE_VIRTUAL_DIRECTORY", this.pnlVirtualDir.getContext());
        this.putToSummary(this.parent.langpack.getString("WindowsServicePanel.ServiceDisplayName"), "i-net Clear Reports", 0);
        this.putToSummary(this.parent.langpack.getString("WindowsServicePanel.ServiceName"), "ClearReportsSVC", 1);
        this.putToSummary(this.parent.langpack.getString("WindowsServicePanel.MaxMem"), memoryString + " MB", 2);
        this.putToSummary(this.parent.langpack.getString("WindowsServicePanel.addOptions"), this.txtVMOptions.getText(), 3);
        if (this.isIIS && !this.isApache) {
            this.putToSummary(this.parent.langpack.getString("WindowsServicePanel.VirtualDir"), this.pnlVirtualDir.getContext(), 4);
        }
    }

    private void check64bitVM() {
        File dir;
        String jvmPath = "auto";
        if (this.idata.getRules().isConditionTrue("is64bit") && (dir = new File(System.getenv("ProgramFiles") + File.separatorChar + "Java")).exists()) {
            ArrayList<File> dlls = new ArrayList<File>();
            this.getFilesRecursive(dir, dlls);
            long latestModify = 0L;
            String latestDll = "";
            for (File path : dlls) {
                if (path.lastModified() <= latestModify) continue;
                latestModify = path.lastModified();
                latestDll = path.getAbsolutePath();
            }
            jvmPath = latestDll;
        }
        this.idata.setVariable("JVM", jvmPath);
    }

    void getFilesRecursive(File dir, ArrayList<File> foundDlls) {
        File[] files;
        for (File f2 : files = dir.listFiles(this.dllFilter)) {
            if (f2.isDirectory()) {
                this.getFilesRecursive(f2, foundDlls);
                continue;
            }
            foundDlls.add(f2);
        }
    }

    @Override
    public boolean isValidated() {
        String memoryString = this.boxMaxMemory.getSelectedItem().toString().trim();
        if (memoryString.length() == 0) {
            this.emitError(this.parent.langpack.getString("WindowsServicePanel.noMaxMem.title"), this.parent.langpack.getString("WindowsServicePanel.noMaxMem.msg"));
            this.boxMaxMemory.requestFocus();
            return false;
        }
        if (!memoryString.matches("[0-9]*")) {
            this.emitError(this.parent.langpack.getString("WindowsServicePanel.noNummericValue.title"), this.parent.langpack.getString("WindowsServicePanel.noNummericValue.msg"));
            this.boxMaxMemory.requestFocus();
            return false;
        }
        JComponent reselecet = this.pnlVirtualDir.isValidated();
        if (this.pnlVirtualDir != null && reselecet != null) {
            reselecet.requestFocus();
            return false;
        }
        this.panelFinish();
        return super.isValidated();
    }

    @Override
    public JPanel initPanelGUI() {
        this.localPanel = new JPanel();
        this.localPanel.setBorder(BorderFactory.createEmptyBorder());
        this.localPanel.setLayout(new GridBagLayout());
        this.pnlServerService = new JPanel();
        this.pnlServerService.setLayout(new GridBagLayout());
        this.pnlServerService.setBorder(BorderFactory.createTitledBorder(this.parent.langpack.getString("WindowsServicePanel.ntService")));
        this.lblServiceDisplayName = new JLabel(this.parent.langpack.getString("WindowsServicePanel.ServiceDisplayName") + ":");
        this.txtServiceDisplayName = new JTextField("i-net Clear Reports");
        this.txtServiceDisplayName.setEditable(false);
        this.lblServiceDisplayName.setLabelFor(this.txtServiceDisplayName);
        this.lblServiceName = new JLabel(this.parent.langpack.getString("WindowsServicePanel.ServiceName") + ":");
        this.txtServiceName = new JTextField("ClearReportsSVC");
        this.txtServiceName.setEditable(false);
        this.lblServiceName.setLabelFor(this.txtServiceName);
        this.pnlServerService.add((Component)this.lblServiceName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, GUIUtils.COMPONENT_INSETS_MIDDLE, 0, 0));
        this.pnlServerService.add((Component)this.txtServiceName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, GUIUtils.COMPONENT_INSETS_MIDDLE, 0, 0));
        this.pnlServerService.add((Component)this.lblServiceDisplayName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, GUIUtils.COMPONENT_INSETS_MIDDLE, 0, 0));
        this.pnlServerService.add((Component)this.txtServiceDisplayName, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, GUIUtils.COMPONENT_INSETS_MIDDLE, 0, 0));
        this.pnlVMOptions = new JPanel();
        this.pnlVMOptions.setLayout(new GridBagLayout());
        this.pnlVMOptions.setBorder(BorderFactory.createTitledBorder(this.parent.langpack.getString("WindowsServicePanel.VMOptions")));
        this.lblMaxMemory = new JLabel(this.parent.langpack.getString("WindowsServicePanel.MaxMem") + ":");
        this.boxMaxMemory = new JComboBox();
        this.boxMaxMemory.addItem("64");
        this.boxMaxMemory.addItem("128");
        this.boxMaxMemory.addItem("256");
        this.boxMaxMemory.addItem("512");
        this.boxMaxMemory.addItem("1024");
        if (OsVersion.IS_32BIT_OS) {
            this.boxMaxMemory.addItem("1536");
        } else {
            this.boxMaxMemory.addItem("2048");
            this.boxMaxMemory.addItem("4096");
        }
        this.boxMaxMemory.setEditable(true);
        this.boxMaxMemory.setSelectedIndex(2);
        this.lblMaxMemory.setLabelFor(this.boxMaxMemory);
        this.lblVMOptions = new JLabel(this.parent.langpack.getString("WindowsServicePanel.addOptions") + ":");
        this.txtVMOptions = new JTextField();
        this.lblVMOptions.setLabelFor(this.txtVMOptions);
        this.pnlVMOptions.add((Component)this.lblMaxMemory, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, GUIUtils.COMPONENT_INSETS_MIDDLE, 0, 0));
        this.pnlVMOptions.add((Component)this.boxMaxMemory, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, GUIUtils.COMPONENT_INSETS_MIDDLE, 0, 0));
        this.pnlVMOptions.add((Component)this.lblVMOptions, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, GUIUtils.COMPONENT_INSETS_MIDDLE, 0, 0));
        this.pnlVMOptions.add((Component)this.txtVMOptions, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, GUIUtils.COMPONENT_INSETS_MIDDLE, 0, 0));
        this.pnlVirtualDir = new ContextPanel(this.parent, this.filteredVariables.getVariable("SERVICE_VIRTUAL_DIRECTORY"), this.parent.langpack.getString("WindowsServicePanel.VirtualDir"), this);
        this.localPanel.add((Component)this.pnlServerService, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, GUIUtils.TITLED_INSETS_TOP, 0, 0));
        this.localPanel.add((Component)this.pnlVMOptions, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, GUIUtils.TITLED_INSETS_MIDDLE, 0, 0));
        this.localPanel.add((Component)this.pnlVirtualDir, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, GUIUtils.TITLED_INSETS_MIDDLE, 0, 0));
        this.localPanel.add((Component)new JPanel(), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 1, GUIUtils.INSETS_BOTTOM, 0, 0));
        ArrayList<JComponent> componentsForWidthCalculation = this.pnlVirtualDir.getComponentsForWidthCalculation();
        componentsForWidthCalculation.add(this.lblMaxMemory);
        componentsForWidthCalculation.add(this.lblServiceDisplayName);
        componentsForWidthCalculation.add(this.lblServiceName);
        componentsForWidthCalculation.add(this.lblVMOptions);
        this.recalcWidthForComponent(componentsForWidthCalculation);
        return this.localPanel;
    }

    private class DllFilter
    implements FileFilter {
        private DllFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory() || pathname.getName().equalsIgnoreCase("jvm.dll");
        }
    }

    class StopCCService
    extends Thread {
        StopCCService() {
        }

        @Override
        public void run() {
            try {
                Process p2 = Runtime.getRuntime().exec("net stop ClearReportsSVC", null);
                p2.waitFor();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class StopW3SVC
    extends Thread {
        StopW3SVC() {
        }

        @Override
        public void run() {
            Process p2;
            String sysdir = System.getenv("WINDIR") + "\\system32";
            File windir = new File(sysdir);
            try {
                p2 = Runtime.getRuntime().exec("net stop W3SVC", null, windir);
                p2.waitFor();
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                p2 = Runtime.getRuntime().exec("net start W3SVC", null, windir);
                p2.waitFor();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

