/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels.util;

import com.inet.setup.GUIUtils;
import com.izforge.izpack.util.OsVersion;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import javax.swing.JLabel;

public class CCHyperlink
extends JLabel {
    private static final long serialVersionUID = 1L;
    private LinkedList<ActionListener> actionListenerList = new LinkedList();
    private MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent me) {
            CCHyperlink.this.switchColor(GUIUtils.LINK_ACTIVE_COLOR);
        }

        @Override
        public void mouseExited(MouseEvent me) {
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            CCHyperlink.this.fireActionEvent();
        }
    };
    private ActionListener actionListener = new ActionListener(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void actionPerformed(ActionEvent e2) {
            URL url = null;
            try {
                url = new URL(CCHyperlink.this.link);
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
            }
            if (OsVersion.IS_WINDOWS) {
                try {
                    Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + CCHyperlink.this.link);
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            if (OsVersion.IS_LINUX) {
                String[] browserprocesses = new String[]{"thunderbird " + url.toString(), "evolution " + url.toString(), "gnome-open " + url.toString(), "kfmclient exec " + url.toString(), "sensible-browser " + url.toString(), "x-www-browser " + url.toString(), "netscape -remote openURL(" + url.toString() + ")", "netscape " + url.toString(), "firefox " + url.toString(), "opera " + url.toString(), "konqueror " + url.toString(), "epiphany " + url.toString(), "mozilla " + url.toString()};
                for (int p2 = 0; p2 < browserprocesses.length; ++p2) {
                    try {
                        Process process = Runtime.getRuntime().exec(browserprocesses[p2]);
                        int exitCode = process.waitFor();
                        if (exitCode != 0) continue;
                        return;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return;
            }
            if (!OsVersion.IS_MAC) return;
            try {
                Process process = Runtime.getRuntime().exec("open " + url.toString());
                int exitCode = process.waitFor();
                if (exitCode == 0) return;
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    };
    private String link;

    public CCHyperlink() {
        this("");
    }

    public CCHyperlink(String text) {
        this(text, text);
    }

    public CCHyperlink(String text, String link) {
        super(text);
        this.link = link;
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setForeground(GUIUtils.LINK_DEFAULT_COLOR);
        this.addMouseListener(this.mouseListener);
        this.addActionListener(this.actionListener);
    }

    public CCHyperlink(String text, ActionListener l2) {
        super(text);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setForeground(GUIUtils.LINK_DEFAULT_COLOR);
        this.addMouseListener(this.mouseListener);
        this.addActionListener(l2);
    }

    public void addActionListener(ActionListener l2) {
        if (!this.actionListenerList.contains(l2)) {
            this.actionListenerList.add(l2);
        }
    }

    public void removeActionListener(ActionListener l2) {
        this.actionListenerList.remove(l2);
    }

    protected void fireActionEvent() {
        ActionEvent e2 = new ActionEvent(this, 1001, this.getText());
        for (ActionListener l2 : this.actionListenerList) {
            l2.actionPerformed(e2);
        }
    }

    private void switchColor(Color c2) {
        this.setForeground(c2);
        this.repaint();
    }

    @Override
    public void paint(Graphics g2) {
        super.paint(g2);
        Rectangle2D textBounds = this.getFontMetrics(this.getFont()).getStringBounds(this.getText(), g2);
        int y2 = this.getHeight() / 2 + (int)(textBounds.getHeight() / 2.0);
        int w2 = (int)textBounds.getWidth();
        int x2 = this.getIcon() == null ? 0 : this.getIcon().getIconWidth() + this.getIconTextGap();
        g2.setColor(this.getForeground());
        g2.drawLine(0, y2, x2 + w2, y2);
    }
}

