/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels.util;

import com.inet.setup.panels.util.IPFilterValueInterface;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class IPFilterValues5
implements IPFilterValueInterface {
    @Override
    public String getAvailableIPAddresses() {
        ArrayList<Inet4Address> inet4AdressList = new ArrayList<Inet4Address>();
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface network = networkInterfaces.nextElement();
                Enumeration<InetAddress> inetAddresses = network.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress address = inetAddresses.nextElement();
                    if (!(address instanceof Inet4Address)) continue;
                    inet4AdressList.add((Inet4Address)address);
                }
            }
        }
        catch (SocketException e2) {
            return null;
        }
        return this.getFormatedIPAddresses(inet4AdressList);
    }

    private String getFormatedIPAddresses(List<Inet4Address> inet4AdressList) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Inet4Address inet4Address : inet4AdressList) {
            if (!first) {
                sb.append(",");
            }
            sb.append(inet4Address.getHostAddress());
            first = false;
        }
        return sb.toString();
    }
}

