/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels.util;

import com.inet.lib.util.IOFunctions;
import com.inet.setup.panels.util.IPFilterValueInterface;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class IPFilterValues6
implements IPFilterValueInterface {
    private static final boolean CALCULATE_DEFAULTS = true;
    private static final String[] DEFAULT_IPS_TO_PATCH = new String[]{"127.0.0.1", "fe80:0:0:0:0:0:0:1"};
    private static final String IPV6_LH_SHORT = "::1";
    private static final String IPV6_LH_LONG = "0:0:0:0:0:0:0:1";

    @Override
    public String getAvailableIPAddresses() {
        ArrayList<String> ipv6Addresses = new ArrayList<String>();
        HashMap<Inet4Address, Integer> inet4AdressMap = new HashMap<Inet4Address, Integer>();
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface network = networkInterfaces.nextElement();
                for (InterfaceAddress address : network.getInterfaceAddresses()) {
                    int percentIndex;
                    InetAddress inetAddress = address.getAddress();
                    if (inetAddress instanceof Inet4Address) {
                        Integer networkPrefixLength = address.getNetworkPrefixLength();
                        inet4AdressMap.put((Inet4Address)inetAddress, networkPrefixLength);
                        continue;
                    }
                    Inet6Address address6 = (Inet6Address)inetAddress;
                    short prefixLength = address.getNetworkPrefixLength();
                    String a6String = address6.toString();
                    if (a6String.startsWith("/")) {
                        a6String = a6String.substring(1);
                    }
                    if ((percentIndex = a6String.indexOf(37)) >= 0) {
                        a6String = a6String.substring(0, percentIndex);
                    }
                    if (ipv6Addresses.contains(a6String = this.computeWithPrefix(a6String, prefixLength))) continue;
                    ipv6Addresses.add(a6String);
                }
            }
        }
        catch (SocketException e2) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (String a2 : ipv6Addresses) {
            result.append(a2);
            result.append(",");
        }
        String ipv4String = this.getFormatedIPAddresses(inet4AdressMap).trim();
        result.append(ipv4String);
        if (result.length() > 0 && result.charAt(result.length() - 1) == ',') {
            result.setLength(result.length() - 1);
        }
        return this.patchAddressesWithDefaults(this.cleanUpDupes(result.toString()));
    }

    String patchAddressesWithDefaults(String addresses) {
        List<String> sourceAddressList = Arrays.asList(addresses.split(","));
        for (String defaultToPatch : DEFAULT_IPS_TO_PATCH) {
            if (sourceAddressList.contains(defaultToPatch)) continue;
            addresses = addresses + "," + defaultToPatch;
        }
        if (!addresses.contains(IPV6_LH_SHORT) && !addresses.contains(IPV6_LH_LONG)) {
            addresses = addresses + ",::1";
        }
        return addresses;
    }

    String cleanUpDupes(String input) {
        ArrayList<String> finalAddressList = new ArrayList<String>();
        List<String> sourceAddressList = Arrays.asList(input.split(","));
        for (String address : sourceAddressList) {
            if (!address.contains("-") || finalAddressList.contains(address)) continue;
            finalAddressList.add(address);
        }
        for (String address : sourceAddressList) {
            if (address.contains("-") || finalAddressList.contains(address)) continue;
            boolean wasAlreadyInRange = false;
            for (String range : finalAddressList) {
                String[] r2 = range.split("\\s*-\\s*");
                try {
                    if (IOFunctions.compareIPAdress(r2[0], address) > 0 || IOFunctions.compareIPAdress(r2[1], address) < 0) continue;
                    wasAlreadyInRange = true;
                    break;
                }
                catch (Exception e2) {
                }
            }
            if (wasAlreadyInRange) continue;
            finalAddressList.add(address);
        }
        StringBuilder result = new StringBuilder();
        for (String string : finalAddressList) {
            result.append(string);
            result.append(',');
        }
        if (result.length() > 0) {
            result.setLength(result.length() - 1);
        }
        return result.toString();
    }

    String computeWithPrefix(String a6String, int prefixLength) {
        int index;
        if (prefixLength == 128) {
            return a6String.trim();
        }
        StringBuilder result = new StringBuilder();
        String[] parts = a6String.split(":");
        for (index = 0; prefixLength >= 16 && index < parts.length; prefixLength -= 16, ++index) {
            result.append(parts[index]);
            result.append(":");
        }
        StringBuilder fromAddress = new StringBuilder(result.toString());
        if (prefixLength > 0) {
            int fromMask = 65535;
            int toMask = 65535;
            int shiftBy = 16 - prefixLength;
            toMask >>= prefixLength;
            String partToMask = parts[index++];
            int partialPart = Integer.valueOf(partToMask, 16);
            fromAddress.append(Integer.toString(partialPart & (fromMask <<= shiftBy), 16));
            fromAddress.append(":");
            result.append(Integer.toString(partialPart | toMask, 16));
            result.append(":");
        }
        while (index < parts.length) {
            result.append("ffff");
            result.append(":");
            fromAddress.append("0");
            fromAddress.append(":");
            ++index;
        }
        result.setLength(result.length() - 1);
        fromAddress.setLength(fromAddress.length() - 1);
        return fromAddress.toString().trim() + "-" + result.toString().trim();
    }

    private String getFormatedIPAddresses(HashMap<Inet4Address, Integer> inet4AdressMap) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        Set<Inet4Address> keySet = inet4AdressMap.keySet();
        for (Inet4Address inet4Address : keySet) {
            if (!first) {
                sb.append(",");
            }
            if (inet4Address.isLoopbackAddress()) {
                sb.append(inet4Address.getHostAddress());
            } else {
                String areaMin = this.getIPv4Min(inet4Address.getAddress(), inet4AdressMap.get(inet4Address));
                String areaMax = this.getIPv4Max(inet4Address.getAddress(), inet4AdressMap.get(inet4Address));
                sb.append(areaMin);
                if (!areaMin.equals(areaMax)) {
                    sb.append("-");
                    sb.append(areaMax);
                }
            }
            first = false;
        }
        return sb.toString();
    }

    String getIPv4Min(byte[] ipAdress, Integer prefixLength) {
        StringBuilder b2 = new StringBuilder();
        int[] maskIPv4 = this.createIPv4Mask(prefixLength);
        byte[] min = new byte[ipAdress.length];
        boolean first = true;
        for (int i2 = 0; i2 < min.length; ++i2) {
            min[i2] = (byte)(ipAdress[i2] & maskIPv4[i2]);
            if (!first) {
                b2.append('.');
            }
            b2.append(min[i2] & 0xFF);
            first = false;
        }
        return b2.toString();
    }

    String getIPv4Max(byte[] ipAdress, Integer prefixLength) {
        StringBuilder b2 = new StringBuilder();
        int[] maskIPv4 = this.createIPv4Mask(prefixLength);
        byte[] max = new byte[ipAdress.length];
        boolean first = true;
        for (int i2 = 0; i2 < max.length; ++i2) {
            max[i2] = (byte)(ipAdress[i2] | ~maskIPv4[i2]);
            if (!first) {
                b2.append('.');
            }
            b2.append(max[i2] & 0xFF);
            first = false;
        }
        return b2.toString();
    }

    int[] createIPv4Mask(int prefixLength) {
        if (prefixLength == 0) {
            return new int[]{0, 0, 0, 0};
        }
        int mask = -1;
        int shiftBy = 32 - prefixLength;
        if (shiftBy > 0) {
            mask <<= shiftBy;
        }
        int[] maskIPv4 = new int[]{mask >>> 24, mask << 8 >>> 24, mask << 16 >>> 24, mask << 24 >>> 24};
        return maskIPv4;
    }
}

