/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels.util;

import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.installer.ResourceNotFoundException;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class InfoImage
extends JLabel {
    private ImageIcon helpIconRollover;
    private ImageIcon helpIconDisabled;

    public InfoImage(final String tooltip) {
        try {
            this.helpIconDisabled = ResourceManager.getInstance().getImageIconResource("com/inet/setup/images/installer.image.help_dis.png");
            this.helpIconRollover = ResourceManager.getInstance().getImageIconResource("com/inet/setup/images/installer.image.help.png");
        }
        catch (ResourceNotFoundException e2) {
            e2.printStackTrace();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        this.setIcon(this.helpIconDisabled);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e2) {
                super.mouseMoved(e2);
                Point mouse = new Point(e2.getX(), e2.getY());
                Point base = new Point(10, 14);
                if (InfoImage.this.isEnabled()) {
                    if (mouse.distance(base) <= 10.0) {
                        InfoImage.this.setIcon(InfoImage.this.helpIconRollover);
                        InfoImage.this.setToolTipText(tooltip);
                    } else {
                        InfoImage.this.setIcon(InfoImage.this.helpIconDisabled);
                        InfoImage.this.setToolTipText(null);
                    }
                } else {
                    InfoImage.this.setToolTipText(null);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e2) {
                super.mouseExited(e2);
                InfoImage.this.setIcon(InfoImage.this.helpIconDisabled);
                InfoImage.this.setToolTipText(null);
            }

            @Override
            public void mouseReleased(MouseEvent e2) {
                super.mouseReleased(e2);
                Point mouse = new Point(e2.getX(), e2.getY());
                Point base = new Point(10, 10);
                if (InfoImage.this.isEnabled()) {
                    if (mouse.distance(base) <= 10.0) {
                        InfoImage.this.setIcon(InfoImage.this.helpIconRollover);
                        InfoImage.this.setToolTipText(tooltip);
                    } else {
                        InfoImage.this.setIcon(InfoImage.this.helpIconDisabled);
                        InfoImage.this.setToolTipText(null);
                    }
                } else {
                    InfoImage.this.setToolTipText(null);
                }
            }
        });
    }
}

