/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels.util;

import com.inet.setup.GUIUtils;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import javax.swing.JLabel;

public class JHyperLink
extends JLabel {
    private static final long serialVersionUID = 1L;
    private LinkedList<ActionListener> actionListenerList = new LinkedList();
    private MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent me) {
            JHyperLink.this.switchColor(GUIUtils.LINK_ACTIVE_COLOR);
        }

        @Override
        public void mouseExited(MouseEvent me) {
            JHyperLink.this.switchColor(GUIUtils.LINK_DEFAULT_COLOR);
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            JHyperLink.this.fireActionEvent();
        }
    };

    public JHyperLink() {
        this("");
    }

    public JHyperLink(String text) {
        super(text);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setForeground(GUIUtils.LINK_DEFAULT_COLOR);
        this.addMouseListener(this.mouseListener);
    }

    public void addActionListener(ActionListener l2) {
        if (!this.actionListenerList.contains(l2)) {
            this.actionListenerList.add(l2);
        }
    }

    public void removeActionListener(ActionListener l2) {
        this.actionListenerList.remove(l2);
    }

    protected void fireActionEvent() {
        ActionEvent e2 = new ActionEvent(this, 1001, this.getText());
        for (ActionListener l2 : this.actionListenerList) {
            l2.actionPerformed(e2);
        }
    }

    private void switchColor(Color c2) {
        this.setForeground(c2);
        this.repaint();
    }

    @Override
    public void paint(Graphics g2) {
        super.paint(g2);
        Rectangle2D textBounds = this.getFontMetrics(this.getFont()).getStringBounds(this.getText(), g2);
        int y2 = this.getHeight() / 2 + (int)(textBounds.getHeight() / 2.0);
        int w2 = (int)textBounds.getWidth();
        int x2 = this.getIcon() == null ? 0 : this.getIcon().getIconWidth() + this.getIconTextGap();
        g2.setColor(this.getForeground());
        g2.drawLine(0, y2, x2 + w2, y2);
    }
}

