/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels.util;

import java.util.HashMap;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;

public class JsonCreator {
    private static boolean jsonDebug = Boolean.toString(true).equalsIgnoreCase(System.getProperty("setup.jsonDebug", "false"));

    public static String createJsonFromMap(HashMap<String, String> map) {
        Set<String> keySet = map.keySet();
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        boolean first = true;
        for (String key : keySet) {
            if (!first) {
                sb.append(",");
            }
            if (jsonDebug) {
                sb.append("\"" + new String(key) + "\"");
            } else {
                sb.append("\"" + new String(Base64.encodeBase64(key.getBytes())) + "\"");
            }
            sb.append(":");
            if (jsonDebug) {
                sb.append("\"" + new String(map.get(key)) + "\"");
            } else {
                sb.append("\"" + new String(Base64.encodeBase64(map.get(key).getBytes())) + "\"");
            }
            first = false;
        }
        sb.append("}");
        return sb.toString();
    }

    public static HashMap<String, String> createMapFromJson(String json) {
        HashMap<String, String> map = new HashMap<String, String>();
        if ((json = json.trim()).length() == 0) {
            return new HashMap<String, String>();
        }
        if (json.startsWith("{") && json.endsWith("}")) {
            String[] jsonObjects;
            if ((json = json.substring(1, json.length() - 1)).trim().length() == 0) {
                return new HashMap<String, String>();
            }
            for (String jsonObject : jsonObjects = json.split(",")) {
                String[] jsonObjectParts = jsonObject.split(":");
                if (jsonObjectParts.length != 2) {
                    throw new IllegalArgumentException(json + " is not expected JSON object");
                }
                String key = jsonObjectParts[0].trim();
                key = key.substring(1, key.length() - 1);
                String value = jsonObjectParts[1].trim();
                value = value.substring(1, value.length() - 1);
                if (jsonDebug) {
                    map.put(key, value);
                    continue;
                }
                map.put(new String(Base64.decodeBase64(key.getBytes())), new String(Base64.decodeBase64(value.getBytes())));
            }
            return map;
        }
        throw new IllegalArgumentException(json + " is not expected JSON object");
    }
}

