/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels.widget;

import com.inet.report.config.ConfigurationManager;
import com.inet.setup.panels.AbstractPanel;
import com.inet.setup.panels.widget.ScopeItem;
import com.inet.setup.panels.widget.Selectable;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.util.Debug;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class ConfigurationInputPanel
extends JPanel
implements Selectable {
    private static final long serialVersionUID = 1L;
    private JComboBox cmbboxScope;
    private JTextField txtName;
    private final AbstractPanel absPanel;
    private final InstallerFrame parent;
    private boolean isEditedByUser = false;
    private boolean showUserName;
    private String userName;
    private int allowedScope;
    private int preselectedScope = -1;

    public ConfigurationInputPanel(InstallerFrame parent, int allowedScope, int preselectedScope, String userName, AbstractPanel absPanel, boolean showUserName) {
        this.parent = parent;
        this.allowedScope = allowedScope;
        this.preselectedScope = preselectedScope;
        this.userName = userName;
        this.absPanel = absPanel;
        this.showUserName = showUserName;
        this.setLayout(new GridBagLayout());
        this.cmbboxScope = new JComboBox();
        this.cmbboxScope.setName("cmbboxScope");
        this.initBox();
        this.cmbboxScope.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                if (e2.getStateChange() == 1 && ConfigurationInputPanel.this.cmbboxScope.getClientProperty("ignore") == null) {
                    ScopeItem si = (ScopeItem)e2.getItem();
                    ConfigurationInputPanel.this.setCurrentScope(si.getScopeValue());
                }
            }
        });
        JLabel lblDummyScope = new JLabel(parent.langpack.getString("CCPropertiesPanel.scope_title"));
        lblDummyScope.setName("lblDummyScope");
        lblDummyScope.setLabelFor(this.cmbboxScope);
        this.txtName = new JTextField();
        this.txtName.setDocument(new PlainDocument(){

            @Override
            public void insertString(int offs, String str, AttributeSet a2) throws BadLocationException {
                if (str.length() > 1) {
                    str = str.replaceAll("[^\\$\\-_\\.\\+!'\\(\\),0-9a-zA-Z]", "");
                    super.insertString(offs, str, a2);
                    return;
                }
                if (str.matches("[\\$\\-_\\.\\+!'\\(\\),0-9a-zA-Z]")) {
                    super.insertString(offs, str, a2);
                    return;
                }
            }
        });
        this.txtName.setName("txtName");
        this.txtName.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e2) {
                ConfigurationInputPanel.this.isEditedByUser = true;
            }

            @Override
            public void keyReleased(KeyEvent e2) {
                ConfigurationInputPanel.this.isEditedByUser = true;
            }

            @Override
            public void keyPressed(KeyEvent e2) {
                ConfigurationInputPanel.this.isEditedByUser = true;
            }
        });
        JLabel lblDummyName = new JLabel(parent.langpack.getString("CCPropertiesPanel.edit_name"));
        lblDummyName.setName("lblDummyName");
        lblDummyName.setLabelFor(this.txtName);
        this.add((Component)this.cmbboxScope, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.txtName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
    }

    public void updateBox(int allowedScope1, int preselectedScope1) {
        this.allowedScope = allowedScope1;
        this.preselectedScope = preselectedScope1;
        this.initBox();
    }

    private void initBox() {
        this.cmbboxScope.putClientProperty("ignore", Boolean.TRUE);
        this.cmbboxScope.removeAllItems();
        Debug.log("------------------------------");
        Debug.log("SystemScope: 1 " + ConfigurationManager.isWriteable(1) + " " + ConfigurationManager.isReadable(1));
        Debug.log("UserScope: 2 " + ConfigurationManager.isWriteable(2) + " " + ConfigurationManager.isReadable(2));
        Debug.log("TempScope: 4 " + ConfigurationManager.isWriteable(4) + " " + ConfigurationManager.isReadable(4));
        Debug.log("allowedScope: " + this.allowedScope);
        Debug.log("------------------------------");
        if (1 != this.allowedScope && ConfigurationManager.isWriteable(2)) {
            this.cmbboxScope.addItem(new ScopeItem(this.parent, 2, this.userName, this.showUserName));
        }
        if (ConfigurationManager.isWriteable(1)) {
            this.cmbboxScope.addItem(new ScopeItem(this.parent, 1, this.userName, this.showUserName));
        }
        if (this.cmbboxScope.getModel().getSize() == 0) {
            this.cmbboxScope.addItem(new ScopeItem(this.parent, 4, this.userName, this.showUserName));
        }
        this.cmbboxScope.putClientProperty("ignore", null);
        if (this.preselectedScope != -1) {
            for (int i2 = 0; i2 < this.cmbboxScope.getModel().getSize(); ++i2) {
                ScopeItem elementAt = (ScopeItem)this.cmbboxScope.getModel().getElementAt(i2);
                if (elementAt.getScopeValue() != this.preselectedScope) continue;
                this.cmbboxScope.setSelectedIndex(i2);
            }
        } else {
            this.cmbboxScope.setSelectedIndex(0);
        }
    }

    public String getConfigScope() {
        return ((ScopeItem)this.cmbboxScope.getSelectedItem()).getScopeName();
    }

    public int getConfigScopeValue() {
        return ((ScopeItem)this.cmbboxScope.getSelectedItem()).getScopeValue();
    }

    public void setConfigName(String name) {
        if (!this.isEditedByUser) {
            this.txtName.setText(name.trim());
        }
    }

    public String getConfigName() {
        return this.txtName.getText().trim();
    }

    public String getSelectedConfigurationName() {
        return ((ScopeItem)this.cmbboxScope.getSelectedItem()).getScopeName();
    }

    public int getSelectedConfigurationValue() {
        return ((ScopeItem)this.cmbboxScope.getSelectedItem()).getScopeValue();
    }

    public String getConfigForSummary() {
        return this.cmbboxScope.getSelectedItem().toString() + " / " + this.getConfigName();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.cmbboxScope.setEnabled(enabled);
        this.txtName.setEnabled(enabled);
    }

    @Override
    public JComponent isValidated() {
        if (this.getConfigName().length() == 0) {
            this.absPanel.emitError(null, this.parent.langpack.getString("CCPropertiesPanel.no_name"));
            return this.txtName;
        }
        return null;
    }

    private void setCurrentScope(int i2) {
        this.preselectedScope = i2;
    }
}

