/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels.widget;

import com.inet.report.config.Configuration;
import com.inet.report.config.ConfigurationManager;
import com.inet.setup.Constants;
import com.inet.setup.panels.widget.ConfigurationItem;
import com.izforge.izpack.installer.InstallerFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class ConfigurationSelectionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final InstallerFrame parent;
    private JComboBox boxAvailableConfiguration;
    private JPanel pnlActiveConfigurationDialog;
    private String userName;
    private boolean forceDisabled = false;
    private int allowedScope;
    private int preselectedScope;
    private ConfigurationItem configurationItem = null;

    public ConfigurationSelectionPanel(InstallerFrame parent, int preselectedScope, String defaultConfiguration, int allowedScope, String userName) {
        this.parent = parent;
        this.allowedScope = allowedScope;
        this.userName = userName;
        this.preselectedScope = preselectedScope;
        this.setLayout(new BorderLayout());
        this.add((Component)this.createConfigSelectionPanel(), "Center");
        this.initBox();
        this.boxAvailableConfiguration.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                if (e2.getStateChange() == 1 && ConfigurationSelectionPanel.this.boxAvailableConfiguration.getClientProperty("ignore") == null) {
                    ConfigurationSelectionPanel.this.setAvailableConfiguration((ConfigurationItem)e2.getItem());
                }
            }
        });
    }

    private JPanel createConfigSelectionPanel() {
        this.pnlActiveConfigurationDialog = new JPanel(new GridBagLayout());
        this.pnlActiveConfigurationDialog.setName("pnlActiveConfigurationDialog");
        this.boxAvailableConfiguration = new JComboBox();
        this.boxAvailableConfiguration.setName("boxAvailableConfiguration");
        this.pnlActiveConfigurationDialog.add((Component)this.boxAvailableConfiguration, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        return this.pnlActiveConfigurationDialog;
    }

    public void updateBox(int allowedScope1, int preselectedScope1) {
        this.allowedScope = allowedScope1;
        this.preselectedScope = preselectedScope1;
        this.initBox();
        this.reselectDefault();
    }

    private void initBox() {
        Configuration configuration;
        int i2;
        this.boxAvailableConfiguration.putClientProperty("ignore", Boolean.TRUE);
        Configuration[] system_confs = null;
        Configuration[] user_confs = null;
        this.boxAvailableConfiguration.removeAllItems();
        int currentBoxSize = 0;
        try {
            if (1 != this.allowedScope && ConfigurationManager.isReadable(2)) {
                user_confs = this.getConfigurations(2);
                for (i2 = 0; i2 < user_confs.length; ++i2) {
                    configuration = user_confs[i2];
                    if ("Default".equalsIgnoreCase(configuration.getName())) {
                        this.boxAvailableConfiguration.insertItemAt(new ConfigurationItem(configuration, this.parent, this.userName), 0);
                        continue;
                    }
                    this.boxAvailableConfiguration.addItem(new ConfigurationItem(configuration, this.parent, this.userName));
                }
            }
            currentBoxSize = this.boxAvailableConfiguration.getModel().getSize();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        try {
            if (ConfigurationManager.isReadable(1)) {
                system_confs = this.getConfigurations(1);
                for (i2 = 0; i2 < system_confs.length; ++i2) {
                    configuration = system_confs[i2];
                    if ("Default".equalsIgnoreCase(configuration.getName())) {
                        this.boxAvailableConfiguration.insertItemAt(new ConfigurationItem(configuration, this.parent, this.userName), currentBoxSize);
                        continue;
                    }
                    this.boxAvailableConfiguration.addItem(new ConfigurationItem(configuration, this.parent, this.userName));
                }
            }
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
        this.boxAvailableConfiguration.setSelectedIndex(-1);
        this.reselectDefault();
        this.boxAvailableConfiguration.putClientProperty("ignore", null);
    }

    private void reselectDefault() {
        if (this.configurationItem != null) {
            this.boxAvailableConfiguration.getModel().setSelectedItem(this.configurationItem);
        }
        if (this.boxAvailableConfiguration.getSelectedItem() != null) {
            this.forceDisabled(false);
            return;
        }
        if (this.boxAvailableConfiguration.getItemCount() > 0) {
            int index = 0;
            for (int i2 = 0; i2 < this.boxAvailableConfiguration.getItemCount(); ++i2) {
                if (((ConfigurationItem)this.boxAvailableConfiguration.getItemAt(i2)).getScopeValue() != this.preselectedScope) continue;
                index = i2;
                break;
            }
            this.forceDisabled(false);
            this.boxAvailableConfiguration.setSelectedIndex(index);
        } else {
            this.forceDisabled(true);
        }
    }

    public String getConfigScope() {
        if (this.boxAvailableConfiguration.getModel().getSize() > 0) {
            ConfigurationItem selectedItem = (ConfigurationItem)this.boxAvailableConfiguration.getSelectedItem();
            return Constants.getScopeName(selectedItem.getConfiguration().getScope());
        }
        return "temp";
    }

    public String getConfigName() {
        if (this.boxAvailableConfiguration.getModel().getSize() > 0) {
            ConfigurationItem selectedItem = (ConfigurationItem)this.boxAvailableConfiguration.getSelectedItem();
            return selectedItem.getConfigurationName();
        }
        return "";
    }

    public String getConfig() {
        if (this.boxAvailableConfiguration.getModel().getSize() > 0) {
            return ((ConfigurationItem)this.boxAvailableConfiguration.getModel().getSelectedItem()).getConfiguration().toString();
        }
        return "";
    }

    public String getConfigForSummary() {
        if (this.boxAvailableConfiguration.getModel().getSize() > 0) {
            return ((ConfigurationItem)this.boxAvailableConfiguration.getModel().getSelectedItem()).toString();
        }
        return "";
    }

    private Configuration[] getConfigurations(int scope) {
        Configuration[] system_confs = ConfigurationManager.getInstance().getAll(scope);
        Arrays.sort(system_confs, new Comparator<Configuration>(){

            @Override
            public int compare(Configuration o1, Configuration o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        return system_confs;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.forceDisabled) {
            super.setEnabled(false);
            this.boxAvailableConfiguration.setEnabled(false);
            this.pnlActiveConfigurationDialog.setEnabled(false);
            return;
        }
        super.setEnabled(enabled);
        this.boxAvailableConfiguration.setEnabled(enabled);
        this.pnlActiveConfigurationDialog.setEnabled(enabled);
    }

    private void forceDisabled(boolean b2) {
        this.forceDisabled = b2;
    }

    public boolean hasConfigurations() {
        return this.boxAvailableConfiguration != null && this.boxAvailableConfiguration.getItemCount() > 0;
    }

    public boolean isForceDisabled() {
        return this.forceDisabled;
    }

    public void setPreselectedScope(int preselectedScope1) {
        this.preselectedScope = preselectedScope1;
        this.reselectDefault();
    }

    private void setAvailableConfiguration(ConfigurationItem configurationItem) {
        this.configurationItem = configurationItem;
    }

    public void setSelectedConfiguration(Configuration config) {
        int itemCount = this.boxAvailableConfiguration.getItemCount();
        for (int i2 = 0; i2 < itemCount; ++i2) {
            ConfigurationItem ci2 = (ConfigurationItem)this.boxAvailableConfiguration.getItemAt(i2);
            if (!ci2.getConfiguration().equals(config)) continue;
            this.boxAvailableConfiguration.setSelectedIndex(i2);
            return;
        }
    }
}

