/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels.widget;

import com.inet.setup.GUIUtils;
import com.inet.setup.panels.AbstractPanel;
import com.inet.setup.panels.widget.Selectable;
import com.izforge.izpack.installer.InstallerFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class ContextPanel
extends JPanel
implements Selectable {
    private final InstallerFrame parent;
    private JLabel lblServletContext;
    private JTextField txtServletContext;
    private final String defaultContext;
    private final AbstractPanel absPanel;
    private final String panelTitle;
    private String errorMsg = "";

    public ContextPanel(InstallerFrame parent, String defaultContext, AbstractPanel absPanel, String errorMsg) {
        this(parent, defaultContext, parent.langpack.getString("ServletPanel.servletContext"), absPanel, errorMsg);
    }

    public ContextPanel(InstallerFrame parent, String defaultContext, AbstractPanel absPanel) {
        this(parent, defaultContext, parent.langpack.getString("ServletPanel.servletContext"), absPanel, parent.langpack.getString("installer.noServletContext"));
    }

    public ContextPanel(InstallerFrame parent, String defaultContext, String panelTitle, AbstractPanel absPanel) {
        this(parent, defaultContext, panelTitle, absPanel, parent.langpack.getString("installer.noServletContext"));
    }

    public ContextPanel(InstallerFrame parent, String defaultContext, String panelTitle, AbstractPanel absPanel, String errorMsg) {
        this.panelTitle = panelTitle;
        this.parent = parent;
        this.defaultContext = defaultContext;
        this.absPanel = absPanel;
        this.errorMsg = errorMsg;
        this.setLayout(new BorderLayout());
        this.add((Component)this.createContextPanel(), "Center");
    }

    private JPanel createContextPanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new GridBagLayout());
        pnl.setBorder(BorderFactory.createTitledBorder(this.panelTitle));
        this.lblServletContext = new JLabel(this.parent.langpack.getString(this.absPanel.getClass().getSimpleName() + ".servletContext") + ":");
        this.lblServletContext.setName("lblServletContext");
        this.txtServletContext = new JTextField();
        this.txtServletContext.setName("txtServletContext");
        this.txtServletContext.setDocument(new PlainDocument(){

            @Override
            public void insertString(int offs, String str, AttributeSet a2) throws BadLocationException {
                if (str.length() > 1) {
                    str = str.replaceAll("[^\\$\\-_\\.\\+!'\\(\\),0-9a-zA-Z]", "");
                    super.insertString(offs, str, a2);
                    return;
                }
                if (str.matches("[\\$\\-_\\.\\+!'\\(\\),0-9a-zA-Z]")) {
                    super.insertString(offs, str, a2);
                    return;
                }
            }
        });
        this.txtServletContext.setText(this.defaultContext);
        this.lblServletContext.setLabelFor(this.txtServletContext);
        pnl.add((Component)this.lblServletContext, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 17, 2, GUIUtils.COMPONENT_INSETS_MIDDLE_HALF, 0, 0));
        pnl.add((Component)this.txtServletContext, new GridBagConstraints(1, 1, 2, 1, 1.0, 1.0, 17, 2, GUIUtils.COMPONENT_INSETS_MIDDLE_HALF, 0, 0));
        return pnl;
    }

    public ArrayList<JComponent> getComponentsForWidthCalculation() {
        ArrayList<JComponent> comp = new ArrayList<JComponent>();
        comp.add(this.lblServletContext);
        return comp;
    }

    public String getContext() {
        return this.txtServletContext.getText().trim();
    }

    public JComponent getContextBox() {
        return this.txtServletContext;
    }

    @Override
    public JComponent isValidated() {
        if (!this.isVisible()) {
            return null;
        }
        if (!this.getContext().trim().matches("[\\$\\-_\\.\\+!'\\(\\),0-9a-zA-Z]+")) {
            this.absPanel.emitError(this.parent.langpack.getString("installer.error"), this.errorMsg);
            return this.txtServletContext;
        }
        return null;
    }
}

