/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels.widget;

import com.inet.setup.GUIUtils;
import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsVersion;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DrivesRenderPanel
extends JPanel
implements Comparable<DrivesRenderPanel> {
    private JLabel lblDrive;
    private File drive;
    private JLabel lblFreeSpaceText;
    private JLabel lblFreeSpaceValue;
    private JFileChooser chooser = new JFileChooser();

    public DrivesRenderPanel(File drive, InstallerFrame parent) {
        this.chooser.setLocale(Locale.getDefault());
        this.chooser.updateUI();
        this.setLayout(new BorderLayout(10, 0));
        this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.lblDrive = new JLabel("", 2){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension preferredSize = super.getPreferredSize();
                preferredSize.width = 300;
                return preferredSize;
            }
        };
        this.setCurrentDrive(drive);
        long freeSpace = IoHelper.getFreeSpace(this.getCurrentDrive().getAbsolutePath());
        String freeSpaceText = parent.langpack.getString("CCPathPanel.freespace") + ": ";
        String freeSpaceValue = "";
        freeSpaceValue = freeSpace >= 0L ? Pack.toByteUnitsString(freeSpace) : "n/a";
        String systemDisplayName = "";
        try {
            systemDisplayName = OsVersion.IS_LINUX ? drive.getPath() : this.chooser.getName(drive);
            this.lblDrive.setText(GUIUtils.clipString(systemDisplayName, 250, this.lblDrive.getFontMetrics(this.lblDrive.getFont()), true));
            this.lblDrive.setIcon(this.chooser.getIcon(drive));
            this.lblDrive.setIconTextGap(10);
            this.lblFreeSpaceText = new JLabel(freeSpaceText, 2);
            this.lblFreeSpaceValue = new JLabel(freeSpaceValue, 4){

                @Override
                public Dimension getPreferredSize() {
                    Dimension preferredSize = super.getPreferredSize();
                    preferredSize.width = Math.max(100, preferredSize.width);
                    return preferredSize;
                }
            };
        }
        catch (Exception e2) {
            Debug.error(e2, this.getClass());
        }
        this.setToolTipText(systemDisplayName);
        this.add((Component)this.lblDrive, "West");
        this.add((Component)new JLabel(), "Center");
        JPanel compFreeSpace = new JPanel(new BorderLayout());
        compFreeSpace.setOpaque(false);
        compFreeSpace.add((Component)this.lblFreeSpaceText, "Center");
        compFreeSpace.add((Component)this.lblFreeSpaceValue, "East");
        this.add((Component)compFreeSpace, "East");
    }

    public void setCurrentDrive(File drive) {
        this.drive = drive;
    }

    public File getCurrentDrive() {
        return this.drive;
    }

    @Override
    public int compareTo(DrivesRenderPanel o2) {
        return this.getCurrentDrive().getAbsolutePath().compareToIgnoreCase(o2.getCurrentDrive().getAbsolutePath());
    }
}

