/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels.widget;

import com.inet.setup.panels.AbstractPanel;
import com.inet.setup.panels.widget.Controllable;
import com.inet.setup.panels.widget.Selectable;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.installer.ResourceNotFoundException;
import com.izforge.izpack.util.Debug;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class GeneralConfigPanel
extends JPanel
implements Selectable,
Controllable {
    private static final long serialVersionUID = 1L;
    private final String defaultPort;
    private final InstallerFrame parent;
    private JLabel lblPort;
    private JTextField txtPort;
    private JLabel lblActivateRemote;
    private JCheckBox chkboxActivateRemote;
    private JLabel lblActivateAdhoc;
    private JCheckBox chkboxActivateAdhoc;
    private final AbstractPanel absPanel;
    private LocalBehavior localBehavior = new LocalBehavior();
    private ArrayList<ActionListener> listener = new ArrayList();

    public GeneralConfigPanel(InstallerFrame parent, String defaultPort, AbstractPanel absPanel) {
        this.parent = parent;
        this.defaultPort = defaultPort;
        this.absPanel = absPanel;
        this.setBorder(BorderFactory.createTitledBorder(parent.langpack.getString("CCConfigPanel.general")));
        this.lblPort = new JLabel(parent.langpack.getString(absPanel.getClass().getSimpleName() + ".port") + ":");
        this.txtPort = new JTextField(defaultPort);
        this.txtPort.setDocument(new PlainDocument(){

            @Override
            public void insertString(int offs, String str, AttributeSet a2) throws BadLocationException {
                if (str.matches("[0-9]*")) {
                    super.insertString(offs, str, a2);
                    return;
                }
            }
        });
        this.txtPort.setText(defaultPort);
        this.txtPort.setName("txtPort");
        this.lblPort.setLabelFor(this.txtPort);
        this.chkboxActivateRemote = new JCheckBox();
        this.chkboxActivateRemote.setSelected(true);
        this.chkboxActivateRemote.setName("chkboxActivateRemote");
        this.chkboxActivateRemote.addActionListener(this.localBehavior);
        this.lblActivateRemote = new JLabel(parent.langpack.getString("CCConfigPanel.remote.activate") + ":");
        this.lblActivateRemote.setLabelFor(this.chkboxActivateRemote);
        this.chkboxActivateAdhoc = new JCheckBox();
        this.chkboxActivateAdhoc.setName("chkboxActivateAdhoc");
        this.chkboxActivateAdhoc.setSelected(true);
        this.lblActivateAdhoc = new JLabel(parent.langpack.getString("AdhocActivationPanel.activateAdhoc") + ":");
        this.lblActivateAdhoc.setName("lblActivateAdhoc");
        this.lblActivateAdhoc.setLabelFor(this.chkboxActivateAdhoc);
        this.addComponents();
    }

    private void addComponents() {
        double[] dArray;
        this.removeAll();
        double b2 = 10.0;
        double l2 = -2.0;
        double hs = 10.0;
        double el2 = -1.0;
        double[][] dArrayArray = new double[2][];
        dArrayArray[0] = new double[]{b2, l2, hs, l2, hs, el2, b2};
        if (this.isServerInstallation()) {
            double[] dArray2 = new double[7];
            dArray2[0] = b2;
            dArray2[1] = l2;
            dArray2[2] = b2;
            dArray2[3] = l2;
            dArray2[4] = b2;
            dArray2[5] = l2;
            dArray = dArray2;
            dArray2[6] = b2;
        } else {
            double[] dArray3 = new double[7];
            dArray3[0] = 0.0;
            dArray3[1] = 0.0;
            dArray3[2] = b2;
            dArray3[3] = l2;
            dArray3[4] = b2;
            dArray3[5] = l2;
            dArray = dArray3;
            dArray3[6] = b2;
        }
        dArrayArray[1] = dArray;
        double[][] sizes = dArrayArray;
        this.setLayout(new TableLayout(sizes));
        if (this.isServerInstallation()) {
            this.add((Component)this.lblPort, "1,1");
            this.add((Component)this.txtPort, "5,1");
        }
        ImageIcon imageIconResource = null;
        try {
            imageIconResource = ResourceManager.getInstance().getImageIconResource("com/inet/setup/images/Info12.png");
        }
        catch (ResourceNotFoundException e2) {
            Debug.error(e2, this.getClass());
        }
        catch (IOException e3) {
            Debug.error(e3, this.getClass());
        }
        JLabel lblRemoteInfo = new JLabel(imageIconResource);
        lblRemoteInfo.setToolTipText(this.parent.langpack.getString("CCConfigPanel.activate_remote_info"));
        JLabel lblAdhocInfo = new JLabel(imageIconResource);
        lblAdhocInfo.setToolTipText(this.parent.langpack.getString("CCConfigPanel.activate_adhoc_info"));
        this.add((Component)this.lblActivateRemote, "1,3");
        this.add((Component)lblRemoteInfo, "3,3");
        this.add((Component)this.chkboxActivateRemote, "5,3");
        this.add((Component)this.lblActivateAdhoc, "1,5");
        this.add((Component)lblAdhocInfo, "3,5");
        this.add((Component)this.chkboxActivateAdhoc, "5,5");
    }

    public String getPort() {
        return this.txtPort.getText().trim();
    }

    public void setPort(String port) {
        this.txtPort.setText(port);
    }

    public void setPortLabel(String panelClassName) {
        this.lblPort.setText(this.parent.langpack.getString(panelClassName + ".port") + ":");
    }

    public void setAdhocSelected(boolean b2) {
        this.chkboxActivateAdhoc.setSelected(b2);
    }

    public boolean isAdhocSelected() {
        return this.chkboxActivateAdhoc.isSelected();
    }

    public boolean isActivateRemote() {
        return this.chkboxActivateRemote.isSelected();
    }

    public void setActivateRemote(boolean activateRemote) {
        this.chkboxActivateRemote.setSelected(activateRemote);
    }

    @Override
    public JComponent isValidated() {
        if (!this.isVisible()) {
            return null;
        }
        if (!this.txtPort.getText().trim().matches("[0-9]*")) {
            this.absPanel.emitError(null, this.parent.langpack.getString("CCConfigPanel.onlyNumbersAllowed"));
            return this.txtPort;
        }
        if (this.txtPort.getText().length() == 0) {
            this.txtPort.setText(this.defaultPort);
            return this.txtPort;
        }
        if (Integer.parseInt(this.txtPort.getText().trim()) > 65535 || Integer.parseInt(this.txtPort.getText().trim()) < 0) {
            this.absPanel.emitError(null, this.parent.langpack.getString("CCConfigPanel.maxNumbersAllowed"));
            return this.txtPort;
        }
        return null;
    }

    public void setServerInstallation(boolean isServerInstallation) {
        this.txtPort.setVisible(isServerInstallation);
        this.lblPort.setVisible(isServerInstallation);
        this.addComponents();
        this.repaint();
    }

    public boolean isServerInstallation() {
        return this.txtPort.isVisible();
    }

    public ArrayList<JComponent> getComponentsForWidthCalculation() {
        ArrayList<JComponent> comp = new ArrayList<JComponent>();
        comp.add(this.lblPort);
        comp.add(this.lblActivateRemote);
        comp.add(this.lblActivateAdhoc);
        return comp;
    }

    @Override
    public void addActionListener(ActionListener a2) {
        this.listener.add(a2);
    }

    @Override
    public boolean removeActionListener(ActionListener a2) {
        return this.listener.remove(a2);
    }

    public GeneralConfigPanel getPanel() {
        return this;
    }

    private class LocalBehavior
    implements ActionListener {
        private LocalBehavior() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            if (e2.getSource().equals(GeneralConfigPanel.this.chkboxActivateRemote)) {
                for (ActionListener a2 : GeneralConfigPanel.this.listener) {
                    a2.actionPerformed(new ActionEvent(GeneralConfigPanel.this.getPanel(), 0, Boolean.toString(GeneralConfigPanel.this.chkboxActivateRemote.isSelected())));
                }
            }
        }
    }
}

