/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels.widget;

import com.inet.setup.GUIUtils;
import com.inet.setup.panels.AbstractPanel;
import com.inet.setup.panels.widget.IPAdresseSelection;
import com.inet.setup.panels.widget.IPTextFieldPanel;
import com.inet.setup.panels.widget.TextUiIpTextFieldPanel;
import com.izforge.izpack.installer.InstallerFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class IPAdresseInputPanel
extends JPanel
implements IPAdresseSelection {
    private static final long serialVersionUID = 1L;
    private final InstallerFrame parent;
    private JLabel lblIPAdresses;
    private IPEntry txtIPAdresses;
    private final AbstractPanel absPanel;
    private final String[] notAllowedIP = new String[]{"0.0.0.0", "127.0.0.1", "127.0.1.1"};
    private String number_between_0_and_255 = "(([0-9]{1,2})|([01][0-9]{2})|(2((5[0-5])|([0-4][0-9]))))";
    private String validIpv4 = "(" + this.number_between_0_and_255 + "\\.){3}" + this.number_between_0_and_255;

    public IPAdresseInputPanel(InstallerFrame parent, AbstractPanel absPanel) {
        this.parent = parent;
        this.absPanel = absPanel;
        this.setName("IPAdresseInputPanel");
        this.lblIPAdresses = new JLabel(parent.langpack.getString("CCLicenseKeyPanel.ipAdresse") + ":");
        if (GraphicsEnvironment.isHeadless()) {
            String ip;
            this.txtIPAdresses = new TextUiIpTextFieldPanel();
            this.txtIPAdresses.asComponent().setName("IPAdresseInputPanel_txtIPAdresses");
            this.lblIPAdresses.setLabelFor(this.txtIPAdresses.asComponent());
            Inet4Address defaultIP = this.getDefaultIPAddress();
            String string = ip = defaultIP == null ? "" : defaultIP.toString();
            if (ip.startsWith("/")) {
                ip = ip.substring(1);
            }
            this.txtIPAdresses.setIPAddress(ip);
        } else {
            this.txtIPAdresses = new IPTextFieldPanel(-1);
        }
        Border innerBorder = BorderFactory.createEmptyBorder(GUIUtils.COMPONENT_INSETS_MIDDLE.top, GUIUtils.COMPONENT_INSETS_MIDDLE.left, GUIUtils.COMPONENT_INSETS_MIDDLE.bottom, GUIUtils.COMPONENT_INSETS_MIDDLE.right);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(parent.langpack.getString("CCLicenseKeyPanel.LicenseKeyIP")), innerBorder));
        this.setLayout(new BorderLayout(10, 0));
        this.add((Component)this.lblIPAdresses, "West");
        this.add((Component)this.txtIPAdresses.asComponent(), "Center");
    }

    private Inet4Address getDefaultIPAddress() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface network = networkInterfaces.nextElement();
                Enumeration<InetAddress> inetAddresses = network.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress address = inetAddresses.nextElement();
                    if (!(address instanceof Inet4Address) || address.isLoopbackAddress()) continue;
                    return (Inet4Address)address;
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public String getIPAdresse() {
        return this.txtIPAdresses.getIPAddress();
    }

    public void setIPAdresse(String ip) {
        try {
            this.txtIPAdresses.setIPAddress(ip);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public JComponent isValidated() {
        if (!this.txtIPAdresses.isEnabled()) {
            return null;
        }
        String ipAdresse = this.txtIPAdresses.getIPAddress();
        if (!ipAdresse.matches(this.validIpv4)) {
            this.absPanel.emitError(this.parent.langpack.getString("CCLicenseKeyPanel.license.invalideIP.title"), this.parent.langpack.getString("CCLicenseKeyPanel.license.invalideIP.msg"));
            return this.txtIPAdresses.asComponent();
        }
        for (String ip : this.notAllowedIP) {
            if (!ip.equals(ipAdresse)) continue;
            this.absPanel.emitError(this.parent.langpack.getString("CCLicenseKeyPanel.license.localIPNotAllowed.title"), this.parent.langpack.getString("CCLicenseKeyPanel.license.localIPNotAllowed.msg"));
            return this.txtIPAdresses.asComponent();
        }
        return null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.txtIPAdresses.setEnabled(enabled);
        this.lblIPAdresses.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        return this.txtIPAdresses.isEnabled();
    }

    @Override
    public String getHostName() {
        return this.getIPAdresse();
    }

    public static interface IPEntry {
        public JComponent asComponent();

        public String getIPAddress();

        public void setIPAddress(String var1);

        public void setEnabled(boolean var1);

        public boolean isEnabled();
    }
}

