/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels.widget;

import com.inet.setup.GUIUtils;
import com.inet.setup.panels.AbstractPanel;
import com.inet.setup.panels.widget.IPAdressItem;
import com.inet.setup.panels.widget.IPAdresseSelection;
import com.izforge.izpack.installer.InstallerFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.MutableComboBoxModel;
import javax.swing.border.Border;

public class IPAdresseSelectionPanel
extends JPanel
implements IPAdresseSelection,
ItemListener {
    private final InstallerFrame parent;
    private JLabel lblIPAdresses;
    private JComboBox cmbboxIPAdresses;
    private final AbstractPanel absPanel;
    private String number_between_0_and_255 = "(([0-9]{1,2})|([01][0-9]{2})|(2((5[0-5])|([0-4][0-9]))))";
    private String validIpv4 = "(" + this.number_between_0_and_255 + "\\.){3}" + this.number_between_0_and_255;

    public IPAdresseSelectionPanel(final InstallerFrame parent, AbstractPanel absPanel) {
        this.parent = parent;
        this.absPanel = absPanel;
        this.lblIPAdresses = new JLabel(parent.langpack.getString("CCLicenseKeyPanel.ipAdresse") + ":");
        this.lblIPAdresses.setLabelFor(this.cmbboxIPAdresses);
        this.cmbboxIPAdresses = new JComboBox();
        this.cmbboxIPAdresses.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof String) {
                    String s2 = (String)value;
                    if (s2.matches(IPAdresseSelectionPanel.this.validIpv4)) {
                        return new JLabel(s2);
                    }
                    JLabel lblMsg = new JLabel(parent.langpack.getString("IPAdresseSelectionPanel.customIP"));
                    lblMsg.setFont(new Font(lblMsg.getFont().getFontName(), 2, lblMsg.getFont().getSize()));
                    lblMsg.setForeground(Color.GRAY);
                    lblMsg.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                    return lblMsg;
                }
                if (value instanceof IPAdressItem) {
                    IPAdressItem ipai = (IPAdressItem)value;
                    JLabel lblipai = new JLabel(ipai.toString());
                    lblipai.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                    lblipai.setFocusable(false);
                    return lblipai;
                }
                return this;
            }
        });
        this.cmbboxIPAdresses.setEditable(true);
        this.cmbboxIPAdresses.addItemListener(this);
        Border innerBorder = BorderFactory.createEmptyBorder(GUIUtils.COMPONENT_INSETS_MIDDLE.top, GUIUtils.COMPONENT_INSETS_MIDDLE.left, GUIUtils.COMPONENT_INSETS_MIDDLE.bottom, GUIUtils.COMPONENT_INSETS_MIDDLE.right);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(parent.langpack.getString("CCLicenseKeyPanel.LicenseKeyIP")), innerBorder));
        this.setLayout(new BorderLayout(10, 0));
        this.add((Component)this.lblIPAdresses, "West");
        this.add((Component)this.cmbboxIPAdresses, "Center");
    }

    public void setIPData(MutableComboBoxModel model) {
        this.cmbboxIPAdresses.setModel(model);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.cmbboxIPAdresses.setEnabled(enabled);
        this.lblIPAdresses.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        return this.cmbboxIPAdresses.isEnabled();
    }

    @Override
    public JComponent isValidated() {
        if (!this.cmbboxIPAdresses.isEnabled()) {
            return null;
        }
        String hostIPAdresse = this.getIPAdresse();
        String string = hostIPAdresse = hostIPAdresse.startsWith("/") ? hostIPAdresse.substring(1) : hostIPAdresse;
        if (!hostIPAdresse.matches(this.validIpv4)) {
            this.absPanel.emitError(this.parent.langpack.getString("CCLicenseKeyPanel.license.noIPSelected.title"), this.parent.langpack.getString("CCLicenseKeyPanel.license.noIPSelected.msg"));
            return this.cmbboxIPAdresses;
        }
        if (hostIPAdresse.equals("0.0.0.0") || hostIPAdresse.equals("127.0.1.1") || hostIPAdresse.equals("127.0.0.1") || hostIPAdresse.toLowerCase().contains("localhost")) {
            this.absPanel.emitError(this.parent.langpack.getString("CCLicenseKeyPanel.license.localIPNotAllowed.title"), this.parent.langpack.getString("CCLicenseKeyPanel.license.localIPNotAllowed.msg"));
            return this.cmbboxIPAdresses;
        }
        return null;
    }

    @Override
    public String getIPAdresse() {
        String hostAddress = "";
        Object selectedItem = this.cmbboxIPAdresses.getSelectedItem();
        if (selectedItem instanceof IPAdressItem) {
            hostAddress = ((IPAdressItem)selectedItem).getIPAdresse().getHostAddress();
        } else if (selectedItem instanceof String) {
            hostAddress = (String)selectedItem;
        }
        return hostAddress;
    }

    @Override
    public String getHostName() {
        String hostName = "";
        Object selectedItem = this.cmbboxIPAdresses.getSelectedItem();
        if (selectedItem instanceof IPAdressItem) {
            hostName = ((IPAdressItem)selectedItem).getIPAdresse().getHostName();
        } else if (selectedItem instanceof String) {
            hostName = (String)selectedItem;
        }
        return hostName;
    }

    @Override
    public void itemStateChanged(ItemEvent e2) {
        boolean isPreselectedIP = e2.getItem() instanceof IPAdressItem;
        this.cmbboxIPAdresses.setEditable(!isPreselectedIP);
    }
}

