/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels.widget;

import com.inet.setup.GUIUtils;
import com.inet.setup.panels.widget.IPAdresseInputPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class IPTextFieldPanel
extends JPanel
implements IPAdresseInputPanel.IPEntry {
    private IPTextElement txtPart1;
    private IPTextElement txtPart2;
    private IPTextElement txtPart3;
    private IPTextElement txtPart4;
    private JLabel lblPart1;
    private JLabel lblPart2;
    private JLabel lblPart3;
    public static final int LEFT = 1;
    public static final int RIGHT = -1;

    public IPTextFieldPanel(int direction) {
        this.setLayout(new GridBagLayout());
        JPanel pnlIP = new JPanel();
        pnlIP.setLayout(new GridBagLayout());
        pnlIP.setBackground(new JTextField().getBackground());
        pnlIP.setBorder(new JTextField().getBorder());
        this.txtPart1 = new IPTextElement();
        this.txtPart1.setColumns(3);
        this.txtPart2 = new IPTextElement();
        this.txtPart2.setColumns(3);
        this.txtPart3 = new IPTextElement();
        this.txtPart3.setColumns(3);
        this.txtPart4 = new IPTextElement();
        this.txtPart4.setColumns(3);
        this.txtPart1.setNext(this.txtPart2);
        this.txtPart2.setNext(this.txtPart3);
        this.txtPart3.setNext(this.txtPart4);
        this.txtPart2.setPrevious(this.txtPart1);
        this.txtPart3.setPrevious(this.txtPart2);
        this.txtPart4.setPrevious(this.txtPart3);
        this.lblPart1 = new JLabel(".");
        this.lblPart2 = new JLabel(".");
        this.lblPart3 = new JLabel(".");
        if (direction == -1) {
            this.add((Component)new JPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, GUIUtils.INSETS_NULL, 0, 0));
        }
        pnlIP.add((Component)this.txtPart1, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(2, 1, 2, 1), 0, 0));
        pnlIP.add((Component)this.lblPart1, new GridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(2, 1, 2, 1), 0, 0));
        pnlIP.add((Component)this.txtPart2, new GridBagConstraints(3, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(2, 1, 2, 1), 0, 0));
        pnlIP.add((Component)this.lblPart2, new GridBagConstraints(4, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(2, 1, 2, 1), 0, 0));
        pnlIP.add((Component)this.txtPart3, new GridBagConstraints(5, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(2, 1, 2, 1), 0, 0));
        pnlIP.add((Component)this.lblPart3, new GridBagConstraints(6, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(2, 1, 2, 1), 0, 0));
        pnlIP.add((Component)this.txtPart4, new GridBagConstraints(7, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(2, 1, 2, 1), 0, 0));
        this.add((Component)pnlIP, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 17, 0, GUIUtils.INSETS_NULL, 0, 0));
        if (direction == 1) {
            this.add((Component)new JPanel(), new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 17, 2, GUIUtils.INSETS_NULL, 0, 0));
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.txtPart1.setEditable(enabled);
        this.txtPart1.setEnabled(enabled);
        this.txtPart2.setEditable(enabled);
        this.txtPart2.setEnabled(enabled);
        this.txtPart3.setEditable(enabled);
        this.txtPart3.setEnabled(enabled);
        this.txtPart4.setEditable(enabled);
        this.txtPart4.setEnabled(enabled);
        this.lblPart1.setEnabled(enabled);
        this.lblPart2.setEnabled(enabled);
        this.lblPart3.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public void setIPAdresse(IPAdresse adresse) {
        this.txtPart1.setText(String.valueOf(adresse.getIPAdressePart(1)));
        this.txtPart2.setText(String.valueOf(adresse.getIPAdressePart(2)));
        this.txtPart3.setText(String.valueOf(adresse.getIPAdressePart(3)));
        this.txtPart4.setText(String.valueOf(adresse.getIPAdressePart(4)));
    }

    @Override
    public void setIPAddress(String adresse) {
        String[] split = adresse.split("\\.");
        if (split.length != 4) {
            throw new IllegalArgumentException();
        }
        this.txtPart1.setText(split[0]);
        this.txtPart2.setText(split[1]);
        this.txtPart3.setText(split[2]);
        this.txtPart4.setText(split[3]);
    }

    private IPAdresse createIPAddressObject() {
        String i1 = this.txtPart1.getText().length() > 0 ? this.txtPart1.getText() : "";
        String i2 = this.txtPart2.getText().length() > 0 ? this.txtPart2.getText() : "";
        String i3 = this.txtPart3.getText().length() > 0 ? this.txtPart3.getText() : "";
        String i4 = this.txtPart4.getText().length() > 0 ? this.txtPart4.getText() : "";
        return new IPAdresse(i1, i2, i3, i4);
    }

    @Override
    public JComponent asComponent() {
        return this;
    }

    @Override
    public String getIPAddress() {
        return this.createIPAddressObject().getIPAdresse();
    }

    public class IPAdresse {
        private String i1;
        private String i2;
        private String i3;
        private String i4;

        public IPAdresse() {
        }

        public IPAdresse(int i1, int i2, int i3, int i4) {
            this.i1 = String.valueOf(i1);
            this.i2 = String.valueOf(i2);
            this.i3 = String.valueOf(i3);
            this.i4 = String.valueOf(i4);
        }

        public IPAdresse(String i1, String i2, String i3, String i4) {
            this.i1 = i1;
            this.i2 = i2;
            this.i3 = i3;
            this.i4 = i4;
        }

        public String getIPAdressePart(int part) {
            switch (part) {
                case 1: {
                    return this.i1;
                }
                case 2: {
                    return this.i2;
                }
                case 3: {
                    return this.i3;
                }
                case 4: {
                    return this.i4;
                }
            }
            return "";
        }

        public String getIPAdresse() {
            boolean b1 = false;
            boolean b2 = false;
            boolean b3 = false;
            boolean b4 = false;
            if (this.i1.length() == 0) {
                this.i1 = "0";
                b1 = true;
            }
            if (this.i2.length() == 0) {
                this.i2 = "0";
                b2 = true;
            }
            if (this.i3.length() == 0) {
                this.i3 = "0";
                b3 = true;
            }
            if (this.i4.length() == 0) {
                this.i4 = "0";
                b4 = true;
            }
            if (b1 && b2 && b3 && b4) {
                return "";
            }
            return this.i1 + "." + this.i2 + "." + this.i3 + "." + this.i4;
        }
    }

    private class IPTextElement
    extends JTextField {
        private IPTextElement previous = null;
        private IPTextElement next = null;
        private int maxLength = 3;

        public IPTextElement() {
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setHorizontalAlignment(0);
            this.setDocument(new PlainDocument(){

                @Override
                public void insertString(int offs, final String str, AttributeSet a2) throws BadLocationException {
                    boolean condNumber;
                    boolean bl2 = condNumber = str != null && str.matches("[0-9]+");
                    if (condNumber) {
                        boolean condValue;
                        boolean condLength = str != null && str.length() + this.getLength() <= IPTextElement.this.maxLength;
                        String text = this.getText(0, this.getLength()) + str;
                        int parseInt = Integer.parseInt(text);
                        boolean bl3 = condValue = text.length() > 0 && parseInt <= 255;
                        if (condLength && condValue) {
                            super.insertString(offs, str, a2);
                            if (IPTextElement.this.next != null) {
                                if (parseInt > 25) {
                                    IPTextElement.this.next.requestFocus();
                                }
                                if (text.length() == 3) {
                                    IPTextElement.this.next.requestFocus();
                                }
                            }
                        } else if (IPTextElement.this.next != null) {
                            IPTextElement.this.next.requestFocus();
                            try {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        IPTextElement.this.next.setText(str);
                                    }
                                });
                            }
                            catch (Exception ex2) {
                                ex2.printStackTrace();
                            }
                        }
                    }
                }
            });
            this.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e2) {
                }

                @Override
                public void keyReleased(KeyEvent e2) {
                    IPTextElement source;
                    if (e2.getKeyCode() == 8 && (source = (IPTextElement)e2.getSource()).getPrevious() != null && source.getText().length() == 0) {
                        source.getPrevious().requestFocus();
                    }
                    if ((e2.getKeyCode() == 32 || e2.getKeyCode() == 46) && (source = (IPTextElement)e2.getSource()).getNext() != null && source.getText().length() > 0) {
                        source.getNext().requestFocus();
                    }
                }

                @Override
                public void keyPressed(KeyEvent e2) {
                }
            });
        }

        public void setNext(IPTextElement next) {
            this.next = next;
        }

        public void setPrevious(IPTextElement previous) {
            this.previous = previous;
        }

        public IPTextElement getNext() {
            return this.next;
        }

        public IPTextElement getPrevious() {
            return this.previous;
        }
    }
}

