/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels.widget;

import com.inet.setup.panels.AbstractPanel;
import com.inet.setup.panels.widget.PermissionItem;
import com.inet.setup.panels.widget.Selectable;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.installer.ResourceNotFoundException;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OsVersion;
import com.sun.org.apache.xerces.internal.util.URI;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LoginConfigPanel
extends JPanel
implements Selectable {
    private static final long serialVersionUID = 1L;
    private JLabel lblIPFilter;
    private JTextField txtIPFilter;
    private JLabel lblRemoteInfo;
    private JLabel lblLoginURL;
    private JTextField txtLoginURL;
    private JLabel lblPermissionLogin;
    private JComboBox cmbboxPermissionLogin;
    private JLabel lblMasterPassword;
    private JPasswordField txtPw;
    private JLabel lblConfirmPassword;
    private JPasswordField txtConfirmPw;
    private final InstallerFrame parent;
    private final AbstractPanel absPanel;
    private boolean oldPasswordTaken = true;
    private boolean isFocusing;
    private boolean isPackageInstallation;
    private String installPath;
    private String masterPassword = "";
    private LocalBehavior localBehavior = new LocalBehavior();
    private JLabel lblMasterInfo;
    private boolean isServletInstallation;
    private String selected;
    private PermissionItem lastSelectedItem = null;

    public LoginConfigPanel(InstallerFrame parent, AbstractPanel absPanel, boolean oldPasswordExists, String isPackageInstallation, String installPath, String selected, boolean isServletInstallation) {
        double[][] dArrayArray;
        this.oldPasswordTaken = oldPasswordExists;
        this.parent = parent;
        this.absPanel = absPanel;
        this.isPackageInstallation = Boolean.parseBoolean(isPackageInstallation);
        this.installPath = installPath;
        this.selected = selected;
        this.isServletInstallation = isServletInstallation;
        this.setBorder(BorderFactory.createTitledBorder(parent.langpack.getString("CCConfigPanel.login")));
        this.setLayout(new BorderLayout(0, 0));
        this.lblPermissionLogin = new JLabel(parent.langpack.getString("CCConfigPanel.permission.login") + ":");
        this.lblPermissionLogin.setName("lblPermissionLogin");
        this.cmbboxPermissionLogin = new JComboBox();
        this.cmbboxPermissionLogin.setName("cmbboxPermissionLogin");
        this.updateCmbboxPermissionLogin(isPackageInstallation, isServletInstallation);
        this.lblPermissionLogin.setLabelFor(this.cmbboxPermissionLogin);
        this.txtLoginURL = new JTextField();
        this.txtLoginURL.setName("txtLoginURL");
        this.txtLoginURL.setEnabled(true);
        this.lblLoginURL = new JLabel(parent.langpack.getString("CCConfigPanel.remote.loginurl") + ":");
        this.lblLoginURL.setLabelFor(this.txtLoginURL);
        this.lblRemoteInfo = new JLabel(parent.langpack.getString("CCConfigPanel.activate_remote_info"));
        this.lblRemoteInfo.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        this.txtIPFilter = new JTextField();
        this.txtIPFilter.setEnabled(false);
        if (GraphicsEnvironment.isHeadless()) {
            String ipFilterLabelString = parent.langpack.getString("CCConfigPanel.remote.ipfilterlong");
            this.lblIPFilter = new JLabel(ipFilterLabelString + ":");
            this.txtIPFilter.setName("txtIPFilter");
            this.txtIPFilter.setEnabled(true);
            this.lblIPFilter.setLabelFor(this.txtIPFilter);
            this.lblIPFilter.setName("lblIPFilter");
        }
        this.txtPw = new JPasswordField();
        this.txtPw.setName("txtPw");
        this.txtConfirmPw = new JPasswordField();
        this.txtConfirmPw.setName("txtConfirmPw");
        this.lblMasterPassword = new JLabel(parent.langpack.getString("MasterPasswordDialog.password"));
        this.lblConfirmPassword = new JLabel(parent.langpack.getString("MasterPasswordDialog.confirmPassword"));
        this.lblMasterPassword.setLabelFor(this.txtPw);
        this.lblConfirmPassword.setLabelFor(this.txtConfirmPw);
        if (oldPasswordExists) {
            this.txtPw.setText("********");
            this.txtConfirmPw.setText("********");
            this.txtConfirmPw.setEnabled(false);
            this.lblConfirmPassword.setEnabled(false);
        }
        this.txtPw.getDocument().addDocumentListener(this.localBehavior);
        this.txtPw.addFocusListener(this.localBehavior);
        double b2 = 10.0;
        double l2 = -2.0;
        double hs = 10.0;
        double el2 = -1.0;
        if (GraphicsEnvironment.isHeadless()) {
            double[][] dArrayArray2 = new double[2][];
            dArrayArray2[0] = new double[]{b2, l2, hs, l2, hs, el2, b2};
            dArrayArray = dArrayArray2;
            dArrayArray2[1] = new double[]{b2, l2, b2, l2, b2, l2, b2, l2, b2, l2, b2};
        } else {
            double[][] dArrayArray3 = new double[2][];
            dArrayArray3[0] = new double[]{b2, l2, hs, l2, hs, el2, b2};
            dArrayArray = dArrayArray3;
            dArrayArray3[1] = new double[]{b2, l2, b2, l2, b2, l2, b2, l2, b2};
        }
        double[][] sizes = dArrayArray;
        this.setLayout(new TableLayout(sizes));
        ImageIcon imageIconResource = null;
        try {
            imageIconResource = ResourceManager.getInstance().getImageIconResource("com/inet/setup/images/Info12.png");
        }
        catch (ResourceNotFoundException e2) {
            Debug.error(e2, this.getClass());
        }
        catch (IOException e3) {
            Debug.error(e3, this.getClass());
        }
        this.lblMasterInfo = new JLabel(imageIconResource);
        this.lblMasterInfo.setToolTipText(parent.langpack.getString("MasterPasswordDialog.explanation"));
        this.add((Component)this.lblPermissionLogin, "1,1");
        this.add((Component)this.cmbboxPermissionLogin, "5,1");
        this.add((Component)this.lblLoginURL, "1,3");
        this.add((Component)this.txtLoginURL, "5,3");
        this.add((Component)this.lblMasterPassword, "1,5");
        this.add((Component)this.lblMasterInfo, "3,5");
        this.add((Component)this.txtPw, "5,5");
        this.add((Component)this.lblConfirmPassword, "1,7");
        this.add((Component)this.txtConfirmPw, "5,7");
        if (GraphicsEnvironment.isHeadless()) {
            this.add((Component)this.lblIPFilter, "1,9");
            this.add((Component)this.txtIPFilter, "5,9");
        }
        this.updateConfirmPasswordState();
        this.updateLoginUrlState();
    }

    public void updateCmbboxPermissionLogin(String isPackageInstallation, boolean isServletInstallation) {
        this.isPackageInstallation = Boolean.parseBoolean(isPackageInstallation);
        this.isServletInstallation = isServletInstallation;
        if (this.cmbboxPermissionLogin.getItemCount() > 0) {
            this.lastSelectedItem = (PermissionItem)this.cmbboxPermissionLogin.getSelectedItem();
            this.cmbboxPermissionLogin.removeAllItems();
            this.cmbboxPermissionLogin.removeItemListener(this.localBehavior);
        }
        this.cmbboxPermissionLogin.addItem(new PermissionItem("automatic", this.parent.langpack.getString("CCConfigPanel.permission.automatic"), true));
        this.cmbboxPermissionLogin.addItem(new PermissionItem("external", this.parent.langpack.getString("CCConfigPanel.permission.external"), true));
        if (OsVersion.IS_WINDOWS || this.isPackageInstallation) {
            this.cmbboxPermissionLogin.addItem(new PermissionItem("windows", this.parent.langpack.getString("CCConfigPanel.permission.windows"), false));
        }
        if (!OsVersion.IS_WINDOWS || this.isPackageInstallation) {
            this.cmbboxPermissionLogin.addItem(new PermissionItem("pam", this.parent.langpack.getString("CCConfigPanel.permission.pam"), false));
        }
        this.cmbboxPermissionLogin.addItem(new PermissionItem("ldap", this.parent.langpack.getString("CCConfigPanel.permission.ldap"), true));
        if (this.isServletInstallation || this.isPackageInstallation) {
            this.cmbboxPermissionLogin.addItem(new PermissionItem("internal", this.parent.langpack.getString("CCConfigPanel.permission.internal"), false));
        }
        this.cmbboxPermissionLogin.addItem(new PermissionItem("master", this.parent.langpack.getString("CCConfigPanel.permission.master"), false));
        this.cmbboxPermissionLogin.addItemListener(this.localBehavior);
        if (this.lastSelectedItem != null) {
            this.setPermissionType(this.lastSelectedItem.getValue());
        }
    }

    public void setSelectedConfigAction(String selected) {
        this.selected = selected;
    }

    public void setServletInstallationFlag(boolean isServletInstallation) {
        this.isServletInstallation = isServletInstallation;
    }

    private void updateConfirmPasswordState() {
        if (!this.oldPasswordTaken) {
            boolean enabled = this.txtPw.getPassword().length > 0;
            this.lblConfirmPassword.setEnabled(enabled);
            this.txtConfirmPw.setEnabled(enabled);
            if (!enabled) {
                this.txtConfirmPw.setText("");
            }
        }
    }

    private void updateLoginUrlState() {
        PermissionItem pi = (PermissionItem)this.cmbboxPermissionLogin.getSelectedItem();
        if (pi.getValue().equals("ldap")) {
            this.lblLoginURL.setText(this.parent.langpack.getString("CCConfigPanel.remote.ldapurl") + ":");
        } else {
            this.lblLoginURL.setText(this.parent.langpack.getString("CCConfigPanel.remote.loginurl") + ":");
        }
        this.txtLoginURL.setEnabled(pi.enableLoginField());
        this.lblLoginURL.setEnabled(pi.enableLoginField());
    }

    public String getIPFilter() {
        if (this.txtIPFilter.isEnabled()) {
            return this.txtIPFilter.getText();
        }
        return "";
    }

    public void setIPFilter(String iPFilter) {
        this.txtIPFilter.setText(iPFilter);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.cmbboxPermissionLogin.setEnabled(enabled);
        this.lblPermissionLogin.setEnabled(enabled);
        this.txtLoginURL.setEnabled(enabled);
        this.lblLoginURL.setEnabled(enabled);
        this.txtPw.setEnabled(enabled);
        this.lblMasterPassword.setEnabled(enabled);
        this.lblMasterInfo.setEnabled(enabled);
        if (enabled) {
            this.updateConfirmPasswordState();
            this.updateLoginUrlState();
        }
    }

    public String getLoginURL() {
        if (this.txtLoginURL.isEnabled()) {
            return this.txtLoginURL.getText().trim();
        }
        return "";
    }

    public void setLoginURL(String loginURL) {
        this.txtLoginURL.setText(loginURL);
    }

    public String getPermissionType() {
        return ((PermissionItem)this.cmbboxPermissionLogin.getSelectedItem()).getValue();
    }

    public String getPermissionTypeI18N() {
        return ((PermissionItem)this.cmbboxPermissionLogin.getSelectedItem()).toString();
    }

    public void setPermissionType(final String value) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i2 = 0; i2 < LoginConfigPanel.this.cmbboxPermissionLogin.getModel().getSize(); ++i2) {
                    PermissionItem elementAt = (PermissionItem)LoginConfigPanel.this.cmbboxPermissionLogin.getModel().getElementAt(i2);
                    if (!value.equalsIgnoreCase(elementAt.getValue())) continue;
                    LoginConfigPanel.this.cmbboxPermissionLogin.setSelectedIndex(i2);
                    break;
                }
            }
        });
    }

    public String getChosenPassword() {
        return new String(this.txtPw.getPassword());
    }

    @Override
    public JComponent isValidated() {
        boolean passwordChosen;
        String loginURL = this.getLoginURL();
        if (loginURL.length() > 0) {
            try {
                if (((PermissionItem)this.cmbboxPermissionLogin.getSelectedItem()).getValue().equals("ldap")) {
                    if (!loginURL.startsWith("ldap://") && !loginURL.startsWith("ldaps://")) {
                        this.absPanel.emitError(null, this.parent.langpack.getString("CCConfigPanel.notaurl"));
                        return this.txtLoginURL;
                    }
                    new URI(loginURL);
                } else {
                    URI uri = new URI(loginURL);
                    if (!loginURL.startsWith("http://") && !loginURL.startsWith("https://")) {
                        this.txtLoginURL.setText(new URL("http", uri.toString(), "").toString());
                    } else {
                        this.txtLoginURL.setText(new URL(uri.toString()).toString());
                    }
                }
            }
            catch (IOException e2) {
                this.absPanel.emitError(null, this.parent.langpack.getString("CCConfigPanel.notaurl"));
                return this.txtLoginURL;
            }
        }
        if (GraphicsEnvironment.isHeadless() && this.txtIPFilter.isEnabled() && this.txtIPFilter.getText().trim().length() > 0 && !this.txtIPFilter.getText().trim().matches("\\A(,|\\s)*((((25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3})|(((?:(0{1,4}:){1,6}|::(f{1,4}:)?))(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3})|(((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?) ::((?:[0-9A-Fa-f]{1,4}:)*)(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3})|(((?:[0-9A-Fa-f]{1,4}:){6,6})(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3})|(((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?))|((?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}))\\s*-\\s*|\\s*-\\s*)?(((25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3})|(((?:(0{1,4}:){1,6}|::(f{1,4}:)?))(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3})|(((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?) ::((?:[0-9A-Fa-f]{1,4}:)*)(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3})|(((?:[0-9A-Fa-f]{1,4}:){6,6})(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3})|(((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?))|((?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}))((,|\\s)*\\z|((,|\\s)*?,\\s*?((((25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3})|(((?:(0{1,4}:){1,6}|::(f{1,4}:)?))(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3})|(((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?) ::((?:[0-9A-Fa-f]{1,4}:)*)(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3})|(((?:[0-9A-Fa-f]{1,4}:){6,6})(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3})|(((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?))|((?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}))\\s*-\\s*|\\s*-\\s*)?(((25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3})|(((?:(0{1,4}:){1,6}|::(f{1,4}:)?))(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3})|(((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?) ::((?:[0-9A-Fa-f]{1,4}:)*)(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3})|(((?:[0-9A-Fa-f]{1,4}:){6,6})(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3})|(((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?))|((?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4})))+(,|\\s)*\\z)*")) {
            this.absPanel.emitError(null, this.parent.langpack.getString("CCConfigPanel.notallowedfilter"));
            return this.txtIPFilter;
        }
        boolean needsPassword = false;
        if (this.isPackageInstallation || !this.txtPw.isEnabled()) {
            needsPassword = false;
        } else {
            if ("master".equals(this.getPermissionType()) && !"windows".equals(this.getPermissionType())) {
                needsPassword = true;
            }
            if (this.txtPw.getPassword().length > 0 || this.txtConfirmPw.getPassword().length > 0) {
                needsPassword = true;
            }
        }
        if (!new String(this.txtConfirmPw.getPassword()).equals(new String(this.txtPw.getPassword())) && needsPassword) {
            this.absPanel.emitError(null, this.parent.langpack.getString("MasterPasswordDialog.passwordsDoNotMatch"));
            return this.txtPw;
        }
        if (this.txtPw.getPassword().length < 8 && needsPassword) {
            this.absPanel.emitError(null, this.parent.langpack.getString("MasterPasswordDialog.passwordTooShort"));
            return this.txtPw;
        }
        String masterPW = this.getChosenPassword();
        boolean bl2 = passwordChosen = masterPW != null && masterPW.length() > 0;
        if ((needsPassword || passwordChosen) && !this.isOldPassword()) {
            File oldPassword = new File(this.installPath, "remotelogin.xml");
            if (masterPW != null) {
                this.masterPassword = masterPW;
            } else if (!oldPassword.exists()) {
                return this.txtPw;
            }
        }
        return null;
    }

    public String getMasterPassword() {
        return this.masterPassword;
    }

    public ArrayList<JComponent> getComponentsForWidthCalculation() {
        ArrayList<JComponent> comp = new ArrayList<JComponent>();
        comp.add(this.lblPermissionLogin);
        comp.add(this.lblLoginURL);
        return comp;
    }

    public boolean isOldPassword() {
        return this.oldPasswordTaken;
    }

    public boolean isLoginURLEnabled() {
        return this.txtLoginURL.isEnabled();
    }

    private class LocalBehavior
    implements DocumentListener,
    FocusListener,
    ItemListener {
        private LocalBehavior() {
        }

        @Override
        public void insertUpdate(DocumentEvent e2) {
            if (!LoginConfigPanel.this.isFocusing) {
                LoginConfigPanel.this.oldPasswordTaken = false;
            }
            LoginConfigPanel.this.updateConfirmPasswordState();
        }

        @Override
        public void removeUpdate(DocumentEvent e2) {
            if (!LoginConfigPanel.this.isFocusing) {
                LoginConfigPanel.this.oldPasswordTaken = false;
            }
            LoginConfigPanel.this.updateConfirmPasswordState();
        }

        @Override
        public void changedUpdate(DocumentEvent e2) {
            if (!LoginConfigPanel.this.isFocusing) {
                LoginConfigPanel.this.oldPasswordTaken = false;
            }
            LoginConfigPanel.this.updateConfirmPasswordState();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void focusGained(FocusEvent e2) {
            LoginConfigPanel.this.isFocusing = true;
            try {
                if (LoginConfigPanel.this.oldPasswordTaken) {
                    LoginConfigPanel.this.txtPw.setText("");
                    LoginConfigPanel.this.txtConfirmPw.setText("");
                }
            }
            finally {
                LoginConfigPanel.this.isFocusing = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void focusLost(FocusEvent e2) {
            LoginConfigPanel.this.isFocusing = true;
            try {
                if (LoginConfigPanel.this.oldPasswordTaken) {
                    LoginConfigPanel.this.txtPw.setText("********");
                    LoginConfigPanel.this.txtConfirmPw.setText("********");
                }
            }
            finally {
                LoginConfigPanel.this.isFocusing = false;
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e2) {
            if (e2.getSource().equals(LoginConfigPanel.this.cmbboxPermissionLogin) && e2.getStateChange() == 1) {
                LoginConfigPanel.this.updateLoginUrlState();
            }
        }
    }
}

