/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels.widget;

import com.inet.setup.GUIUtils;
import com.inet.setup.panels.AbstractPanel;
import com.inet.setup.panels.widget.Selectable;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.installer.ResourceNotFoundException;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OsVersion;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class PathPanel
extends JPanel
implements Selectable {
    private InstallerFrame parent;
    private JLabel lblInstallPath;
    private JTextField txtInstallPath;
    private JButton btnDirChooser;
    private String defaultInstallPath;
    private AbstractPanel absPanel;
    private JLabel lblPathInfo;

    public PathPanel(InstallerFrame parent, String defaultInstallPath, AbstractPanel absPanel) {
        this.parent = parent;
        this.defaultInstallPath = defaultInstallPath;
        this.absPanel = absPanel;
        this.setLayout(new BorderLayout());
        this.add((Component)this.createPathPanel(), "Center");
    }

    public void isRemoteInstallation(String isRemoteInstallation) {
        this.setVisible(!"true".equalsIgnoreCase(isRemoteInstallation));
    }

    private JPanel createPathPanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new GridBagLayout());
        pnl.setBorder(BorderFactory.createTitledBorder(this.parent.langpack.getString("ServletPanel.installPath")));
        this.lblInstallPath = new JLabel((GraphicsEnvironment.isHeadless() ? this.parent.langpack.getString(this.absPanel.getClass().getSimpleName() + ".installPath") + " " + this.parent.langpack.getString(this.absPanel.getClass().getSimpleName() + ".pathInfo" + (OsVersion.IS_WINDOWS ? "win" : "")) : this.parent.langpack.getString(this.absPanel.getClass().getSimpleName() + ".installPath")) + ":");
        this.lblInstallPath.setName("lblInstallPath");
        this.txtInstallPath = new JTextField(this.defaultInstallPath);
        this.txtInstallPath.setName("txtInstallPath");
        this.lblInstallPath.setLabelFor(this.txtInstallPath);
        this.btnDirChooser = new JButton();
        try {
            this.btnDirChooser.setIcon(ResourceManager.getInstance().getImageIconResource("com/inet/setup/images/folder_open_16.png"));
        }
        catch (ResourceNotFoundException e1) {
            this.btnDirChooser.setText("...");
        }
        catch (IOException e1) {
            this.btnDirChooser.setText("...");
        }
        this.btnDirChooser.setName("btnDirChooser");
        this.btnDirChooser.setMargin(new Insets(0, 3, 0, 3));
        this.btnDirChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                File path = PathPanel.this.getDirectoryFileFromChooser(PathPanel.this.txtInstallPath.getText(), null);
                if (path != null) {
                    String absolutePath = path.getAbsolutePath();
                    if (absolutePath.endsWith(String.valueOf(File.separatorChar))) {
                        absolutePath = absolutePath.substring(0, absolutePath.length() - String.valueOf(File.separatorChar).length());
                    }
                    PathPanel.this.txtInstallPath.setText(absolutePath);
                }
            }
        });
        pnl.add((Component)this.lblInstallPath, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 2, GUIUtils.COMPONENT_INSETS_MIDDLE_HALF, 0, 0));
        pnl.add((Component)this.txtInstallPath, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, GUIUtils.removeGap(GUIUtils.COMPONENT_INSETS_MIDDLE_HALF, 3, 10), 0, 0));
        pnl.add((Component)this.btnDirChooser, new GridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 17, 2, GUIUtils.removeGap(GUIUtils.COMPONENT_INSETS_MIDDLE_HALF, 1, 10), 0, 0));
        String text = this.parent.langpack.getString(this.absPanel.getClass().getSimpleName() + ".pathInfo" + (OsVersion.IS_WINDOWS ? "win" : ""));
        if (!text.equalsIgnoreCase(this.absPanel.getClass().getSimpleName() + ".pathInfo" + (OsVersion.IS_WINDOWS ? "win" : ""))) {
            this.lblPathInfo = new JLabel(text);
            Font font = this.lblPathInfo.getFont();
            this.lblPathInfo.setFont(new Font(font.getName(), 2, font.getSize()));
            pnl.add((Component)this.lblPathInfo, new GridBagConstraints(1, 1, 2, 1, 1.0, 1.0, 17, 2, GUIUtils.COMPONENT_INSETS_MIDDLE_HALF, 0, 0));
        }
        return pnl;
    }

    public ArrayList<JComponent> getComponentsForWidthCalculation() {
        ArrayList<JComponent> comp = new ArrayList<JComponent>();
        comp.add(this.lblInstallPath);
        return comp;
    }

    public String getPath() {
        String path = this.txtInstallPath.getText().trim();
        if (path.endsWith(String.valueOf(File.separatorChar))) {
            path = path.substring(0, path.length() - String.valueOf(File.separatorChar).length());
        }
        return path;
    }

    public void setPath(String path) {
        this.txtInstallPath.setText(path);
    }

    @Override
    public JComponent isValidated() {
        if (!this.isVisible()) {
            return null;
        }
        if (this.getPath().length() == 0 || !this.checkPathWritable(new File(this.getPath()))) {
            this.absPanel.emitError(null, this.parent.langpack.getString(this.absPanel.getClass().getSimpleName() + ".noPath"));
            return this.txtInstallPath;
        }
        return null;
    }

    public File getDirectoryFileFromChooser(String defaultPath, String chooserHeading) {
        JFileChooser chooser;
        File defaultFile = new File(defaultPath);
        if (defaultPath != null && defaultPath.length() > 0 && defaultFile.getParentFile() != null) {
            while (!defaultFile.exists() && defaultFile.getParentFile() != null) {
                defaultFile = defaultFile.getParentFile();
            }
            chooser = new JFileChooser(defaultFile.getAbsolutePath());
            chooser.setLocale(Locale.getDefault());
            chooser.updateUI();
        } else {
            File file = new File("");
            if (OsVersion.IS_WINDOWS) {
                file = new File(System.getenv("ProgramFiles"));
            }
            chooser = new JFileChooser(file);
            chooser.setLocale(Locale.getDefault());
            chooser.updateUI();
        }
        chooser.setFileSelectionMode(1);
        if (chooserHeading != null && chooserHeading.length() > 0) {
            chooser.setDialogTitle(chooserHeading);
        } else {
            chooser.setDialogTitle(this.parent.langpack.getString("ServletPanel.installPath"));
        }
        chooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return ((PathPanel)PathPanel.this).parent.langpack.getString("ServletPanel.directorys_only");
            }

            @Override
            public boolean accept(File f2) {
                return f2.isDirectory() && PathPanel.this.checkPathWritable(f2);
            }
        });
        int returnVal = chooser.showOpenDialog(this.parent);
        if (returnVal == 0 && this.checkPathWritable(chooser.getSelectedFile())) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    private boolean checkPathWritable(File file) {
        while (!file.exists()) {
            if ((file = file.getParentFile()) != null) continue;
            Debug.log((Object)"checkPathWritable file is NULL ", this.getClass());
            return false;
        }
        Debug.log((Object)("checkPathWritable " + file.canWrite()), this.getClass());
        return file.canWrite();
    }
}

