/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels.widget;

import com.inet.setup.GUIUtils;
import com.inet.setup.panels.AbstractPanel;
import com.inet.setup.panels.widget.Selectable;
import com.izforge.izpack.installer.InstallerFrame;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class PortPanel
extends JPanel
implements Selectable {
    private final String defaultPort;
    private final InstallerFrame parent;
    private JLabel lblPort;
    private JTextField txtPort;
    private final AbstractPanel absPanel;

    public PortPanel(InstallerFrame parent, String defaultPort, AbstractPanel absPanel) {
        this.parent = parent;
        this.defaultPort = defaultPort;
        this.absPanel = absPanel;
        this.setBorder(BorderFactory.createTitledBorder(parent.langpack.getString("CCConfigPanel.general")));
        this.setLayout(new GridBagLayout());
        this.lblPort = new JLabel(parent.langpack.getString(absPanel.getClass().getSimpleName() + ".port") + ":");
        this.txtPort = new JTextField();
        this.txtPort.setDocument(new PlainDocument(){

            @Override
            public void insertString(int offs, String str, AttributeSet a2) throws BadLocationException {
                if (str.matches("[0-9]*")) {
                    super.insertString(offs, str, a2);
                    return;
                }
            }
        });
        this.txtPort.setText(defaultPort);
        this.txtPort.setName("txtPort");
        this.lblPort.setLabelFor(this.txtPort);
        this.add((Component)this.lblPort, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, GUIUtils.COMPONENT_INSETS_MIDDLE, 0, 0));
        this.add((Component)this.txtPort, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, GUIUtils.COMPONENT_INSETS_MIDDLE, 0, 0));
    }

    public ArrayList<JComponent> getComponentsForWidthCalculation() {
        ArrayList<JComponent> comp = new ArrayList<JComponent>();
        comp.add(this.lblPort);
        return comp;
    }

    public String getPort() {
        return this.txtPort.getText().trim();
    }

    public void setPort(String port) {
        this.txtPort.setText(port);
    }

    public void setPortLabel(String panelClassName) {
        this.lblPort.setText(this.parent.langpack.getString(panelClassName + ".port") + ":");
    }

    @Override
    public JComponent isValidated() {
        if (!this.isVisible()) {
            return null;
        }
        if (this.txtPort.getText().length() == 0) {
            this.txtPort.setText(this.defaultPort);
        }
        if (!this.txtPort.getText().trim().matches("[0-9]*")) {
            this.absPanel.emitError(null, this.parent.langpack.getString("CCConfigPanel.onlyNumbersAllowed"));
            return this.txtPort;
        }
        if (Integer.parseInt(this.txtPort.getText().trim()) > 65535 || Integer.parseInt(this.txtPort.getText().trim()) < 0) {
            this.absPanel.emitError(null, this.parent.langpack.getString("CCConfigPanel.maxNumbersAllowed"));
            return this.txtPort;
        }
        return null;
    }

    public void isServerInstallation(String isServerInstallation) {
        this.setVisible(!"true".equalsIgnoreCase(isServerInstallation));
    }

    public void isServerInstallation(boolean isServerInstallation) {
        this.setVisible(isServerInstallation);
    }
}

