/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels.widget;

import com.inet.setup.panels.AbstractPanel;
import com.inet.setup.panels.widget.Selectable;
import com.izforge.izpack.installer.InstallerFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;

public class PropertiesImportPanel
extends JPanel
implements Selectable {
    private final InstallerFrame parent;
    private JTextField txtSelectedProperty;
    private JButton btnDirChooser;
    private final AbstractPanel absPanel;

    public PropertiesImportPanel(InstallerFrame parent, boolean showBorder, AbstractPanel absPanel) {
        this.parent = parent;
        this.absPanel = absPanel;
        this.setLayout(new BorderLayout());
        if (showBorder) {
            this.setBorder(new TitledBorder(parent.langpack.getString("CCPropertiesPanel.prop_select")));
        }
        this.add((Component)this.createPropertiesSelectionDialogPanel(), "Center");
    }

    private JPanel createPropertiesSelectionDialogPanel() {
        final JPanel pnlPropSelectDialog = new JPanel(new GridBagLayout());
        pnlPropSelectDialog.setName("pnlPropSelectDialog");
        this.txtSelectedProperty = new JTextField();
        this.txtSelectedProperty.setName("txtSelectedProperty");
        JLabel dummyLabel = new JLabel(this.parent.langpack.getString("CCPropertiesPanel.prop_location"));
        dummyLabel.setLabelFor(this.txtSelectedProperty);
        this.btnDirChooser = new JButton("...");
        this.btnDirChooser.setName("btnDirChooser");
        this.btnDirChooser.setMargin(new Insets(0, 3, 0, 3));
        this.btnDirChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                File testFile;
                JFileChooser chooser = new JFileChooser(PropertiesImportPanel.this.txtSelectedProperty.getText());
                chooser.setLocale(Locale.getDefault());
                chooser.updateUI();
                chooser.setFileSelectionMode(0);
                chooser.setAcceptAllFileFilterUsed(false);
                chooser.setFileFilter(new FileFilter(){

                    @Override
                    public String getDescription() {
                        return "Properties (*.properties)";
                    }

                    @Override
                    public boolean accept(File f2) {
                        return f2.isDirectory() || f2.getName().endsWith(".properties");
                    }
                });
                int returnVal = chooser.showOpenDialog(pnlPropSelectDialog);
                if (returnVal == 0 && (testFile = chooser.getSelectedFile()).exists()) {
                    PropertiesImportPanel.this.txtSelectedProperty.setText(testFile.getAbsolutePath());
                }
            }
        });
        pnlPropSelectDialog.add((Component)this.txtSelectedProperty, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        pnlPropSelectDialog.add((Component)this.btnDirChooser, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return pnlPropSelectDialog;
    }

    public String getPropertyName() {
        return this.txtSelectedProperty.getText();
    }

    public void setPropertyName(String property) {
        this.txtSelectedProperty.setText(property);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.txtSelectedProperty.setEnabled(enabled);
        this.btnDirChooser.setEnabled(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JComponent isValidated() {
        FileInputStream fis;
        block16: {
            JTextField jTextField;
            if (this.getPropertyName().length() == 0) {
                this.absPanel.emitError(null, this.parent.langpack.getString("CCPropertiesPanel.no_property"));
                return this.txtSelectedProperty;
            }
            if (!new File(this.getPropertyName()).exists()) {
                this.absPanel.emitError(null, this.parent.langpack.getString("CCPropertiesPanel.properties_not_found"));
                return this.txtSelectedProperty;
            }
            if (!this.getPropertyName().endsWith(".properties")) {
                this.absPanel.emitError(null, this.parent.langpack.getString("CCPropertiesPanel.not_a_property"));
                return this.txtSelectedProperty;
            }
            if (!this.getPropertyName().endsWith(".properties")) return null;
            Properties properties = new Properties();
            fis = null;
            try {
                fis = new FileInputStream(this.getPropertyName());
                properties.load(fis);
                if (!properties.isEmpty()) break block16;
                this.absPanel.emitError(null, this.parent.langpack.getString("CCPropertiesPanel.empty_property"));
                jTextField = this.txtSelectedProperty;
            }
            catch (Throwable e4) {
                try {
                    this.absPanel.emitError(null, this.parent.langpack.getString("CCPropertiesPanel.not_a_property"));
                    JTextField jTextField2 = this.txtSelectedProperty;
                    return jTextField2;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        fis.close();
                    }
                    catch (IOException e5) {}
                }
            }
            try {
                fis.close();
                return jTextField;
            }
            catch (IOException e2) {
                // empty catch block
            }
            return jTextField;
        }
        try {
            fis.close();
            return null;
        }
        catch (IOException e3) {
            return null;
        }
    }
}

