/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels.widget;

import com.izforge.izpack.Pack;
import com.izforge.izpack.PackHandler;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.util.Debug;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ReadmeFactory {
    private static final String REMOTE_END = "<!--remote_end-->";
    private static final String REMOTE_START = "<!--remote_start-->";
    private List<File> listHelpFiles = new ArrayList<File>();
    private String result = "";
    private final InstallData idata;

    public ReadmeFactory(InstallData idata) {
        this.idata = idata;
        String installPath = idata.getVariable("INSTALL_PATH");
        File gettingStarted = new File(new File(installPath), "setup_tmp" + File.separatorChar + "client" + File.separatorChar + "documentation" + File.separatorChar + "gettingstarted.html");
        if (gettingStarted.exists()) {
            this.listHelpFiles.add(gettingStarted);
        }
        List<Pack> listPacks = PackHandler.getSelectedPacks();
        ArrayList<String> dependencies = new ArrayList<String>();
        for (Pack pack : PackHandler.getSelectedPacks()) {
            if (pack == null || pack.getDependencies() == null) continue;
            dependencies.addAll(pack.getDependencies());
        }
        HashSet s2 = new HashSet(dependencies);
        dependencies = new ArrayList(s2);
        int counter = 0;
        for (Pack pack : listPacks) {
            File help;
            if (dependencies.contains(pack.name) || !(help = new File(new File(installPath), "setup_tmp" + File.separatorChar + "client" + File.separatorChar + "documentation" + File.separatorChar + pack.id.toLowerCase() + ".html")).exists()) continue;
            this.listHelpFiles.add(help);
            ++counter;
        }
        try {
            boolean docuInstalled;
            boolean guidesInstalled;
            this.result = this.mergeFiles();
            if (this.result == null) {
                return;
            }
            if (counter > 1) {
                this.result = this.result.replaceAll("<[Tt][Ii][Tt][Ll][Ee]>([^<])+</[Tt][Ii][Tt][Ll][Ee]>", "<title>Getting Started</title>");
            }
            if (!(guidesInstalled = idata.getRules().isConditionTrue("izpack.selected.Doc_Guides"))) {
                this.result = this.result.replaceAll("../.././client/documentation/guides", "http://www.inetsoftware.de/_media/products/clear-reports/documentation/guides/written-guides");
                this.result = this.result.replaceAll("../../client/documentation/guides", "http://www.inetsoftware.de/_media/products/clear-reports/documentation/guides/written-guides");
            }
            if (!(docuInstalled = idata.getRules().isConditionTrue("izpack.selected.Doc_Manual"))) {
                this.result = this.result.replaceAll("../.././client/documentation/doc", "http://www.inetsoftware.de/documentation/clear-reports/online-help");
                this.result = this.result.replaceAll("../../client/documentation/doc", "http://www.inetsoftware.de/documentation/clear-reports/online-help");
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    private String removePackagePart(String html) {
        if (html == null || html.length() == 0) {
            Debug.log((Object)"No readme was generated!", this.getClass());
            return "";
        }
        String start = REMOTE_START;
        String end = REMOTE_END;
        int startInt = html.indexOf(start);
        int endInt = html.indexOf(end);
        if (startInt > 0 && endInt > 0) {
            html = html.substring(0, startInt) + html.substring(endInt + end.length());
        }
        return html;
    }

    public File createResultingReadme() throws IOException {
        if (this.result == null || this.result.length() == 0) {
            Debug.log((Object)"No readme was generated!", this.getClass());
            return null;
        }
        File readmeFile = new File(new File(this.idata.getVariable("INSTALL_PATH")), "client" + File.separatorChar + "documentation" + File.separatorChar + File.separatorChar + "gettingstarted.html");
        if (readmeFile.exists() && !readmeFile.canWrite()) {
            throw new IOException("can not write to " + readmeFile.getName());
        }
        if (!readmeFile.getParentFile().exists()) {
            readmeFile.getParentFile().mkdirs();
        }
        FileWriter fw2 = new FileWriter(readmeFile);
        fw2.append(this.result);
        fw2.close();
        UninstallData uData = UninstallData.getInstance();
        uData.addFile(readmeFile.getAbsolutePath(), true);
        return readmeFile;
    }

    private String mergeFiles() throws IOException {
        if (this.listHelpFiles.size() == 0) {
            Debug.log((Object)"No help files found!", this.getClass());
            return null;
        }
        StringBuffer buffString = new StringBuffer();
        for (int i2 = 0; i2 < this.listHelpFiles.size(); ++i2) {
            String s2;
            File file = this.listHelpFiles.get(i2);
            FileReader fr2 = new FileReader(file);
            BufferedReader br2 = new BufferedReader(fr2);
            StringBuilder b2 = new StringBuilder();
            while ((s2 = br2.readLine()) != null) {
                b2.append(s2);
                b2.append('\n');
            }
            fr2.close();
            br2.close();
            if (i2 > 0) {
                b2 = this.cutEnd(b2);
            }
            if (i2 < this.listHelpFiles.size() - 1) {
                b2 = this.cutBeginning(b2);
            }
            String string = b2.toString();
            string = string.replaceAll("../../lib/", "lib/");
            string = string.replaceAll("../../installinfo/images/", "images/");
            if (!Boolean.toString(true).equalsIgnoreCase(this.idata.getVariable("SERVLET_REMOTE_INSTALL"))) {
                string = this.removePackagePart(string);
            }
            buffString.append(string);
        }
        return buffString.toString();
    }

    private StringBuilder cutEnd(StringBuilder b2) {
        int indexOfDiv = b2.indexOf("<div id=\"inet_page\" class=\"dokuwiki\">");
        if (indexOfDiv > -1) {
            String substring = b2.substring(indexOfDiv + "<div id=\"inet_page\" class=\"dokuwiki\">".length());
            return new StringBuilder(substring);
        }
        return b2;
    }

    private StringBuilder cutBeginning(StringBuilder b2) {
        int indexOfDiv = b2.indexOf("<!-- including documentation:clear-reports:installinfo:de:support -->");
        if (indexOfDiv > -1) {
            String substring = b2.substring(0, indexOfDiv);
            if ((substring = substring.trim()).endsWith("<p>")) {
                substring = substring.substring(0, substring.length() - "<p>".length());
            }
            return new StringBuilder(substring);
        }
        return b2;
    }
}

