/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels.widget;

import com.inet.setup.panels.widget.StartOption;
import com.izforge.izpack.LocaleDatabase;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class StartOptionsListPanel
extends JPanel {
    private List<JCheckBox> checkboxes = new ArrayList<JCheckBox>();
    private Map<JCheckBox, StartOption> checkboxToOption = new HashMap<JCheckBox, StartOption>();

    public StartOptionsListPanel(LocaleDatabase langpack, Map<StartOption.OptionGroup, List<StartOption>> options) {
        double[][] sizes = new double[][]{{-2.0, -1.0}, new double[0]};
        TableLayout layout = new TableLayout(sizes);
        this.setLayout(layout);
        Set<StartOption.OptionGroup> groups = options.keySet();
        int currRow = 0;
        for (StartOption.OptionGroup group : groups) {
            int beginningRow = currRow;
            JLabel lblGroupIcon = new JLabel(group.getImage());
            JLabel lblGroupText = new JLabel(langpack.getString(group.getDescription()));
            lblGroupText.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 0));
            layout.insertRow(currRow, -2.0);
            this.add((Component)lblGroupText, "1," + currRow);
            ++currRow;
            List<StartOption> optionList = options.get((Object)group);
            for (StartOption startOption : optionList) {
                JCheckBox chkOption = new JCheckBox(startOption.getText());
                chkOption.setName(startOption.getText());
                chkOption.setToolTipText(startOption.getTooltipText());
                chkOption.setBorder(BorderFactory.createEmptyBorder(5, 10, 1, 0));
                chkOption.setSelected(startOption.isInitiallySelected());
                layout.insertRow(currRow, -2.0);
                this.add((Component)chkOption, "1," + currRow);
                ++currRow;
                this.checkboxes.add(chkOption);
                this.checkboxToOption.put(chkOption, startOption);
            }
            layout.insertRow(currRow++, -2.0);
            lblGroupIcon.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 0));
            this.add((Component)lblGroupIcon, "0," + beginningRow + ",0," + (currRow - 1));
        }
    }

    public void runChosenOptions() {
        for (JCheckBox jCheckBox : this.checkboxes) {
            StartOption option = this.checkboxToOption.get(jCheckBox);
            if (jCheckBox.isSelected()) {
                option.getAction().run();
                continue;
            }
            Runnable negative = option.getNegativeAction();
            if (negative == null) continue;
            negative.run();
        }
    }

    public Map<JCheckBox, StartOption> getCheckboxes() {
        return this.checkboxToOption;
    }
}

