/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.processing;

import com.inet.setup.processing.ServletBuilder;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import java.io.File;
import java.io.IOException;

abstract class AbstractProcessingServlet {
    private ServletBuilder servletBuilder = new ServletBuilder();
    private AbstractUIProcessHandler handler = null;

    AbstractProcessingServlet() {
    }

    public ServletBuilder getServletBuilder() {
        return this.servletBuilder;
    }

    void setServletBuilder(ServletBuilder s2) {
        this.servletBuilder = s2;
    }

    protected void createServlet(String localDir, String servletVersion, String configname) throws IOException {
        String warFileLoc = this.getInitialWarFileLocation();
        UninstallData.getInstance().addFile(warFileLoc, true);
        this.setupServlet(warFileLoc, localDir, servletVersion, configname);
        this.servletBuilder.setHandler(this.handler);
        this.servletBuilder.createWar();
        String finalWarFileLocation = this.getFinalWarFileLocation();
        UninstallData.getInstance().addFile(finalWarFileLocation, true);
        if (!finalWarFileLocation.equals(warFileLoc)) {
            this.servletBuilder.copyFile(warFileLoc, finalWarFileLocation);
            this.servletBuilder.delete(warFileLoc);
        }
    }

    protected void setupServlet(String warFileLoc, String localDir, String servletVersion, String configname) {
        this.servletBuilder.setWarFile(new File(warFileLoc));
        this.servletBuilder.setLocalDir(localDir);
        this.servletBuilder.setConfigname(configname);
        this.servletBuilder.setWebXML(servletVersion);
    }

    protected abstract String getInitialWarFileLocation();

    protected String getFinalWarFileLocation() throws IOException {
        return this.getInitialWarFileLocation();
    }

    public void setHandler(AbstractUIProcessHandler handler) {
        this.handler = handler;
    }
}

