/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.processing;

import com.inet.setup.processing.ProcessingLogger;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import java.io.File;
import javax.swing.SwingUtilities;

public class CleanRemote {
    private String installDir;
    private boolean isUpdate;
    private final String[] files = new String[]{"StandaloneConfiguration.exe"};
    private final String[] folder = new String[]{"templates", "core", "lib"};
    private ProcessingLogger logger;

    public void run(AbstractUIProcessHandler handler, String[] args) {
        this.logger = new ProcessingLogger(handler);
        this.installDir = args[0] + File.separator;
        this.isUpdate = Boolean.parseBoolean(args[1]);
        if (this.isUpdate) {
            return;
        }
        for (String fileName : this.files) {
            File file = new File(this.installDir + fileName);
            this.deleteFileSave(file);
        }
        for (String folderName : this.folder) {
            this.deleteFolder(new File(this.installDir + File.separator + folderName));
        }
    }

    private void deleteFileSave(final File file) {
        try {
            if (!file.delete()) {
                file.deleteOnExit();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    file.deleteOnExit();
                }
            });
        }
        catch (Exception e2) {
            this.logger.printTrace(e2);
        }
    }

    private void deleteFolder(final File folder) {
        if (!folder.exists()) {
            return;
        }
        File[] listFiles = folder.listFiles();
        if (listFiles.length > 0) {
            for (File file : listFiles) {
                if (!file.isDirectory()) {
                    this.deleteFileSave(file);
                    continue;
                }
                this.deleteFolder(file);
            }
        }
        if (!folder.delete()) {
            folder.deleteOnExit();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                folder.deleteOnExit();
            }
        });
    }
}

