/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.processing;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class CreatePackageList {
    public static void main(String[] args) throws Exception {
        File[] files;
        String prefix = "";
        if (args.length == 1) {
            prefix = args[0];
        }
        Properties packages = new Properties();
        for (File file : files = CreatePackageList.getFiles(".")) {
            String fileName = file.getName();
            if (!fileName.endsWith(".jar")) continue;
            ZipFile zip = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (entryName.startsWith("META-INF/") || entry.isDirectory()) continue;
                int idx = entryName.lastIndexOf(47);
                String packageName = idx >= 0 ? entryName.substring(0, idx) : "";
                packageName = packageName.replace('/', '.');
                packages.setProperty(packageName, prefix + file.getPath().replace(".\\", "").replace("\\", "/"));
            }
        }
        File outFile = new File("packages.lst");
        System.err.println(outFile.getAbsolutePath());
        if (outFile.getParentFile() != null) {
            outFile.getParentFile().mkdirs();
        }
        packages.store(new FileOutputStream(outFile), null);
    }

    private static File[] getFiles(String dir) {
        File[] files;
        Vector<File> filesList = new Vector<File>();
        for (File file : files = new File(dir).listFiles()) {
            File[] fs2;
            if (file.isFile()) {
                filesList.add(file);
                continue;
            }
            for (File f2 : fs2 = CreatePackageList.getFiles(file.getPath())) {
                filesList.add(f2);
            }
        }
        File[] founded = new File[filesList.size()];
        return filesList.toArray(founded);
    }
}

