/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.processing;

import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.panels.ShortcutData;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.StringTool;
import com.izforge.izpack.util.os.Shortcut;
import com.izforge.izpack.util.os.Unix_Shortcut;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class CreateShortcuts {
    private static final long serialVersionUID = 3256722870838112311L;
    private Vector<ExecutableFile> execFiles = new Vector();
    private String groupName;
    private String programGroupIconFile;
    private String programGroupComment;
    private Shortcut shortcut;
    private List<ShortcutData> shortcuts = new Vector<ShortcutData>();
    private Vector<String> files = new Vector();
    private int itsUserType;
    private String installPath;
    public static final String USER_TYPE = "usertype";

    public CreateShortcuts(List<ShortcutData> list, Shortcut shortcutObject, String programmGroup, String userType) {
        this.shortcuts = list;
        this.shortcut = shortcutObject;
        this.groupName = programmGroup;
        try {
            this.itsUserType = Integer.valueOf(userType);
        }
        catch (NumberFormatException e2) {
            // empty catch block
        }
    }

    private String createXDGMenu(ArrayList<String> shortcuts, String menuName) {
        String menuConfigText = "<Menu>\n<Name>Applications</Name>\n<Menu>\n<Directory>" + menuName.replaceAll(" ", "-") + "-izpack.directory</Directory>\n" + "<Name>" + menuName + "</Name>\n" + "<Include>\n";
        Iterator<String> i$ = shortcuts.iterator();
        while (i$.hasNext()) {
            String shortcut1;
            String shortcutFile = shortcut1 = i$.next();
            menuConfigText = menuConfigText + "<Filename>" + shortcutFile + "</Filename>\n";
        }
        menuConfigText = menuConfigText + "</Include>\n</Menu>\n</Menu>";
        return menuConfigText;
    }

    private String createXDGDirectory(String menuName, String icon, String comment) {
        String menuDirectoryDescriptor = "[Desktop Entry]\nName=$Name\nComment=$Comment\nIcon=$Icon\nType=Directory\nEncoding=UTF-8";
        menuDirectoryDescriptor = StringTool.replace(menuDirectoryDescriptor, "$Name", menuName);
        menuDirectoryDescriptor = StringTool.replace(menuDirectoryDescriptor, "$Comment", comment);
        menuDirectoryDescriptor = StringTool.replace(menuDirectoryDescriptor, "$Icon", icon);
        return menuDirectoryDescriptor;
    }

    private void writeXDGMenuFile(ArrayList<String> desktopFileNames, String groupName, String icon, String comment) {
        if (OsVersion.IS_UNIX) {
            String directoryFolder;
            String menuFolder;
            String menuFile = this.createXDGMenu(desktopFileNames, groupName);
            String dirFile = this.createXDGDirectory(groupName, icon, comment);
            if (this.itsUserType == 2) {
                menuFolder = "/etc/xdg/menus/applications-merged/";
                directoryFolder = "/usr/share/desktop-directories/";
            } else {
                menuFolder = System.getProperty("user.home") + File.separator + ".config/menus/applications-merged/";
                directoryFolder = System.getProperty("user.home") + File.separator + ".local/share/desktop-directories/";
            }
            File menuFolderFile = new File(menuFolder);
            File directoryFolderFile = new File(directoryFolder);
            String menuFilePath = menuFolder + groupName + ".menu";
            String dirFilePath = directoryFolder + groupName.replaceAll(" ", "-") + "-izpack.directory";
            menuFolderFile.mkdirs();
            directoryFolderFile.mkdirs();
            this.writeString(menuFile, menuFilePath);
            this.writeString(dirFile, dirFilePath);
        }
    }

    private void writeString(String str, String file) {
        boolean failed = false;
        try {
            FileWriter writer = new FileWriter(file);
            writer.write(str);
            writer.close();
        }
        catch (Exception ignore) {
            failed = true;
            Debug.log((Object)"Failed to create menu for gnome.", this.getClass());
        }
        if (!failed) {
            UninstallData.getInstance().addFile(file, true);
        }
    }

    public void createShortcuts() {
        String gn2 = this.groupName;
        ArrayList<String> startMenuShortcuts = new ArrayList<String>();
        for (int i2 = 0; i2 < this.shortcuts.size(); ++i2) {
            ShortcutData data = this.shortcuts.get(i2);
            try {
                gn2 = this.groupName + data.subgroup;
                this.shortcut.setUserType(this.itsUserType);
                this.shortcut.setLinkName(data.name);
                this.shortcut.setLinkType(data.type);
                this.shortcut.setArguments(data.commandLine);
                this.shortcut.setDescription(data.description);
                this.shortcut.setIconLocation(data.iconFile, data.iconIndex);
                this.shortcut.setShowCommand(data.initialState);
                this.shortcut.setTargetPath(data.target);
                this.shortcut.setWorkingDirectory(data.workingDirectory);
                this.shortcut.setEncoding(data.deskTopEntryLinux_Encoding);
                this.shortcut.setMimetype(data.deskTopEntryLinux_MimeType);
                this.shortcut.setTerminal(data.deskTopEntryLinux_Terminal);
                this.shortcut.setTerminalOptions(data.deskTopEntryLinux_TerminalOptions);
                this.shortcut.setType(data.deskTopEntryLinux_Type);
                this.shortcut.setKdeSubstUID(data.deskTopEntryLinux_X_KDE_SubstituteUID);
                this.shortcut.setKdeUserName(data.deskTopEntryLinux_X_KDE_UserName);
                this.shortcut.setURL(data.deskTopEntryLinux_URL);
                this.shortcut.setTryExec(data.TryExec);
                this.shortcut.setCategories(data.Categories);
                this.shortcut.setCreateForAll(data.createForAll);
                this.shortcut.setUninstaller(UninstallData.getInstance());
                if (data.addToGroup) {
                    this.shortcut.setProgramGroup(gn2);
                } else {
                    this.shortcut.setProgramGroup("");
                }
                try {
                    Unix_Shortcut unixcut;
                    String f2;
                    this.shortcut.save();
                    if ((data.type == 1 || data.addToGroup) && this.shortcut instanceof Unix_Shortcut && (f2 = (unixcut = (Unix_Shortcut)this.shortcut).getWrittenFileName()) != null) {
                        startMenuShortcuts.add(f2);
                    }
                    String fileName = this.shortcut.getFileName();
                    this.files.add(0, fileName);
                    File file = new File(fileName);
                    File base = new File(this.shortcut.getBasePath());
                    Vector<File> intermediates = new Vector<File>();
                    this.execFiles.add(new ExecutableFile(fileName, 2, 3, new ArrayList<OsConstraint>(), false));
                    this.files.add(fileName);
                    while ((file = file.getParentFile()) != null && !file.equals(base)) {
                        intermediates.add(file);
                    }
                    if (file == null) continue;
                    Enumeration filesEnum = intermediates.elements();
                    while (filesEnum.hasMoreElements()) {
                        this.files.add(0, ((File)filesEnum.nextElement()).toString());
                    }
                    continue;
                }
                catch (Exception exception) {
                    continue;
                }
            }
            catch (Throwable exception) {
                // empty catch block
            }
        }
        if (OsVersion.IS_UNIX) {
            this.writeXDGMenuFile(startMenuShortcuts, this.groupName, this.programGroupIconFile, this.programGroupComment);
        }
        this.shortcut.execPostAction();
        this.shortcut.cleanUp();
    }

    public void addToUninstaller() {
        UninstallData uninstallData = UninstallData.getInstance();
        for (int i2 = 0; i2 < this.files.size(); ++i2) {
            uninstallData.addFile(this.files.elementAt(i2), true);
        }
    }

    public void setInstallData(AutomatedInstallData idata) {
        this.installPath = idata.getInstallPath();
        this.shortcut.setInstallData(idata);
    }

    public static void main(String[] args) {
    }
}

