/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.processing;

import com.inet.report.config.Configuration;
import com.inet.report.config.ConfigurationManager;
import com.inet.setup.Constants;
import com.inet.setup.processing.ProcessingLogger;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.izforge.izpack.util.Debug;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ExportConfiguration {
    private ProcessingLogger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(AbstractUIProcessHandler handler, String[] args) {
        this.logger = new ProcessingLogger(handler);
        String installPath = args[0];
        String scopeName = args[1];
        String configName = args[2];
        int scope = Constants.getScopeValue(scopeName);
        File config = new File(installPath + File.separatorChar + "setup_tmp" + File.separatorChar + "WEB-INF" + File.separatorChar + "classes" + File.separatorChar + "configuration.xml");
        OutputStream fout = null;
        try {
            if (!config.exists()) {
                config.getParentFile().mkdirs();
                config.createNewFile();
            }
            if (config.canRead() && config.canWrite()) {
                fout = new FileOutputStream(config);
                Configuration configuration = ConfigurationManager.getInstance().get(scope, configName);
                if (configuration != null) {
                    configuration.getProperties().store(fout, null);
                } else {
                    Debug.log((Object)"Export Configuration not found", this.getClass());
                }
            } else {
                this.logger.printTrace(new FileNotFoundException("[ExportConfiguration] can not read/write file"));
            }
        }
        catch (Exception e2) {
            this.logger.printTrace(e2);
        }
        finally {
            if (fout != null) {
                try {
                    fout.flush();
                    ((FileOutputStream)fout).close();
                }
                catch (IOException e3) {
                    this.logger.printTrace(e3);
                }
            }
        }
    }
}

