/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.processing;

import com.inet.report.config.ConfigurationManager;
import com.inet.report.config.datasource.DataSourceConfigurationManager;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.izforge.izpack.util.Debug;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class InstallDatasources {
    private static AbstractUIProcessHandler handler = null;

    public void run(AbstractUIProcessHandler handle, String[] args) {
        InstallDatasources.installDatasource(args);
        handler = handle;
    }

    public static void main(String[] args) {
        InstallDatasources.installDatasource(args);
    }

    private static void installDatasource(String[] args) {
        int sysPref = 1;
        if (args[1].equalsIgnoreCase(ConfigurationManager.getScopeName(2))) {
            sysPref = 2;
        }
        try {
            File datatbaseConfigurationFile = new File(args[0]);
            String[] datasourceConfigurationNames = DataSourceConfigurationManager.getDataSourceConfigurationNames();
            boolean ownDS = false;
            for (int i2 = 0; i2 < datasourceConfigurationNames.length; ++i2) {
                if (datasourceConfigurationNames[i2].startsWith("Local") || datasourceConfigurationNames[i2].equals("Sample Database") || datasourceConfigurationNames[i2].equals("LayoutDatasource")) continue;
                ownDS = true;
                break;
            }
            boolean layoutDSExists = false;
            if (DataSourceConfigurationManager.getDataSourceConfiguration("LayoutDatasource", sysPref) != null) {
                layoutDSExists = true;
            }
            if (datatbaseConfigurationFile.getName().startsWith("SampleDatabase")) {
                InetAddress adr = null;
                boolean hostNotAvailable = false;
                try {
                    adr = InetAddress.getLocalHost();
                }
                catch (UnknownHostException uh) {
                    hostNotAvailable = true;
                }
                if (hostNotAvailable || !GraphicsEnvironment.isHeadless() || !"HUDSON".equalsIgnoreCase(adr.getHostName())) {
                    DataSourceConfigurationManager.removeDatasourceConfiguration("Sample Database", sysPref);
                    DataSourceConfigurationManager.importDataSourceConfigurations(sysPref, datatbaseConfigurationFile, true);
                }
            } else if (datasourceConfigurationNames.length == 0 || !ownDS || datatbaseConfigurationFile.getName().startsWith("LayoutDatasource")) {
                if (datatbaseConfigurationFile.getName().startsWith("LayoutDatasource") && layoutDSExists) {
                    DataSourceConfigurationManager.removeDatasourceConfiguration("LayoutDatasource", sysPref);
                }
                DataSourceConfigurationManager.importDataSourceConfigurations(sysPref, datatbaseConfigurationFile, true);
            }
            Debug.log("[INSTALL_DATASOURCE] Datasource successfull installed: " + datatbaseConfigurationFile.getAbsolutePath() + " in " + sysPref);
        }
        catch (Exception e2) {
            Debug.log("[INSTALL_DATASOURCE] Datasource installation error: " + args[0] + " in " + sysPref);
            Debug.error(e2);
            if (handler != null) {
                handler.emitError("Error", e2.getMessage());
            }
            System.err.println("There are some problems executing the import method.");
            e2.printStackTrace();
        }
    }
}

