/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.processing;

import com.inet.report.BaseUtils;
import com.inet.report.config.Configuration;
import com.inet.report.config.ConfigurationManager;
import com.inet.report.config.gui.swing.ConfigurationImportChecker;
import com.inet.setup.Constants;
import com.inet.setup.panels.util.JsonCreator;
import com.inet.setup.processing.ProcessingLogger;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.izforge.izpack.util.Debug;
import java.awt.HeadlessException;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class ProcessingCreateConfiguration {
    private ProcessingLogger logger;
    private AbstractUIProcessHandler handler;

    public void run(AbstractUIProcessHandler abshandler, String[] args) {
        this.handler = abshandler;
        this.logger = new ProcessingLogger(this.handler);
        Debug.log((Object)"[CONFIG_CMD] START CONFIG", this.getClass());
        Debug.log(Arrays.asList(args), this.getClass());
        String scopeName = args[0];
        String configName = args[1];
        String locale = args[2];
        String selected = args[3];
        String selectedProperty = args[4];
        String isHeadless = args[5];
        String installDir = args[6];
        String isRemoteInstall = args[7];
        String addToConfiguration = args[8];
        String crInstalled = args[9];
        if ((selected.equalsIgnoreCase("USE_ENTERED") || selected.equalsIgnoreCase("USE_ENTERED")) && Boolean.toString(true).equalsIgnoreCase(isRemoteInstall)) {
            return;
        }
        String driverDir = "lib" + File.separator + "driver" + File.separatorChar;
        String coreDir = "core" + File.separatorChar;
        String tempDir = "setup_tmp" + File.separatorChar;
        if (!installDir.endsWith(File.separator)) {
            installDir = installDir + File.separator;
        }
        ArrayList<URL> urlList = new ArrayList<URL>();
        try {
            File f2 = new File(installDir + coreDir + "ClearReports.jar");
            urlList.add(f2.toURI().toURL());
            f2 = new File(installDir + coreDir + "RemoteGUI.jar");
            urlList.add(f2.toURI().toURL());
            f2 = new File(installDir + coreDir + "CCLib.jar");
            urlList.add(f2.toURI().toURL());
            f2 = new File(installDir + driverDir + "Oranxo.jar");
            urlList.add(f2.toURI().toURL());
            f2 = new File(installDir + driverDir + "Merlia.jar");
            urlList.add(f2.toURI().toURL());
            f2 = new File(installDir + driverDir + "Fositex.jar");
            urlList.add(f2.toURI().toURL());
            f2 = new File(installDir + driverDir + "mysql-connector-java.jar");
            urlList.add(f2.toURI().toURL());
            f2 = new File(installDir + driverDir + "Syto.jar");
            urlList.add(f2.toURI().toURL());
            f2 = new File(installDir + driverDir + "smallsql.jar");
            urlList.add(f2.toURI().toURL());
            f2 = new File(installDir + driverDir + "LayoutJDBCDriver.jar");
            urlList.add(f2.toURI().toURL());
            f2 = new File(installDir + tempDir + "CCLnF.jar");
            urlList.add(f2.toURI().toURL());
        }
        catch (Exception e2) {
            Debug.error(e2, this.getClass());
        }
        int scope = Constants.getScopeValue(scopeName);
        if ("CREATE_FROM_PROPS".equalsIgnoreCase(selected)) {
            this.createConfigAndImportDatasources(scope, configName, locale, selectedProperty, isHeadless, isRemoteInstall, urlList, crInstalled);
        } else if ("CREATE_NEW".equalsIgnoreCase(selected)) {
            this.createConfigAndImportDatasources(scope, configName, locale, installDir + selectedProperty, isHeadless, isRemoteInstall, urlList, crInstalled);
        } else if ("CREATE_FROM_LOCAL".equalsIgnoreCase(selected)) {
            this.createConfigFromCopy(scope, configName, selectedProperty);
        }
        HashMap<String, String> json = null;
        try {
            json = JsonCreator.createMapFromJson(addToConfiguration);
        }
        catch (Exception e3) {
            Debug.error(e3, this.getClass());
            this.logger.printTrace(e3);
            json = new HashMap();
        }
        ConfigurationManager cm2 = ConfigurationManager.getInstance();
        Configuration configuration = cm2.get(scope, configName);
        if (configuration != null) {
            Set<String> keySet = json.keySet();
            for (String key : keySet) {
                configuration.put(key, json.get(key));
            }
            String maxRequests = configuration.get("MaxHttpRequests");
            if (maxRequests != null) {
                try {
                    if (Integer.valueOf(maxRequests) < 50) {
                        configuration.put("MaxHttpRequests", "250");
                    }
                }
                catch (NumberFormatException e4) {
                    Debug.error(e4, this.getClass());
                }
            }
            try {
                configuration.flush();
            }
            catch (BackingStoreException e5) {
                Debug.error(e5, this.getClass());
                e5.printStackTrace();
            }
        }
    }

    private void createConfigFromCopy(int scope, String configName, String selectedProperty) throws IllegalArgumentException {
        String[] split = selectedProperty.split("::");
        if (split.length != 2) {
            throw new IllegalArgumentException(selectedProperty + " has no configuration");
        }
        String srcScope = split[0];
        String srcName = split[1];
        try {
            ConfigurationManager cm2 = ConfigurationManager.getInstance();
            cm2.copy(Constants.getScopeValue(srcScope), srcName, scope, configName);
        }
        catch (Exception e2) {
            Debug.error(e2, this.getClass());
            this.logger.printTrace(e2);
        }
    }

    private void createConfigAndImportDatasources(int scope, String configName, String locale, String selectedProperty, String headless, String isRemoteInstall, List<URL> urlList, String crInstalled) {
        try {
            if (Boolean.toString(true).equalsIgnoreCase(headless) || Boolean.toString(true).equalsIgnoreCase(isRemoteInstall) || Boolean.toString(false).equalsIgnoreCase(crInstalled)) {
                this.importConfigurationHeadless(scope, configName, selectedProperty);
            } else {
                this.importConfiguration(configName, locale, selectedProperty, urlList, scope);
            }
        }
        catch (Exception ex2) {
            Debug.error(ex2, this.getClass());
            this.logger.printTrace(ex2);
        }
    }

    private void importConfiguration(String configName, String locale, String selectedProperty, List<URL> urlList, int scope) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, HeadlessException {
        HashMap<String, String> iso3Toiso2 = new HashMap<String, String>(32);
        for (int i2 = 0; i2 < Constants.LANG_CODES.length; ++i2) {
            iso3Toiso2.put(Constants.LANG_CODES[i2][0], Constants.LANG_CODES[i2][1]);
        }
        Locale.setDefault(new Locale((String)iso3Toiso2.get(locale)));
        final URLClassLoader ucl = URLClassLoader.newInstance(urlList.toArray(new URL[urlList.size()]));
        Thread.currentThread().setContextClassLoader(ucl);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setContextClassLoader(ucl);
            }
        });
        try {
            Class loadClass = BaseUtils.classForName("com.inet.report.config.gui.swing.ConfigurationImportChecker");
            Constructor constructor = loadClass.getConstructor(Window.class, Integer.TYPE, String.class, String.class, File.class, Boolean.TYPE);
            constructor.newInstance(new JFrame(), scope, configName, "", new File(selectedProperty), Boolean.FALSE);
        }
        catch (ClassNotFoundException e1) {
            Debug.error(e1, this.getClass());
            this.logger.printTrace(e1);
        }
        catch (SecurityException e2) {
            Debug.error(e2, this.getClass());
            this.logger.printTrace(e2);
        }
        catch (NoSuchMethodException e3) {
            Debug.error(e3, this.getClass());
            this.logger.printTrace(e3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importConfigurationHeadless(int scope, String configname, String configfile) {
        ConfigurationManager manager = ConfigurationManager.getInstance();
        File cfile = new File(configfile);
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(cfile);
            if (manager.get(scope, configname) != null) {
                manager.delete(scope, configname);
            }
            manager.importFromStream(scope, configname, fileInputStream);
            fileInputStream.close();
            Configuration importetconf = manager.get(scope, configname);
            ConfigurationImportChecker configurationImportChecker = new ConfigurationImportChecker(true, scope, configname, null);
            configurationImportChecker.checkForDLLs(importetconf);
            String message = "The configuration \"" + configname + "\" was successfully imported into the scope \"" + ConfigurationManager.getScopeName(scope) + "\"";
            if (scope == 2) {
                message = message + " for the user \"" + System.getProperty("user.name") + "\"";
            }
            message = message + ".";
            this.handler.displayMessage(message);
            this.handler.displayMessage("Hint: In order to convert DLL settings from your properties files to data sources, you have to start the GUI of the Configuration Manager.");
        }
        catch (SecurityException e2) {
            this.handler.displayMessage("A SecurityException occurred while importing the configuration, please check your rights for the selected scope.");
            this.handler.displayMessage(e2.getLocalizedMessage());
        }
        catch (IOException e3) {
            this.handler.displayMessage("A exception occurred while importing the configuration while reading from the specified file.");
            this.handler.displayMessage(e3.getLocalizedMessage());
        }
        catch (IllegalArgumentException e4) {
            this.handler.displayMessage("Importing a configuration failed due to the following problem:");
            this.handler.displayMessage(e4.getLocalizedMessage());
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e5) {}
            }
        }
    }
}

