/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.processing;

import com.inet.lib.util.PreferencesUtils;
import com.inet.report.config.Configuration;
import com.inet.report.config.ConfigurationManager;
import com.inet.report.config.gui.swing.ConfigurationImportChecker;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.izforge.izpack.util.Debug;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class ProcessingDesignerConfiguration {
    private AbstractUIProcessHandler handler;

    public void run(AbstractUIProcessHandler abshandler, String[] args) {
        int scope;
        Configuration defaultConfig;
        this.handler = abshandler;
        Debug.log((Object)"[CONFIG_CMD] START IMPORT DESIGNER CONFIG", this.getClass());
        Debug.log(Arrays.asList(args), this.getClass());
        String installDir = args[0];
        String selectedProperty = args[1];
        ConfigurationManager cm2 = ConfigurationManager.getInstance();
        Preferences pref = PreferencesUtils.userRoot();
        pref = pref.node("com/inet/designer/crystalclear");
        String name = pref.get("defaultConfigName", null);
        String scopeInt = pref.get("defaultConfigScope", null);
        if (name != null && scopeInt != null && (defaultConfig = cm2.get(scope = Integer.parseInt(scopeInt), name)) != null) {
            return;
        }
        Configuration userDefault = cm2.get(2, "Default");
        if (userDefault != null) {
            pref = pref.node("com/inet/designer/crystalclear");
            pref.put("defaultConfigName", "Default");
            pref.putInt("defaultConfigScope", 2);
            return;
        }
        Configuration systemDefault = cm2.get(1, "Default");
        if (systemDefault != null) {
            pref = pref.node("com/inet/designer/crystalclear");
            pref.put("defaultConfigName", "Default");
            pref.putInt("defaultConfigScope", 2);
            return;
        }
        try {
            this.createConfiguration(installDir, selectedProperty);
            pref = pref.node("com/inet/designer/crystalclear");
            pref.put("defaultConfigName", "Default");
            pref.putInt("defaultConfigScope", 2);
        }
        catch (BackingStoreException e2) {
            Debug.error(e2, this.getClass());
        }
    }

    private void createConfiguration(String installDir, String selectedProperty) throws BackingStoreException {
        String driverDir = "lib" + File.separator + "driver" + File.separatorChar;
        String coreDir = "core" + File.separatorChar;
        String tempDir = "setup_tmp" + File.separatorChar;
        if (!installDir.endsWith(File.separator)) {
            installDir = installDir + File.separator;
        }
        ArrayList<URL> urlList = new ArrayList<URL>();
        try {
            File f2 = new File(installDir + coreDir + "ClearReports.jar");
            urlList.add(f2.toURI().toURL());
            f2 = new File(installDir + coreDir + "RemoteGUI.jar");
            urlList.add(f2.toURI().toURL());
            f2 = new File(installDir + coreDir + "CCLib.jar");
            urlList.add(f2.toURI().toURL());
            f2 = new File(installDir + driverDir + "Oranxo.jar");
            urlList.add(f2.toURI().toURL());
            f2 = new File(installDir + driverDir + "Merlia.jar");
            urlList.add(f2.toURI().toURL());
            f2 = new File(installDir + driverDir + "Fositex.jar");
            urlList.add(f2.toURI().toURL());
            f2 = new File(installDir + driverDir + "mysql-connector-java.jar");
            urlList.add(f2.toURI().toURL());
            f2 = new File(installDir + driverDir + "Syto.jar");
            urlList.add(f2.toURI().toURL());
            f2 = new File(installDir + driverDir + "smallsql.jar");
            urlList.add(f2.toURI().toURL());
            f2 = new File(installDir + driverDir + "LayoutJDBCDriver.jar");
            urlList.add(f2.toURI().toURL());
            f2 = new File(installDir + tempDir + "CCLnF.jar");
            urlList.add(f2.toURI().toURL());
        }
        catch (Exception e2) {
            Debug.error(e2, this.getClass());
        }
        this.importConfigurationHeadless(2, "Default", installDir + "setup_tmp" + File.separator + selectedProperty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importConfigurationHeadless(int scope, String configname, String configfile) {
        ConfigurationManager manager = ConfigurationManager.getInstance();
        File cfile = new File(configfile);
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(cfile);
            if (manager.get(scope, configname) != null) {
                manager.delete(scope, configname);
            }
            manager.importFromStream(scope, configname, fileInputStream);
            fileInputStream.close();
            Configuration importetconf = manager.get(scope, configname);
            ConfigurationImportChecker configurationImportChecker = new ConfigurationImportChecker(true, scope, configname, null);
            configurationImportChecker.checkForDLLs(importetconf);
            String message = "The configuration \"" + configname + "\" was successfully imported into the scope \"" + ConfigurationManager.getScopeName(scope) + "\"";
            if (scope == 2) {
                message = message + " for the user \"" + System.getProperty("user.name") + "\"";
            }
            message = message + ".";
            this.handler.logOutput(message, false);
            this.handler.logOutput("Hint: In order to convert DLL settings from your properties files to data sources, you have to start the GUI of the Configuration Manager.", false);
        }
        catch (SecurityException e2) {
            this.handler.logOutput("A SecurityException occurred while importing the configuration, please check your rights for the selected scope.", true);
            this.handler.logOutput(e2.getLocalizedMessage(), true);
        }
        catch (IOException e3) {
            this.handler.logOutput("A exception occurred while importing the configuration while reading from the specified file.", true);
            this.handler.logOutput(e3.getLocalizedMessage(), true);
        }
        catch (IllegalArgumentException e4) {
            this.handler.logOutput("Importing a configuration failed due to the following problem:", true);
            this.handler.logOutput(e4.getLocalizedMessage(), true);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e5) {}
            }
        }
    }
}

