/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.processing;

import com.inet.report.BaseUtils;
import com.inet.report.config.Configuration;
import com.inet.report.config.ConfigurationManager;
import com.inet.setup.Constants;
import com.inet.setup.processing.ProcessingLogger;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.izforge.izpack.util.Debug;
import java.awt.HeadlessException;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import javax.swing.SwingUtilities;

public class ProcessingImportDatasources {
    private AbstractUIProcessHandler handler;
    private ProcessingLogger logger;

    public void run(AbstractUIProcessHandler abshandler, String[] args) {
        this.handler = abshandler;
        this.logger = new ProcessingLogger(this.handler);
        Debug.log((Object)"[CONFIG_CMD] START CONFIG", this.getClass());
        Debug.log(Arrays.asList(args), this.getClass());
        String scopeName = args[0];
        String configName = args[1];
        String locale = args[2];
        String installDir = args[3];
        String driverDir = "lib" + File.separator + "driver" + File.separatorChar;
        String coreDir = "core" + File.separatorChar;
        String tempDir = "setup_tmp" + File.separatorChar;
        if (!installDir.endsWith(File.separator)) {
            installDir = installDir + File.separator;
        }
        ArrayList<URL> urlList = new ArrayList<URL>();
        try {
            File f2 = new File(installDir + coreDir + "ClearReports.jar");
            urlList.add(f2.toURI().toURL());
            f2 = new File(installDir + coreDir + "RemoteGUI.jar");
            urlList.add(f2.toURI().toURL());
            f2 = new File(installDir + coreDir + "CCLib.jar");
            urlList.add(f2.toURI().toURL());
            f2 = new File(installDir + driverDir + "Oranxo.jar");
            urlList.add(f2.toURI().toURL());
            f2 = new File(installDir + driverDir + "Merlia.jar");
            urlList.add(f2.toURI().toURL());
            f2 = new File(installDir + driverDir + "Fositex.jar");
            urlList.add(f2.toURI().toURL());
            f2 = new File(installDir + driverDir + "mysql-connector-java.jar");
            urlList.add(f2.toURI().toURL());
            f2 = new File(installDir + driverDir + "Syto.jar");
            urlList.add(f2.toURI().toURL());
            f2 = new File(installDir + driverDir + "smallsql.jar");
            urlList.add(f2.toURI().toURL());
            f2 = new File(installDir + driverDir + "LayoutJDBCDriver.jar");
            urlList.add(f2.toURI().toURL());
            f2 = new File(installDir + tempDir + "CCLnF.jar");
            urlList.add(f2.toURI().toURL());
        }
        catch (Exception e2) {
            Debug.error(e2, this.getClass());
        }
        int scope = Constants.getScopeValue(scopeName);
        try {
            this.importConfiguration(configName, locale, urlList, scope);
        }
        catch (HeadlessException e3) {
            e3.printStackTrace();
        }
        catch (IllegalArgumentException e4) {
            Debug.error(e4, this.getClass());
            this.logger.printTrace(e4);
        }
        catch (InstantiationException e5) {
            Debug.error(e5, this.getClass());
            this.logger.printTrace(e5);
        }
        catch (IllegalAccessException e6) {
            Debug.error(e6, this.getClass());
            this.logger.printTrace(e6);
        }
        catch (InvocationTargetException e7) {
            Debug.error(e7, this.getClass());
            this.logger.printTrace(e7);
        }
    }

    private void importConfiguration(final String configName, String locale, List<URL> urlList, final int scope) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, HeadlessException {
        HashMap<String, String> iso3Toiso2 = new HashMap<String, String>(32);
        for (int i2 = 0; i2 < Constants.LANG_CODES.length; ++i2) {
            iso3Toiso2.put(Constants.LANG_CODES[i2][0], Constants.LANG_CODES[i2][1]);
        }
        Locale.setDefault(new Locale((String)iso3Toiso2.get(locale)));
        final URLClassLoader ucl = URLClassLoader.newInstance(urlList.toArray(new URL[urlList.size()]));
        Thread.currentThread().setContextClassLoader(ucl);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setContextClassLoader(ucl);
                try {
                    ProcessingImportDatasources.this.putDll(scope, configName);
                    Class loadClass = BaseUtils.classForName("com.inet.report.config.gui.swing.ConfigurationImportChecker");
                    Constructor constructor = loadClass.getConstructor(Boolean.TYPE, Integer.TYPE, String.class, String.class);
                    Object newInstance = constructor.newInstance(Boolean.FALSE, scope, configName, "");
                    Method checkForDll = loadClass.getMethod("checkForDLLs", Configuration.class);
                    ConfigurationManager instance = ConfigurationManager.getInstance();
                    Configuration configuration = instance.get(scope, configName);
                    if (configuration != null) {
                        checkForDll.invoke(newInstance, configuration);
                    }
                }
                catch (ClassNotFoundException e1) {
                    Debug.error(e1, this.getClass());
                    ProcessingImportDatasources.this.logger.printTrace(e1);
                }
                catch (SecurityException e2) {
                    Debug.error(e2, this.getClass());
                    ProcessingImportDatasources.this.logger.printTrace(e2);
                }
                catch (NoSuchMethodException e3) {
                    Debug.error(e3, this.getClass());
                    ProcessingImportDatasources.this.logger.printTrace(e3);
                }
                catch (IllegalArgumentException e4) {
                    Debug.error(e4, this.getClass());
                    ProcessingImportDatasources.this.logger.printTrace(e4);
                }
                catch (InstantiationException e5) {
                    Debug.error(e5, this.getClass());
                    ProcessingImportDatasources.this.logger.printTrace(e5);
                }
                catch (IllegalAccessException e6) {
                    Debug.error(e6, this.getClass());
                    ProcessingImportDatasources.this.logger.printTrace(e6);
                }
                catch (InvocationTargetException e7) {
                    Debug.error(e7, this.getClass());
                    ProcessingImportDatasources.this.logger.printTrace(e7);
                }
            }
        });
    }

    private void putDll(int scope, String configName) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("pdsodbc.dll", "odbc_sun");
        map.put("pdsmon.dll", "ado_ms,ado_sun");
        map.put("pdssql.dll", "sql7,sql");
        map.put("pdsora7.dll", "oracle_inet,oracle");
        map.put("pdsifmx.dll", "informix_merant,informix");
        map.put("pdssyb10.dll", "sybase_inet,sybase");
        map.put("pdsdb2.dll", "db2_inet,db2,db2_sql,db2_net,as400");
        map.put("pdscsv.dll", "csv");
        map.put("interbase.dll", "interbase");
        map.put("core.dll", "core");
        map.put("mysql.dll", "mysql");
        map.put("polite.dll", "polite");
        map.put("postgresql.dll", "postgre,postgres");
        map.put("sapdb.dll", "sapdb");
        map.put("xml.dll", "xml");
        map.put("hypersonic.dll", "hsql");
        map.put("pervasive.dll", "pervasive");
        map.put("derby.dll", "derby,derbyEmbedded");
        map.put("fourd.dll", "fourd");
        map.put("odbc_sun.driver", "sun.jdbc.odbc.JdbcOdbcDriver");
        map.put("odbc_sun.url", "jdbc:odbc:{0}");
        map.put("odbc_sun.class", "com.inet.report.DatabaseOdbc");
        map.put("odbc_sun.alias", "AS");
        map.put("ado_ms.driver", "com.ms.jdbc.odbc.JdbcOdbcDriver");
        map.put("ado_ms.url", "jdbc:odbc:{0}");
        map.put("ado_ms.class", "com.inet.report.DatabaseOdbc");
        map.put("ado_ms.alias", "AS");
        map.put("ado_sun.driver", "sun.jdbc.odbc.JdbcOdbcDriver");
        map.put("ado_sun.url", "jdbc:odbc:{0}");
        map.put("ado_sun.class", "com.inet.report.DatabaseOdbc");
        map.put("ado_sun.alias", "AS");
        map.put("polite.driver", "oracle.lite.poljdbc.POLJDBCDriver");
        map.put("polite.url", "jdbc:polite:{0}");
        map.put("oracle_inet.driver", "com.inet.ora.OraDriver");
        map.put("oracle_inet.url", "jdbc:inetora:{0}");
        map.put("oracle_inet.class", "com.inet.report.DatabaseOracle");
        map.put("oracle.driver", "oracle.jdbc.driver.OracleDriver");
        map.put("oracle.url", "jdbc:oracle:thin:@{0}");
        map.put("oracle.class", "com.inet.report.DatabaseOracle");
        map.put("sql7.driver", "com.inet.tds.TdsDriver");
        map.put("sql7.url", "jdbc:inetdae7:{0}?database={1}");
        map.put("sql7.class", "com.inet.report.DatabaseSqlServer");
        map.put("sql.driver", "com.inet.tds.TdsDriver");
        map.put("sql.url", "jdbc:inetdae:{0}?database={1}");
        map.put("sql.class", "com.inet.report.DatabaseSqlServer");
        map.put("csv.driver", "com.inet.csv.CsvDriver");
        map.put("csv.url", "jdbc:csv:{0}");
        map.put("csv.supportsSQL92syntax", "false");
        map.put("informix.driver", "com.informix.jdbc.IfxDriver");
        map.put("informix.url", "jdbc:informix-sqli://{0}/{1}:informixserver={0}");
        map.put("informix.class", "com.inet.report.DatabaseInformix");
        map.put("informix.supportsSQL92syntax", "true");
        map.put("informix_merant.driver", "com.merant.datadirect.jdbc.informix.InformixDriver");
        map.put("informix_merant.url", "jdbc:merant:informix://{0};DatabaseName={1}");
        map.put("informix_merant.class", "com.inet.report.DatabaseInformix");
        map.put("informix_merant.supportsSQL92syntax", "true");
        map.put("sybase_inet.driver", "com.inet.syb.SybDriver");
        map.put("sybase_inet.url", "jdbc:inetsyb:{0}?database={1}");
        map.put("sybase_inet.class", "com.inet.report.DatabaseSybase");
        map.put("sybase_inet.supportsSQL92syntax", "true");
        map.put("sybase.driver", "com.sybase.jdbc.SybDriver");
        map.put("sybase.url", "jdbc:sybase:Tds:{0}/{1}");
        map.put("sybase.class", "com.inet.report.DatabaseSybase");
        map.put("sybase.supportsSQL92syntax", "true");
        map.put("db2.driver", "COM.ibm.db2.jdbc.app.DB2Driver");
        map.put("db2.url", "jdbc:db2:{1}");
        map.put("db2_sql.driver", "ibm.sql.DB2Driver");
        map.put("db2_sql.url", "jdbc:db2:{1}");
        map.put("db2_net.driver", "COM.ibm.db2.jdbc.net.DB2Driver");
        map.put("db2_net.url", "jdbc:db2://{0}/{1}");
        map.put("db2.supportsSQL92syntax", "true");
        map.put("as400.driver", "com.ibm.as400.access.AS400JDBCDriver");
        map.put("as400.url", "jdbc:as400:{1}");
        map.put("as400.supportsSQL92syntax", "true");
        map.put("db2_inet.driver", "com.inet.drda.DRDADriver");
        map.put("db2_inet.url", "jdbc:inetdb2:{0}?database={1}");
        map.put("db2_inet.supportsSQL92syntax", "true");
        map.put("postgre.driver", "postgresql.Driver");
        map.put("postgre.url", "jdbc:postgresql://{0}/{1}");
        map.put("postgre.supportsSQL92syntax", "true");
        map.put("postgres.driver", "org.postgresql.Driver");
        map.put("postgres.url", "jdbc:postgresql://{0}/{1}");
        map.put("postgres.supportsSQL92syntax", "true");
        map.put("postgres.class", "com.inet.report.DatabasePostgreSql");
        map.put("mysql.driver", "com.mysql.jdbc.Driver");
        map.put("mysql.url", "jdbc:mysql://{0}/{1}");
        map.put("mysql.supportsSQL92syntax", "true");
        map.put("sapdb.driver", "com.sap.dbtech.jdbc.DriverSapDB");
        map.put("sapdb.url", "jdbc:sapdb://{0}/{1}");
        map.put("sapdb.class", "com.inet.report.DatabaseSAPDB");
        map.put("sapdb.supportsSQL92syntax", "true");
        map.put("interbase.driver", "interbase.interclient.Driver");
        map.put("interbase.url", "jdbc:interbase://{0}/{1}");
        map.put("interbase.supportsSQL92syntax", "false");
        map.put("xml.driver", "com.sunopsis.jdbc.driver.xml.SnpsXmlDriver");
        map.put("xml.url", "jdbc:snps:xml?ro=true&{1}");
        map.put("xml.supportsSQL92syntax", "true");
        map.put("xml.supportsParenthesiseInJoin", "false");
        map.put("hsql.driver", "org.hsqldb.jdbcDriver");
        map.put("hsql.url", "jdbc:hsqldb:hsql://{0}");
        map.put("hsql.alias", "AS");
        map.put("hsql.supportsSQL92syntax", "true");
        map.put("pervasive.driver", "com.pervasive.jdbc.v2.Driver");
        map.put("pervasive.url", "jdbc:pervasive://{0}/{1}");
        map.put("pervasive.supportsSQL92syntax", "true");
        map.put("derbyEmbedded.driver", "org.apache.derby.jdbc.EmbeddedDriver");
        map.put("derbyEmbedded.url", "jdbc:derby:{1}");
        map.put("derby.driver", "org.apache.derby.jdbc.ClientDriver");
        map.put("derby.url", "jdbc:derby://{0}/{1}");
        map.put("fourd.driver", "com.fourd.jdbc.DriverImpl");
        map.put("fourd.url", "jdbc:4d:{0}");
        map.put("core.class", "com.inet.report.DatabaseCore");
        ConfigurationManager cm2 = ConfigurationManager.getInstance();
        Configuration configuration = cm2.get(scope, configName);
        if (configuration != null) {
            Set keySet = map.keySet();
            for (String key : keySet) {
                configuration.put(key, (String)map.get(key));
            }
            try {
                configuration.flush();
            }
            catch (BackingStoreException e2) {
                Debug.error(e2, this.getClass());
                e2.printStackTrace();
            }
        }
    }
}

