/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.processing;

import com.inet.looks.plastic.PlasticLookAndFeel;
import com.inet.looks.plastic.PlasticXPLookAndFeel;
import com.inet.looks.plastic.theme.InetCrystalClear;
import com.inet.setup.processing.ProcessingLogger;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class ProcessingPHP {
    private ProcessingLogger logger;
    private ArrayList<Object> list = new ArrayList();

    public int run(AbstractUIProcessHandler handler, String[] args) {
        if (System.getProperty("mrj.version") != null) {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "i-net Clear Reports Setup");
            System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
            System.setProperty("com.apple.mrj.application.live-resize", "true");
        }
        if (!GraphicsEnvironment.isHeadless()) {
            try {
                PlasticXPLookAndFeel laf_class = new PlasticXPLookAndFeel();
                PlasticLookAndFeel.setPlasticTheme(new InetCrystalClear());
                UIManager.setLookAndFeel(laf_class);
                JFrame.setDefaultLookAndFeelDecorated(true);
                JDialog.setDefaultLookAndFeelDecorated(true);
            }
            catch (UnsupportedLookAndFeelException e1) {
                e1.printStackTrace();
            }
            catch (Throwable e2) {
                e2.printStackTrace();
            }
        }
        this.logger = new ProcessingLogger(handler);
        return this.addToApache(args[0], args[1], args[2], args[3]);
    }

    private void readBlockAndLines(String configFile, String virtualDirectory) throws IOException {
        FileReader reader = new FileReader(configFile);
        BufferedReader r2 = new BufferedReader(reader);
        String line = r2.readLine();
        int startEntry = -1;
        int endEntry = -1;
        boolean blockfound = false;
        int lineCounter = 1;
        while (line != null) {
            String substring;
            String prefix = "### i-net Clear Reports ";
            String suffix = " START";
            String suffix2 = " END";
            if (line.startsWith(prefix) && (line.endsWith(suffix) || line.endsWith(suffix2)) && (substring = line.substring(prefix.length(), line.endsWith(suffix) ? line.length() - suffix.length() : line.length() - suffix2.length())).equals(virtualDirectory)) {
                if (!blockfound) {
                    startEntry = lineCounter;
                } else {
                    endEntry = lineCounter;
                    this.list.add(new Range(startEntry, endEntry));
                    startEntry = -1;
                    endEntry = -1;
                    blockfound = false;
                }
            }
            if (line.startsWith("<Location /" + virtualDirectory + "/")) {
                if (!blockfound) {
                    startEntry = lineCounter;
                } else {
                    endEntry = lineCounter;
                    this.list.add(new Range(startEntry, endEntry));
                    startEntry = -1;
                    endEntry = -1;
                    blockfound = false;
                }
            }
            if (line.startsWith("Alias /" + virtualDirectory + "/")) {
                if (startEntry > 0) {
                    blockfound = true;
                } else {
                    this.list.add(new Integer(lineCounter));
                }
            }
            if (line.startsWith("RedirectMatch ^(?i)/" + virtualDirectory + "/") || line.startsWith("RedirectMatch ^(?i)/\\Q" + virtualDirectory + "\\E/")) {
                if (startEntry > 0) {
                    blockfound = true;
                } else {
                    this.list.add(new Integer(lineCounter));
                }
            }
            ++lineCounter;
            line = r2.readLine();
        }
    }

    private String createChangedOutput(String configFile, String virtualDirectory) throws IOException {
        FileReader reader = new FileReader(configFile);
        BufferedReader r2 = new BufferedReader(reader);
        String line = r2.readLine();
        int lineCounter = 1;
        StringBuilder b2 = new StringBuilder();
        HashSet<Integer> bArray = new HashSet<Integer>();
        for (Object obj : this.list) {
            if (obj instanceof Range) {
                Range range = (Range)obj;
                for (int i2 = range.getStart(); i2 <= range.getEnd(); ++i2) {
                    bArray.add(i2);
                }
                continue;
            }
            if (!(obj instanceof Integer)) continue;
            Integer integer = (Integer)obj;
            bArray.add(integer);
        }
        while (line != null) {
            if (bArray.contains(lineCounter)) {
                b2.append("# " + line);
            } else {
                b2.append(line);
            }
            b2.append("\r\n");
            ++lineCounter;
            line = r2.readLine();
        }
        r2.close();
        reader.close();
        return b2.toString();
    }

    private int addToApache(String file, String language, String configFile, String virtualDirectory) {
        try {
            this.readBlockAndLines(configFile, virtualDirectory);
            String changedOutput = this.createChangedOutput(configFile, virtualDirectory);
            String backupName = configFile + ".backup_" + DateFormat.getInstance().format(new Date()).replace(':', '_').replace('/', '_');
            this.handleCopyFile(new FileOutputStream(backupName), new FileInputStream(configFile));
            FileWriter fw2 = new FileWriter(configFile);
            fw2.append(changedOutput);
            fw2.flush();
            fw2.close();
            this.handleCopyFile(new FileOutputStream(configFile, true), new FileInputStream(file));
        }
        catch (Exception e2) {
            this.logger.printTrace(e2);
            if (!GraphicsEnvironment.isHeadless()) {
                JOptionPane.showMessageDialog(null, e2.getMessage(), "Setup", 0);
            }
            return -1;
        }
        return 0;
    }

    private void handleCopyFile(FileOutputStream fOut, FileInputStream fIn) throws FileNotFoundException, IOException {
        DataOutputStream out = new DataOutputStream(fOut);
        int b2 = fIn.read();
        while (b2 > -1) {
            out.write(b2);
            b2 = fIn.read();
        }
        out.flush();
        out.close();
    }

    private class Range {
        private final int start;
        private final int end;

        public Range(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }
    }
}

