/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.processing;

import com.coi.tools.os.win.NativeLibException;
import com.inet.setup.processing.ProcessingLogger;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.izforge.izpack.util.os.RegistryDefaultHandler;
import com.izforge.izpack.util.os.RegistryHandler;
import java.io.File;

public class ProcessingRegistry {
    private String installDir;
    private String extensionType;
    private String registerType;
    private ProcessingLogger logger;

    public void run(AbstractUIProcessHandler handler, String[] args) {
        boolean isDoRegister;
        this.logger = new ProcessingLogger(handler);
        this.installDir = args[0];
        this.extensionType = args[1];
        this.registerType = args[2];
        File installPath = new File(this.installDir);
        boolean bl2 = isDoRegister = !"0".equalsIgnoreCase(this.registerType);
        if (isDoRegister) {
            try {
                String javawdir = System.getenv("windir") + File.separatorChar + "system32" + File.separatorChar + "javaw.exe";
                File test = new File(javawdir);
                if (!test.exists()) {
                    javawdir = System.getProperty("java.home") + File.separatorChar + "bin" + File.separatorChar + "javaw.exe";
                }
                if (javawdir.contains(" ")) {
                    javawdir = "\"" + javawdir + "\"";
                }
                String iconPath = installPath.getAbsolutePath() + File.separatorChar + "lib" + File.separatorChar;
                if ("RPT".equalsIgnoreCase(this.extensionType)) {
                    this.registerExt("i-net Clear Reports Template", "i-net Clear Reports Template", ".rpt", "\"" + installPath + File.separatorChar + "startDesigner.bat\"", "application/clearreports.report", "\"" + iconPath + "cc-fileicon.ico\"", this.registerType, true);
                    this.registerExt("i-net Clear Reports Dataview", "i-net Clear Reports Dataview", ".dataview", "\"" + installPath + File.separatorChar + "startDesigner.bat\"", "application/clearreports.dataview", "\"" + iconPath + "dataview-fileicon.ico\"", this.registerType, true);
                } else {
                    this.registerExt("i-net Clear Reports Archive", "i-net Clear Reports Archive", ".jra", javawdir + " -jar \"" + installPath + File.separatorChar + "core" + File.separatorChar + "ReportViewer.jar\" ", "application/clearreports.jra", "\"" + iconPath + "cc-fileicon.ico\"", this.registerType, false);
                }
            }
            catch (Exception e2) {
                this.logger.printTrace(e2);
            }
        }
    }

    private void registerExt(String appName, String fullName, String extension, String path, String contentType, String icon, String installType, boolean newShell) throws NativeLibException {
        RegistryHandler reg = null;
        try {
            reg = RegistryDefaultHandler.getInstance();
        }
        catch (Exception e2) {
            this.logger.printTrace(e2);
            return;
        }
        reg.setRoot(Integer.MIN_VALUE);
        try {
            if (!reg.keyExist(extension)) {
                reg.createKey(extension);
            }
        }
        catch (Exception e3) {
            this.logger.printTrace(e3);
            return;
        }
        reg.setValue(extension, "", appName);
        reg.setValue(extension, "Content Type", contentType);
        reg.setValue(extension, "PerceivedType", "application");
        reg.setValue(extension + "\\OpenWithProgIDs", fullName, "");
        if (newShell) {
            reg.setValue(extension + "\\ShellNew", "ItemName", fullName);
            reg.setValue(extension + "\\ShellNew", "Command", path + " --new \"%1\"");
        }
        reg.setValue(appName, "", appName);
        try {
            String append = "";
            append = extension.equals(".rpt") || extension.equals(".dataview") ? " --open \"%1\"" : " \"%1\"";
            reg.setValue(appName + "\\shell\\open\\command", "", path + append);
        }
        catch (Exception e4) {
            this.logger.printTrace(e4);
        }
        if (icon != null) {
            reg.setValue(appName + "\\DefaultIcon", "", icon);
        }
    }
}

