/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.processing;

import com.inet.setup.processing.ProcessingLogger;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OsVersion;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;

public class ProcessingReportReader {
    private String installDir;
    private ProcessingLogger logger;

    public void run(AbstractUIProcessHandler handler, String[] args) {
        if (OsVersion.IS_WINDOWS) {
            this.logger = new ProcessingLogger(handler);
            this.installDir = args[0] + File.separator;
            try {
                this.processing();
            }
            catch (Exception e2) {
                this.logger.printTrace(e2);
            }
        }
    }

    private void processing() {
        if (this.checkRunning() && this.checkNETVersion()) {
            try {
                String[] commands = new String[]{this.installDir + "ReportReaderStart.exe"};
                Runtime.getRuntime().exec(commands, null, new File(this.installDir));
            }
            catch (IOException e2) {
                this.logger.printTrace(e2);
            }
        }
    }

    private boolean checkNETVersion() {
        int required = 2;
        int majorVersion = 0;
        try {
            String frameworkDir = System.getenv("WINDIR") + "\\Microsoft.NET\\Framework";
            File f2 = new File(frameworkDir);
            if (f2.exists() && f2.isDirectory()) {
                File[] files;
                for (File file : files = f2.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.startsWith("v") && dir.isDirectory() && name.contains(".");
                    }
                })) {
                    String name = file.getName();
                    majorVersion = Integer.valueOf(name.substring(1, name.indexOf(46)));
                    if (majorVersion < required) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Throwable t2) {
            return false;
        }
    }

    private boolean checkRunning() {
        String system32 = System.getenv("windir") + File.separatorChar + "system32";
        String[] commands = new String[]{system32 + File.separatorChar + "tasklist.exe"};
        StringBuilder b2 = null;
        try {
            Process exec = Runtime.getRuntime().exec(commands, null, new File(system32));
            InputStream inputStream = exec.getInputStream();
            b2 = new StringBuilder();
            int i2 = -1;
            while ((i2 = inputStream.read()) != -1) {
                b2.append((char)i2);
            }
            inputStream.close();
        }
        catch (Exception e2) {
            this.logger.printTrace(e2);
        }
        if (b2 == null) {
            return true;
        }
        if (b2.toString().contains("ReportReaderStart.exe")) {
            Debug.log((Object)"REPORT_READER_START_EXE FOUND", this.getClass());
            return false;
        }
        return true;
    }
}

