/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.processing;

import com.inet.looks.plastic.PlasticLookAndFeel;
import com.inet.looks.plastic.PlasticXPLookAndFeel;
import com.inet.looks.plastic.theme.InetCrystalClear;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class RemoveVirtualDirectory {
    private String language = "";
    private String installname = "";

    public static void main(String[] args) {
        RemoveVirtualDirectory proc = new RemoveVirtualDirectory();
        proc.language = args[1];
        proc.installname = args[2];
        if (new File(args[0]).exists()) {
            proc.removeFromApache(args[0]);
        }
    }

    private int removeFromApache(String configfile) {
        try {
            if (!GraphicsEnvironment.isHeadless()) {
                PlasticXPLookAndFeel laf_class = new PlasticXPLookAndFeel();
                PlasticLookAndFeel.setPlasticTheme(new InetCrystalClear());
                UIManager.setLookAndFeel(laf_class);
                JFrame.setDefaultLookAndFeelDecorated(true);
                JDialog.setDefaultLookAndFeelDecorated(true);
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            FileReader reader = new FileReader(configfile);
            BufferedReader r2 = new BufferedReader(reader);
            String line = r2.readLine();
            boolean oldconfigfound = false;
            boolean configfound = false;
            while (line != null) {
                if (line.startsWith("### i-net Clear Reports " + this.installname)) {
                    configfound = true;
                } else if (line.equals("### i-net Clear Reports")) {
                    oldconfigfound = true;
                }
                line = r2.readLine();
            }
            r2.close();
            reader.close();
            int result = 1;
            if (GraphicsEnvironment.isHeadless()) {
                result = 0;
            } else if (this.language.equals("deu")) {
                if (configfound) {
                    result = JOptionPane.showConfirmDialog(null, "Es wurde ein Eintrag f\u00fcr " + this.installname + " in der Apache Konfiguration gefunden.\nM\u00f6chten Sie diesen Eintrag ebenfalls entfernen?\nEs wird vorher eine Sicherungskopie der Konfiguration im selben Ordner erstellt.", "Uninstall", 0);
                } else if (oldconfigfound) {
                    result = JOptionPane.showConfirmDialog(null, "Es wurde ein Eintrag in der Apache Konfiguration gefunden.\nM\u00f6chten Sie diesen Eintrag ebenfalls entfernen?\nEs wird vorher eine Sicherungskopie der Konfiguration im selben Ordner erstellt.", "Uninstall", 0);
                }
            } else if (configfound) {
                result = JOptionPane.showConfirmDialog(null, "An entry for " + this.installname + " has been found in the apache configuration.\nDo you want to remove this entry as well?\nA backup of this configuration will first be stored in the same folder.", "Uninstall", 0);
            } else if (oldconfigfound) {
                result = JOptionPane.showConfirmDialog(null, "An entry in the apache configuration has been found.\nDo you want to remove this entry as well?\nA backup of this configuration will first be stored in the same folder.", "Uninstall", 0);
            }
            if (result == 0) {
                String backup_name = configfile + ".backup_" + DateFormat.getInstance().format(new Date()).replace(':', '_');
                FileOutputStream f_out = new FileOutputStream(backup_name);
                DataOutputStream out = new DataOutputStream(f_out);
                FileInputStream f_in = new FileInputStream(configfile);
                int b2 = f_in.read();
                while (b2 > -1) {
                    out.write(b2);
                    b2 = f_in.read();
                }
                out.flush();
                out.close();
                f_in.close();
                f_out.close();
                reader = new FileReader(backup_name);
                r2 = new BufferedReader(reader);
                line = r2.readLine();
                String start_tag = "### i-net Clear Reports";
                String end_tag = "### i-net Clear Reports";
                if (configfound) {
                    start_tag = "### i-net Clear Reports " + this.installname + " START";
                    end_tag = "### i-net Clear Reports " + this.installname + " END";
                }
                boolean ignore = false;
                f_out = new FileOutputStream(configfile, false);
                out = new DataOutputStream(f_out);
                int foundtimes = 0;
                while (line != null) {
                    if (line.equalsIgnoreCase(start_tag)) {
                        ignore = true;
                        ++foundtimes;
                    }
                    if (!ignore) {
                        out.write((line + "\n").getBytes());
                    }
                    if (start_tag.equalsIgnoreCase(end_tag) && foundtimes == 2 && ignore || ignore && !start_tag.equalsIgnoreCase(end_tag) && line.equalsIgnoreCase(end_tag)) {
                        ignore = false;
                        foundtimes = 0;
                    }
                    line = r2.readLine();
                }
                r2.close();
                reader.close();
                out.flush();
                out.close();
            }
        }
        catch (FileNotFoundException e3) {
            e3.printStackTrace();
            if (GraphicsEnvironment.isHeadless()) {
                System.err.println("\n" + e3.getMessage() + "\n");
            } else {
                JOptionPane.showMessageDialog(null, e3.getMessage());
            }
            return -1;
        }
        catch (Exception e4) {
            e4.printStackTrace();
            if (GraphicsEnvironment.isHeadless()) {
                System.err.println("\n" + e4.getMessage() + "\n");
            } else {
                JOptionPane.showMessageDialog(null, e4.getMessage());
            }
            return -1;
        }
        return 0;
    }
}

