/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.processing;

import com.inet.setup.processing.FileProperties;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;

public class ServletBuilder {
    private String webXml = "";
    private String localDir = "setup_tmp";
    private List<FileProperties> libs;
    private List<FileProperties> cores;
    private List<FileProperties> classes;
    private List<FileProperties> webinf;
    private List<FileProperties> metainf;
    private List<FileProperties> files;
    private File warfile;
    private String dirExtension = "";
    private boolean hasVendorWeblogic = false;
    private boolean hasVendorWebsphere = false;
    private String root = null;
    private String configname = "";
    protected static final int WEBLOGIC = 0;
    protected static final int WEBSPHERE = 1;
    private final String[] rootFiles = new String[]{"Sample.jsp", "sample.rpt", "favicon.ico"};
    private final String[] libFiles = new String[0];
    private AbstractUIProcessHandler handler = null;

    public ServletBuilder() {
        this.libs = new ArrayList<FileProperties>();
        this.cores = new ArrayList<FileProperties>();
        this.classes = new ArrayList<FileProperties>();
        this.webinf = new ArrayList<FileProperties>();
        this.metainf = new ArrayList<FileProperties>();
        this.files = new ArrayList<FileProperties>();
    }

    public void setLocalDir(String ld) {
        this.localDir = ld;
    }

    public void setWarFile(File file) {
        this.warfile = file;
    }

    public void setWebXML(String version) {
        this.webXml = version.equalsIgnoreCase("2.4") ? this.localDir + "webxml/web2_4_or.xml" : (version.equalsIgnoreCase("2.5") ? this.localDir + "webxml/web2_5_or.xml" : this.localDir + "webxml/web2_3_or.xml");
    }

    public void setVendor(int vendor) {
        switch (vendor) {
            case 0: {
                this.hasVendorWeblogic = true;
                break;
            }
            case 1: {
                this.hasVendorWebsphere = true;
                break;
            }
        }
    }

    public void setConfigname(String configname) {
        this.configname = configname;
    }

    public void addLib(FileProperties lib) {
        this.libs.add(lib);
    }

    public void addCore(FileProperties core) {
        this.cores.add(core);
    }

    private void addClasses(FileProperties classe) {
        this.classes.add(classe);
    }

    private void addWebinf(FileProperties webinfFile) {
        this.webinf.add(webinfFile);
    }

    private void addMetainf(FileProperties metainfFile) {
        this.metainf.add(metainfFile);
    }

    private void parseWEBINF(File dir) {
        if (dir.exists()) {
            File[] dateien = dir.listFiles();
            for (int i2 = 0; i2 < dateien.length; ++i2) {
                File f2 = dateien[i2];
                if (f2.isFile()) {
                    FileProperties prop = new FileProperties(f2.getName(), f2.getAbsolutePath());
                    this.addWebinf(prop);
                }
                f2 = null;
            }
        }
    }

    private void parseMETAINF(File dir) {
        if (dir.exists()) {
            File[] dateien = dir.listFiles();
            for (int i2 = 0; i2 < dateien.length; ++i2) {
                File f2 = dateien[i2];
                if (f2.isFile()) {
                    FileProperties prop = new FileProperties(f2.getName(), f2.getAbsolutePath());
                    this.addMetainf(prop);
                }
                f2 = null;
            }
        }
    }

    private void parseWEBINFLIB(File dir) {
        if (dir.exists()) {
            File[] dateien = dir.listFiles();
            for (int i2 = 0; i2 < dateien.length; ++i2) {
                File f2 = dateien[i2];
                if (f2.isFile()) {
                    FileProperties prop = new FileProperties(f2.getName(), f2.getAbsolutePath());
                    this.addLib(prop);
                } else {
                    this.parseWEBINFLIB(f2);
                }
                f2 = null;
            }
        }
    }

    private void parseCore(File dir, String prefix) {
        if (dir.exists()) {
            File[] dateien = dir.listFiles();
            for (int i2 = 0; i2 < dateien.length; ++i2) {
                File f2 = dateien[i2];
                if (f2.isFile()) {
                    FileProperties prop = prefix != null && prefix.length() > 0 ? new FileProperties(prefix + "/" + f2.getName(), f2.getAbsolutePath()) : new FileProperties(f2.getName(), f2.getAbsolutePath());
                    this.addCore(prop);
                } else {
                    this.parseCore(f2, f2.getAbsolutePath().substring(f2.getAbsolutePath().lastIndexOf(File.separatorChar) + 1));
                }
                f2 = null;
            }
        }
    }

    private void parseExtras(File dir) {
        if (this.root == null) {
            this.root = dir.getAbsolutePath();
        }
        if (dir.exists()) {
            File[] dateien = dir.listFiles();
            for (int i2 = 0; i2 < dateien.length; ++i2) {
                File f2 = dateien[i2];
                if (f2.isFile()) {
                    String name = f2.getAbsolutePath().substring(this.root.length() + 1);
                    FileProperties prop = new FileProperties(name, f2.getAbsolutePath());
                    this.addClasses(prop);
                } else {
                    this.parseExtras(f2);
                }
                f2 = null;
            }
        }
    }

    public void createWar() throws IOException {
        FileProperties props;
        int i2;
        for (String rootFile : this.rootFiles) {
            FileProperties file_props = new FileProperties(rootFile, this.localDir + rootFile);
            this.files.add(file_props);
        }
        String parent = new File(this.localDir).getParent();
        if (parent != null && new File(parent + File.separatorChar + "remotelogin.xml").exists()) {
            FileProperties file_props = new FileProperties("remotelogin.xml", parent + File.separatorChar + "remotelogin.xml");
            this.files.add(file_props);
        }
        for (String libFile : this.libFiles) {
            File f2 = new File(this.localDir + File.separatorChar + libFile);
            FileProperties prop = new FileProperties(f2.getName(), f2.getAbsolutePath());
            this.addLib(prop);
        }
        File ext_file = new File(this.localDir + File.separatorChar + "WEB-INF");
        this.parseWEBINF(ext_file);
        ext_file = new File(this.localDir + File.separatorChar + "META-INF");
        this.parseMETAINF(ext_file);
        ext_file = new File(this.localDir + File.separatorChar + "WEB-INF" + File.separatorChar + "/lib");
        this.parseWEBINFLIB(ext_file);
        ext_file = new File(this.localDir + File.separatorChar + "/core");
        this.parseCore(ext_file, "");
        ext_file = new File(this.localDir + File.separatorChar + "/extras");
        this.parseExtras(ext_file);
        ext_file = null;
        int steps = 11 + this.libFiles.length + this.libs.size() + this.classes.size() + this.files.size() + this.webinf.size();
        this.handler.setMaxSteps(steps);
        int step = 0;
        File f3 = new File(this.localDir + File.separatorChar + "WEB-INF" + File.separatorChar + "classes" + File.separatorChar + "configuration.xml");
        FileProperties prop = new FileProperties("WEB-INF/classes/configuration_" + this.configname + ".xml", f3.getAbsolutePath());
        this.addClasses(prop);
        this.handler.progress(step++, "");
        FileOutputStream outStream = null;
        JarOutputStream jarOut = null;
        try {
            try {
                File dirs = this.warfile.getParentFile();
                dirs.mkdirs();
                this.warfile.createNewFile();
            }
            catch (IOException e2) {
                e2.printStackTrace();
                return;
            }
            outStream = new FileOutputStream(this.warfile);
        }
        catch (FileNotFoundException ex2) {
            ex2.printStackTrace();
            return;
        }
        this.handler.progress(step++, "");
        try {
            jarOut = new JarOutputStream(outStream);
        }
        catch (IOException io_ex) {
            io_ex.printStackTrace();
        }
        JarEntry entry = new JarEntry(this.dirExtension + "WEB-INF/web.xml");
        this.addWebXMLWithoutMapping(jarOut, entry);
        this.handler.progress(step++, "");
        if (this.hasVendorWeblogic) {
            this.addWeblogicVendor(jarOut);
        }
        this.handler.progress(step++, "");
        if (this.hasVendorWebsphere) {
            this.addWebsphereVendor(jarOut);
        }
        this.handler.progress(step++, "");
        for (i2 = 0; i2 < this.libs.size(); ++i2) {
            props = this.libs.get(i2);
            this.writeEntry(jarOut, this.dirExtension + "WEB-INF/lib/" + props.getFileName().replace('\\', '/'), props.getAbsPath());
            this.handler.progress(step++, "");
        }
        for (i2 = 0; i2 < this.classes.size(); ++i2) {
            props = this.classes.get(i2);
            this.writeEntry(jarOut, this.dirExtension + props.getFileName().replace('\\', '/'), props.getAbsPath());
            this.handler.progress(step++, "");
        }
        for (i2 = 0; i2 < this.files.size(); ++i2) {
            props = this.files.get(i2);
            this.writeEntry(jarOut, this.dirExtension + props.getFileName().replace('\\', '/'), props.getAbsPath());
            this.handler.progress(step++, "");
        }
        for (i2 = 0; i2 < this.cores.size(); ++i2) {
            props = this.cores.get(i2);
            this.writeEntry(jarOut, this.dirExtension + "core/" + props.getFileName().replace('\\', '/'), props.getAbsPath());
            this.handler.progress(step++, "");
        }
        for (i2 = 0; i2 < this.metainf.size(); ++i2) {
            props = this.metainf.get(i2);
            this.writeEntry(jarOut, this.dirExtension + "META-INF/" + props.getFileName().replace('\\', '/'), props.getAbsPath());
            this.handler.progress(step++, "");
        }
        for (i2 = 0; i2 < this.webinf.size(); ++i2) {
            props = this.webinf.get(i2);
            this.writeEntry(jarOut, this.dirExtension + "WEB-INF/" + props.getFileName().replace('\\', '/'), props.getAbsPath());
            this.handler.progress(step++, "");
        }
        try {
            entry = new JarEntry(this.dirExtension + "META-INF/MANIFEST.MF");
            String str = "Manifest-Version: 1.0";
            jarOut.putNextEntry(entry);
            jarOut.write(str.getBytes());
        }
        catch (IOException io_ex) {
            io_ex.printStackTrace();
        }
        this.handler.progress(step++, "");
        try {
            jarOut.closeEntry();
            jarOut.flush();
            jarOut.finish();
            jarOut.close();
            outStream.flush();
            outStream.close();
        }
        catch (IOException io_ex) {
            io_ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeEntry(JarOutputStream jarOut, String entryName, String entryAbsPath) {
        JarEntry entry = new JarEntry(entryName);
        InputStream inStream = null;
        BufferedInputStream bufInStream = null;
        try {
            jarOut.putNextEntry(entry);
            inStream = new FileInputStream(entryAbsPath);
            bufInStream = new BufferedInputStream(inStream);
            this.writeBytes(jarOut, bufInStream);
        }
        catch (IOException io_ex) {
            io_ex.printStackTrace();
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
                if (bufInStream != null) {
                    bufInStream.close();
                }
            }
            catch (Exception e2) {}
        }
    }

    private void writeBytes(JarOutputStream jarOut, BufferedInputStream inStream) throws IOException {
        int len;
        byte[] buff = new byte[32768];
        while ((len = inStream.read(buff)) > 0) {
            jarOut.write(buff, 0, len);
        }
    }

    private void addWebsphereVendor(JarOutputStream jarOut) {
        String line;
        LineNumberReader in_reader;
        JarEntry entry = new JarEntry(this.dirExtension + "WEB-INF/ibm-web-bnd.xmi");
        try {
            jarOut.putNextEntry(entry);
            in_reader = new LineNumberReader(new FileReader(this.localDir + "webxml/ibm-web-bnd.xmi"));
            line = in_reader.readLine();
            while (line != null) {
                line = line + "\n";
                jarOut.write(line.getBytes());
                line = in_reader.readLine();
            }
        }
        catch (IOException io_ex) {
            io_ex.printStackTrace();
        }
        entry = new JarEntry(this.dirExtension + "WEB-INF/ibm-web-ext.xmi");
        try {
            jarOut.putNextEntry(entry);
            in_reader = new LineNumberReader(new FileReader(this.localDir + "webxml/ibm-web-ext.xmi"));
            line = in_reader.readLine();
            while (line != null) {
                line = line + "\n";
                jarOut.write(line.getBytes());
                line = in_reader.readLine();
            }
        }
        catch (IOException io_ex) {
            io_ex.printStackTrace();
        }
    }

    private void addWeblogicVendor(JarOutputStream jarOut) {
        JarEntry entry = new JarEntry(this.dirExtension + "WEB-INF/weblogic.xml");
        try {
            jarOut.putNextEntry(entry);
            LineNumberReader in_reader = new LineNumberReader(new FileReader(this.localDir + "webxml/weblogic.xml"));
            String line = in_reader.readLine();
            while (line != null) {
                line = line + "\n";
                jarOut.write(line.getBytes());
                line = in_reader.readLine();
            }
        }
        catch (IOException io_ex) {
            io_ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWebXMLWithoutMapping(JarOutputStream jarOut, JarEntry entry) {
        FileInputStream fin_stream = null;
        BufferedInputStream bufInStream = null;
        try {
            jarOut.putNextEntry(entry);
            fin_stream = new FileInputStream(this.webXml);
            bufInStream = new BufferedInputStream(fin_stream);
            this.writeBytes(jarOut, bufInStream);
        }
        catch (IOException io_ex) {
            io_ex.printStackTrace();
        }
        finally {
            if (fin_stream != null) {
                try {
                    fin_stream.close();
                }
                catch (Exception e2) {}
            }
            if (bufInStream != null) {
                try {
                    bufInStream.close();
                }
                catch (Exception e3) {}
            }
        }
    }

    void copyFile(String source, String dest) throws IOException {
        File path;
        File out_file = new File(dest);
        if (out_file.exists()) {
            try {
                out_file.delete();
            }
            catch (SecurityException se) {
                se.printStackTrace();
                return;
            }
        }
        if (!(path = new File(out_file.getParent())).exists()) {
            try {
                path.mkdirs();
            }
            catch (SecurityException se) {
                se.printStackTrace();
                return;
            }
        }
        out_file.createNewFile();
        File in_file = new File(source);
        FileOutputStream f_out = null;
        try {
            f_out = new FileOutputStream(out_file);
        }
        catch (FileNotFoundException ex2) {
            ex2.printStackTrace();
        }
        FileInputStream in_stream = null;
        try {
            in_stream = new FileInputStream(in_file);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        if (in_stream != null && f_out != null) {
            FileChannel in = in_stream.getChannel();
            FileChannel out = f_out.getChannel();
            if (in != null && out != null) {
                out.transferFrom(in, 0L, in.size());
                in.close();
                out.close();
            }
            f_out.close();
            in_stream.close();
        }
    }

    void delete(String datei) {
        try {
            File f2 = new File(datei);
            if (f2.exists()) {
                f2.delete();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void setHandler(AbstractUIProcessHandler handler) {
        this.handler = handler;
    }
}

