/*
 * Decompiled with CFR 0.152.
 */
package com.inet.textui;

import com.inet.report.config.gui.widget.LicensePane;
import com.inet.textui.Group;
import com.inet.textui.i18n.Msg;
import com.izforge.izpack.util.AbstractUIHandler;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public abstract class BaseTextUI
implements ChangeListener,
AbstractUIHandler {
    private JProgressBar currentProgressBar = null;
    private String currentProgressbarLabel = "";
    private int currentProgressBarValue = 0;

    public abstract Group getNextGroup();

    public void run() {
        block2: while (true) {
            Group group;
            if (this.hasEditableComponent(group = this.getNextGroup())) {
                this.printLabel("\n\n");
                this.printThickBorder();
                this.printLabel(group.getTitle());
                this.printThinBorder();
                this.printLabel("\n\n");
            }
            if (group == null) {
                if (System.getProperty("runningtextuitest") == null) {
                    System.out.println();
                    System.exit(0);
                } else {
                    System.out.println();
                    System.out.println("Finished");
                }
                return;
            }
            while (true) {
                Group.Entry entry;
                if ((entry = group.getNextComponent()) == null) {
                    String errMessage = group.isValid();
                    if (errMessage == null) continue block2;
                    System.out.println(errMessage);
                    group.reset();
                    continue block2;
                }
                try {
                    this.handleComponent(entry);
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                    throw new RuntimeException(e2);
                }
            }
            break;
        }
    }

    private boolean hasEditableComponent(Group group) {
        if (group == null) {
            return false;
        }
        try {
            while (true) {
                Group.Entry entry;
                if ((entry = group.getNextComponent()) == null) {
                    boolean bl2 = false;
                    return bl2;
                }
                JComponent comp = entry.getComponent();
                if (!BaseTextUI.isEditable(comp) || !(comp instanceof LicensePane) && !(comp instanceof JPasswordField) && !(comp instanceof JTextField) && !(comp instanceof AbstractButton) && !(comp instanceof JEditorPane) && !(comp instanceof JComboBox) && !(comp instanceof JProgressBar)) continue;
                boolean bl3 = true;
                return bl3;
            }
        }
        finally {
            group.reset();
        }
    }

    private void printThickBorder() {
        this.printLabel("============================================================\n");
    }

    private void printThinBorder() {
        this.printLabel("\n------------------------------------------------------------");
    }

    private void handleComponent(Group.Entry entry) throws IOException {
        JComponent comp = entry.getComponent();
        if (comp instanceof JEditorPane) {
            this.handleEditorPane((JEditorPane)comp);
        } else {
            if (!BaseTextUI.isEditable(comp)) {
                return;
            }
            if (comp instanceof LicensePane) {
                this.handleLicensePane(entry.getLabel(), (LicensePane)comp);
            } else if (comp instanceof JPasswordField) {
                this.handlePasswordField(entry.getLabel(), (JPasswordField)comp);
            } else if (comp instanceof JTextField) {
                this.handleTextField(entry.getLabel(), (JTextField)comp);
            } else if (comp instanceof JTextArea) {
                this.handleJTextArea(entry.getLabel(), (JTextArea)comp);
            } else if (comp instanceof JLabel) {
                this.handleJLabel((JLabel)comp);
            } else if (comp instanceof AbstractButton) {
                ButtonModel model = ((AbstractButton)comp).getModel();
                if (model instanceof DefaultButtonModel) {
                    ButtonGroup group = ((DefaultButtonModel)model).getGroup();
                    if (group != null) {
                        this.handleButtonGroup(group);
                    } else if (comp instanceof JToggleButton) {
                        String text = ((JToggleButton)comp).getText();
                        if (text == null || text.length() == 0) {
                            text = entry.getLabel();
                        }
                        this.handleToggleButton(text, (JToggleButton)comp);
                    }
                }
            } else if (comp instanceof JComboBox) {
                this.handleJComboBox(entry.getLabel(), (JComboBox)comp);
            } else if (comp instanceof JTable) {
                this.handleJTable((JTable)comp);
            } else if (comp instanceof JProgressBar) {
                this.handleJProgessBar((JProgressBar)comp);
            } else {
                throw new IllegalArgumentException("Not supported component:" + comp.getClass());
            }
        }
    }

    private void handlePasswordField(String label, JPasswordField comp) throws IOException {
        String value;
        if (label != null && label.trim().length() > 0) {
            if (label.trim().endsWith(":")) {
                label = label.trim();
                label = label.substring(0, label.length() - 1);
            }
            this.printLabel(label);
        }
        if (!this.isEmpty(value = new String(comp.getPassword()))) {
            this.printLabel(" (" + value + ")");
        }
        this.printLabel(" : ");
        value = this.readLine();
        if (!this.isEmpty(value)) {
            comp.setText(value.trim());
        }
    }

    private static boolean isEditable(Component comp) {
        if (comp.getParent() != null && !BaseTextUI.isEditable(comp.getParent())) {
            return false;
        }
        if (comp instanceof JTextComponent && !((JTextComponent)comp).isEditable()) {
            return false;
        }
        return comp.isEnabled() && comp.isVisible();
    }

    private void handleTextField(String label, JTextField comp) throws IOException {
        String value;
        if (label != null && label.trim().length() > 0) {
            if (label.trim().endsWith(":")) {
                label = label.trim();
                label = label.substring(0, label.length() - 1);
            }
            if (label.indexOf("\n") != -1) {
                this.printLabel("\n");
            }
            this.printLabel(label);
        }
        if (!this.isEmpty(value = comp.getText())) {
            this.printLabel(" (" + value + ")");
            this.printLabel(" : ");
        } else {
            this.printLabel(": ");
        }
        value = this.readLine();
        if (!this.isEmpty(value)) {
            comp.setText(value);
        }
    }

    private void handleLicensePane(String label, LicensePane comp) throws IOException {
        if (label != null && label.trim().length() > 0) {
            this.printLabel(label);
        }
        String[] licenseKeyArray = comp.getLicenseKeyArray();
        String value = null;
        if (licenseKeyArray.length > 0) {
            value = licenseKeyArray[0];
        }
        if (!this.isEmpty(value)) {
            this.printLabel(" (" + value.substring(0, 30) + ")");
        }
        this.printLabel(" : ");
        value = this.readLine();
        if (!this.isEmpty(value)) {
            comp.addNewLicense(value, true);
        }
    }

    private void handleJLabel(JLabel comp) throws IOException {
        this.printLabel(comp.getText() + "\n\n");
    }

    private void handleButtonGroup(ButtonGroup group) throws IOException {
        while (true) {
            Enumeration<AbstractButton> buttons = group.getElements();
            ArrayList<AbstractButton> list = new ArrayList<AbstractButton>();
            int defaultIdx = 0;
            while (buttons.hasMoreElements()) {
                AbstractButton button = buttons.nextElement();
                if (!button.isEnabled()) continue;
                list.add(button);
                String text = button.getText();
                this.printLabel(list.size() + " - " + text + '\n');
                if (!button.isSelected()) continue;
                defaultIdx = list.size();
            }
            if (list.size() <= 0) break;
            this.printLabel(Msg.getMsg("PleaseChoose") + " ");
            if (defaultIdx > 0) {
                this.printLabel("(" + defaultIdx + ")");
            }
            this.printLabel(": ");
            String value = this.readLine();
            try {
                int idx = this.isEmpty(value) ? defaultIdx : Integer.parseInt(value);
                AbstractButton button = (AbstractButton)list.get(--idx);
                ButtonModel model = button.getModel();
                if (!model.isArmed()) {
                    model.setArmed(true);
                }
                model.setPressed(true);
                model.setPressed(false);
                button.setSelected(true);
            }
            catch (NumberFormatException ex2) {
                this.printLabel(Msg.getMsg("EnterNumber", new Integer(list.size())) + "\n");
                continue;
            }
            catch (IndexOutOfBoundsException aie) {
                this.printInvalid();
                continue;
            }
            break;
        }
    }

    private void printInvalid() {
        this.printLabel(Msg.getMsg("InvalidAnswer") + "\n");
    }

    private void handleToggleButton(String label, JToggleButton button) throws IOException {
        boolean bool;
        String value = "";
        while (true) {
            if (label != null && label.trim().length() > 0) {
                if (label.trim().endsWith(":")) {
                    label = label.trim();
                    label = label.substring(0, label.length() - 1);
                }
                this.printLabel(label);
            }
            if (button.getName() != null && button.getName().startsWith("LicenseAgree")) {
                this.printLabel(" (y/n): ");
                value = this.readLine();
                if (this.isEmpty(value)) {
                    continue;
                }
            } else {
                if (button.isSelected()) {
                    this.printLabel(" (Y/n): ");
                } else {
                    this.printLabel(" (y/N): ");
                }
                value = this.readLine();
                if (this.isEmpty(value)) {
                    return;
                }
            }
            if ((value = value.toLowerCase()).equalsIgnoreCase("y")) {
                bool = true;
                break;
            }
            if (value.equalsIgnoreCase("n")) {
                bool = false;
                break;
            }
            this.printInvalid();
        }
        if (!bool && button.getName() != null && button.getName().startsWith("LicenseAgree")) {
            System.exit(0);
        }
        ButtonModel model = button.getModel();
        button.setSelected(!bool);
        if (!model.isArmed()) {
            model.setArmed(true);
        }
        model.setPressed(true);
        model.setPressed(false);
        button.setSelected(bool);
    }

    private void handleEditorPane(JEditorPane editor) throws IOException {
        try {
            String plainText = "";
            int tries = 0;
            do {
                plainText = editor.getText(0, editor.getDocument().getLength());
                ++tries;
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
            } while (plainText.length() == 0 && tries < 5);
            int line = 1;
            while (true) {
                if (plainText.length() > 0) {
                    plainText = this.printTextLines(plainText);
                    continue;
                }
                if (plainText.length() == 0) {
                    return;
                }
                if (++line % 20 != 0) continue;
                int maxline = line + 20;
                char startCharacter = plainText.charAt(0);
                while (line % maxline != 0 && startCharacter != '\n' && startCharacter != '0' && startCharacter != '1' && startCharacter != '2' && startCharacter != '3' && startCharacter != '4' && startCharacter != '5' && startCharacter != '6' && startCharacter != '7' && startCharacter != '8' && startCharacter != '9') {
                    if ((plainText = this.printTextLines(plainText)).length() == 0) {
                        return;
                    }
                    startCharacter = plainText.charAt(0);
                    ++line;
                }
                this.printLabel("\n" + Msg.getMsg("EnterToContinue") + "  : ");
                this.readLine();
                this.printLabel("\n\r");
            }
        }
        catch (BadLocationException ex2) {
            this.printLabel(ex2.toString() + '\n');
            return;
        }
    }

    private String printTextLines(String plainText) {
        int maxLength = 80;
        int startIndex = 0;
        int cutIndex = startIndex + maxLength;
        if (plainText.length() < maxLength) {
            this.printLabel(plainText);
            this.printLabel("\n");
            return "";
        }
        while (true) {
            if (cutIndex > plainText.length()) break;
            if (plainText.indexOf(10, startIndex) != -1 && plainText.indexOf(10, startIndex) < cutIndex) {
                this.printLabel(plainText.substring(startIndex, plainText.indexOf(10, startIndex)).trim());
                this.printLabel("\n");
                startIndex = plainText.indexOf(10, startIndex) + "\n".length();
                cutIndex = startIndex + maxLength;
                continue;
            }
            cutIndex = plainText.lastIndexOf(" ", cutIndex);
            this.printLabel(plainText.substring(startIndex, cutIndex).trim());
            this.printLabel("\n");
            startIndex = cutIndex + 1;
            cutIndex = startIndex + maxLength;
        }
        this.printLabel(plainText.substring(startIndex).trim());
        this.printLabel("\n");
        return "";
    }

    private void handleJComboBox(String label, JComboBox box) throws IOException {
        this.printLabel("\n");
        if (label != null && label.trim().length() > 0) {
            if (!label.endsWith(":")) {
                label = label + " :";
            }
            this.printLabel(label + "\n");
        }
        while (true) {
            block12: {
                int defaultIdx = box.getSelectedIndex();
                for (int i2 = 0; i2 < box.getItemCount(); ++i2) {
                    Object obj = box.getItemAt(i2);
                    this.printLabel(i2 + 1 + " - " + obj + '\n');
                }
                this.printLabel(Msg.getMsg("PleaseChoose"));
                if (defaultIdx >= 0) {
                    this.printLabel("(" + (defaultIdx + 1) + ")");
                }
                if (box.isEditable()) {
                    this.printLabel(" " + Msg.getMsg("AnotherValue") + ": ");
                } else {
                    this.printLabel(": ");
                }
                String value = this.readLine();
                if (value.length() == 0 && defaultIdx >= 0) {
                    box.setSelectedIndex(defaultIdx);
                    break;
                }
                try {
                    int idx = Integer.parseInt(value) - 1;
                    if (idx < box.getItemCount() && idx >= 0) {
                        box.setSelectedIndex(idx);
                        break;
                    }
                    if (box.isEditable()) {
                        box.setSelectedItem(value);
                    }
                    break block12;
                }
                catch (Exception ex2) {
                    if (!box.isEditable()) break block12;
                    box.setSelectedItem(value);
                }
                break;
            }
            this.printInvalid();
        }
    }

    private void handleJTextArea(String label, JTextArea area) throws IOException {
        if (label != null && label.trim().length() > 0) {
            if (!label.endsWith(":")) {
                label = label + " :";
            }
            this.printLabel(label + "\n");
        }
        String text = area.getText();
        while (text.length() > 80) {
            text = text.trim();
            this.printLabel(text.substring(0, 80));
            this.printLabel("\n");
            text = text.substring(80);
        }
        this.printLabel(text);
        this.printLabel("\n");
    }

    private void handleJTable(JTable table) throws IOException {
        TableModel model = table.getModel();
        for (int i2 = 0; i2 < model.getRowCount(); ++i2) {
            Object value = model.getValueAt(i2, 0);
            if (value instanceof Integer) {
                int intValue = (Integer)value;
                switch (intValue) {
                    case -2: 
                    case -1: {
                        this.printLabel("-   ");
                        this.printLabel("   ");
                        break;
                    }
                    case 0: {
                        this.printLabel(i2 + "   ");
                        this.printLabel("O  ");
                        break;
                    }
                    default: {
                        this.printLabel(i2 + "   ");
                        this.printLabel("X  ");
                    }
                }
            }
            if ((value = model.getValueAt(i2, 1)) instanceof String) {
                String tablecomponent = (String)value;
                if (table.getSelectedRow() == i2) {
                    tablecomponent = "[" + tablecomponent + "]";
                }
                this.printLabel(tablecomponent + "\n");
            }
            this.printLabel("\n");
        }
    }

    private void handleJProgessBar(JProgressBar progressbar) throws IOException {
        if (!progressbar.equals(this.currentProgressBar)) {
            this.currentProgressBar = progressbar;
            progressbar.addChangeListener(this);
        }
    }

    public void stateChanged(ChangeEvent e2) {
        if (e2.getSource() instanceof JProgressBar) {
            int newNumber;
            int howManyStepsToPrint;
            JProgressBar progressbar = (JProgressBar)e2.getSource();
            int current = progressbar.getValue();
            int max = progressbar.getMaximum();
            if (max == 0) {
                max = 100;
            }
            if ((howManyStepsToPrint = (newNumber = (int)((float)current / (float)max * 60.0f)) - this.currentProgressBarValue) > 0) {
                if (!this.currentProgressbarLabel.equalsIgnoreCase(progressbar.getString())) {
                    this.currentProgressbarLabel = progressbar.getString();
                    this.printLabel("\n" + this.currentProgressbarLabel + "\n");
                    this.printRuler();
                }
                this.printProgress(howManyStepsToPrint);
            }
            this.currentProgressBarValue = newNumber;
            if (current == max) {
                this.printLabel("\n");
            }
        }
    }

    private void printRuler() {
        this.printLabel("\n0%                           50%                          100%");
        this.printLabel("\n|-----------------------------|----------------------------|\n");
    }

    private void printProgress(int howManyStepsToPrint) {
        char[] steps = new char[howManyStepsToPrint];
        Arrays.fill(steps, '#');
        this.printLabel(new String(steps));
    }

    private void printLabel(String label) {
        System.out.print(label);
    }

    private String readLine() throws IOException {
        byte[] buffer = new byte[8192];
        int count = System.in.read(buffer);
        if (count > 0) {
            if (buffer[count - 1] == 13) {
                --count;
            } else if (buffer[count - 1] == 10 && --count > 0 && buffer[count - 1] == 13) {
                --count;
            }
            return new String(buffer, 0, count);
        }
        return "";
    }

    private boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }

    public int askQuestion(String title, String question, int choices) {
        return this.askQuestion(title, question, choices, -1);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int askQuestion(String title, String question, int choices, int defaultChoice) {
        try {
            while (true) {
                String answer;
                this.printLabel("\n");
                while (question.length() > 0) {
                    question = this.printTextLines(question);
                }
                this.printTextLines("1 - " + Msg.getMsg("Yes"));
                this.printTextLines("2 - " + Msg.getMsg("No"));
                if (choices == 38) {
                    this.printTextLines("3 - " + Msg.getMsg("Cancel"));
                }
                this.printLabel(Msg.getMsg("PleaseChoose"));
                if (defaultChoice >= 0) {
                    int choiceNumber = 0;
                    switch (defaultChoice) {
                        case 45: {
                            choiceNumber = 3;
                            break;
                        }
                        case 49: {
                            choiceNumber = 2;
                            break;
                        }
                        default: {
                            choiceNumber = 1;
                        }
                    }
                    this.printLabel("(" + choiceNumber + "): ");
                } else {
                    this.printLabel(": ");
                }
                try {
                    answer = this.readLine();
                    if (answer.length() == 0 && defaultChoice >= 0) {
                        int n2 = defaultChoice;
                        return n2;
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                    int n3 = -1;
                    return n3;
                }
                catch (NumberFormatException e3) {
                    this.emitError(null, Msg.getMsg("EnterValidNumber"));
                    continue;
                }
                int answerNumber = Integer.valueOf(answer);
                switch (answerNumber) {
                    case 1: {
                        int n4 = 47;
                        return n4;
                    }
                    case 2: {
                        int n5 = 49;
                        return n5;
                    }
                    case 3: {
                        if (choices != 38) break;
                        int n6 = 45;
                        return n6;
                    }
                }
                {
                    this.emitError(null, Msg.getMsg("EnterValidNumber"));
                    continue;
                }
                break;
            }
        }
        finally {
            if (this.currentProgressBarValue > 0) {
                this.printRuler();
                this.printProgress(this.currentProgressBarValue);
            }
        }
    }

    public void emitError(String title, String message) {
        this.printLabel("\n>>> " + Msg.getMsg("Error") + ": " + message);
    }

    public void emitErrorAndBlockNext(String title, String message) {
        this.printLabel("\n>>> " + Msg.getMsg("Error") + ": " + message);
    }

    public void emitNotification(String title, String message) {
        this.printTextLines(message);
    }

    public void emitWarning(String title, String message) {
        this.emitNotification(title, message);
        this.askQuestion(null, Msg.getMsg("WantToContinue"), 37, 47);
    }

    public String askForPassword(String explanation) throws IOException {
        String pw1;
        this.printLabel(explanation);
        String prompt = "\n" + Msg.getMsg("Password") + ": ";
        while (true) {
            this.printLabel(prompt);
            pw1 = this.readLine();
            if (pw1.length() >= 8) break;
            this.printLabel("\n" + Msg.getMsg("8CharPassword") + "\n");
        }
        return pw1;
    }

    public static void main(String[] args) {
        new BaseTextUI(){

            public Group getNextGroup() {
                return null;
            }
        }.run();
    }
}

