/*
 * Decompiled with CFR 0.152.
 */
package com.inet.textui.i18n;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Msg {
    private static HashMap<Locale, ResourceBundle> bundleCache = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResourceBundle getResourceBundle(Locale locale) {
        HashMap<Locale, ResourceBundle> hashMap = bundleCache;
        synchronized (hashMap) {
            ResourceBundle bundle = bundleCache.get(locale);
            if (bundle != null) {
                return bundle;
            }
            try {
                bundle = ResourceBundle.getBundle("com.inet.textui.i18n.LanguageResources", locale);
                bundleCache.put(locale, bundle);
                return bundle;
            }
            catch (MissingResourceException e2) {
                return null;
            }
        }
    }

    public static String getMsg(String msgID) {
        String msg;
        try {
            msg = Msg.getResourceBundle(Locale.getDefault()).getString(msgID);
        }
        catch (Throwable e2) {
            msg = "$" + msgID + "$";
        }
        return msg;
    }

    public static boolean hasMsg(String msgID) {
        try {
            Msg.getResourceBundle(Locale.getDefault()).getString(msgID);
        }
        catch (Throwable e2) {
            return false;
        }
        return true;
    }

    public static String getMsg(Locale locale, String msgID) {
        String msg;
        try {
            msg = Msg.getResourceBundle(locale).getString(msgID);
        }
        catch (Throwable e2) {
            msg = "$" + msgID + "$";
        }
        return msg;
    }

    public static String getMsg(String msgID, Object ... msgParameter) {
        return Msg.getMsg(Locale.getDefault(), msgID, msgParameter);
    }

    public static String getMsg(Locale locale, String msgID, Object ... msgParameter) {
        ResourceBundle bundle = null;
        try {
            bundle = Msg.getResourceBundle(locale);
        }
        catch (Throwable e2) {
            // empty catch block
        }
        return Msg.getMsg(bundle, msgID, msgParameter);
    }

    private static String getMsg(ResourceBundle bundle, String msgID, Object ... msgParameter) {
        String msg;
        if (bundle != null) {
            msg = bundle.getString(msgID);
        } else {
            StringBuilder msgBuf = new StringBuilder();
            msgBuf.append(msgID);
            msgBuf.append('(');
            for (int i2 = 0; i2 < msgParameter.length; ++i2) {
                if (i2 > 0) {
                    msgBuf.append(',');
                }
                msgBuf.append('{');
                msgBuf.append(i2);
                msgBuf.append('}');
            }
            msgBuf.append(')');
            msg = "$" + MessageFormat.format(msgBuf.toString(), msgParameter) + "$";
        }
        try {
            msg = MessageFormat.format(msg, msgParameter);
        }
        catch (Throwable t2) {
            StringBuilder msgBuf = new StringBuilder();
            msgBuf.append('$').append(t2.toString()).append('_').append(msgID).append('(');
            for (int i3 = 0; i3 < msgParameter.length; ++i3) {
                if (i3 > 0) {
                    msgBuf.append(',');
                }
                msgBuf.append(msgParameter[i3]);
            }
            msgBuf.append(')').append('$');
            msg = msgBuf.toString();
        }
        return msg;
    }
}

