/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.viewer.PromptData;
import com.inet.viewer.RenderData;
import com.inet.viewer.ReportView;
import com.inet.viewer.ViewerContext;
import com.inet.viewer.ViewerUtils;
import java.applet.Applet;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Properties;

public class AppletViewerContext
implements ViewerContext {
    private final Applet o;
    private final ViewerContext p;

    AppletViewerContext(ViewerContext viewerContext, Applet applet) {
        this.p = viewerContext;
        this.o = applet;
    }

    public void export(ReportView reportView) {
        this.p.export(reportView);
    }

    public void print(ReportView reportView) {
        this.p.print(reportView);
    }

    public void showError(Throwable throwable, Object object) {
        this.p.showError(throwable, object);
    }

    public void showInfo() {
        this.p.showInfo();
    }

    public void showStatusMessage(ReportView reportView, String string, boolean bl2) {
        this.p.showStatusMessage(reportView, string, bl2);
    }

    public void showUrl(String string, Properties properties) throws MalformedURLException {
        try {
            if (ViewerUtils.useDesktopMethod("browse", new URI(string))) {
                return;
            }
        }
        catch (Throwable throwable) {
            ViewerUtils.debug("java.awt.Desktop not available. Attempting showDocument.");
        }
        if (properties == null || properties.size() == 0) {
            this.o.getAppletContext().showDocument(new URL(string), "_blank");
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string);
            stringBuffer.append('?');
            String string2 = (String)properties.remove("stacktrace");
            Enumeration<Object> enumeration = properties.keys();
            boolean bl2 = true;
            while (enumeration.hasMoreElements()) {
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuffer.append('&');
                }
                String string3 = (String)enumeration.nextElement();
                stringBuffer.append(string3);
                stringBuffer.append('=');
                try {
                    stringBuffer.append(URLEncoder.encode(properties.getProperty(string3), "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
            if (string2 != null) {
                stringBuffer.append("&stacktrace=");
                try {
                    stringBuffer.append(URLEncoder.encode(string2, "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            this.o.getAppletContext().showDocument(new URL(stringBuffer.toString()), "_blank");
        }
    }

    public ViewerContext getInnerContext() {
        return this.p;
    }

    public boolean showPrompts(PromptData[] promptDataArray, RenderData renderData) {
        return this.p.showPrompts(promptDataArray, renderData);
    }
}

