/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.viewer.Progress;
import com.inet.viewer.RenderData;
import com.inet.viewer.ReportView;
import com.inet.viewer.ViewerContext;
import com.inet.viewer.ViewerException;
import com.inet.viewer.ViewerUtils;
import com.inet.viewer.i18n.a;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportProgress
extends Progress {
    private RenderData aj;
    private final RenderData ak;
    private Properties al;
    private byte[] am;
    private int an;
    private int ao;
    private ArrayList<String> ap;

    public ExportProgress(ReportView reportView, RenderData renderData, Properties properties) {
        super(reportView, 2);
        this.setIndeterminate(true);
        this.setStatusMessage(null, false);
        this.ak = renderData;
        this.al = properties;
    }

    ExportProgress(Component component, ViewerContext viewerContext, RenderData renderData, Properties properties) {
        super(component, viewerContext, 2);
        this.setStatusMessage(null, false);
        this.ak = renderData;
        this.al = properties;
    }

    private void setStatusMessage(String string, boolean bl2) {
        ReportView reportView = this.getReportView();
        if (reportView != null) {
            reportView.getReportViewer().getViewerContext().showStatusMessage(reportView, string, bl2);
        }
    }

    @Override
    public final String getName() {
        return "Export Progress";
    }

    @Override
    public void cancel() {
        this.f().stop();
        this.setStatus(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.ap = new ArrayList();
        try {
            File file;
            RenderData renderData = this.f();
            String string = this.al.getProperty("export_fmt");
            int n2 = renderData.getExportChunkCount(this.al);
            this.setIndeterminate(false);
            if (n2 == 0) {
                n2 = Integer.MAX_VALUE;
            }
            this.setTotalProgress(n2);
            String string2 = this.al.getProperty("file");
            if (string.startsWith("htm")) {
                file = this.a(string, string2);
            } else if (string.startsWith("svg")) {
                file = this.a(string, string2);
            } else if (string.equals("jpg") || string.equals("gif") || string.equals("png") || string.equals("bmp")) {
                file = this.a(string2, n2);
            } else {
                byte[] byArray;
                file = new File(string2);
                this.ap.add(file.getPath());
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                for (int i2 = 1; i2 <= n2 && (byArray = renderData.getNextExportChunk()) != null; ++i2) {
                    fileOutputStream.write(byArray);
                    this.setProgress(i2);
                }
                fileOutputStream.close();
            }
            this.setStatusMessage(a.z("export.finished"), false);
            this.setStatus(2);
            if (this.al.getProperty("exportInApplication", "false").equals("true") && file != null) {
                this.a(file);
            }
        }
        catch (Throwable throwable) {
            ViewerUtils.printStackTrace(throwable);
            if (this.getStatus() == 3) {
                ViewerUtils.log("Export: Export canceled by user");
                this.setStatusMessage(a.z("export.canceled"), false);
            } else {
                this.showError(throwable);
                this.setStatusMessage(a.z("export.failed"), true);
                this.setStatus(4);
            }
        }
        finally {
            this.cleanUp();
        }
    }

    public ArrayList<String> getFileNames() {
        return this.ap;
    }

    private final void a(File file) {
        try {
            if (ViewerUtils.useDesktopMethod("open", file)) {
                return;
            }
            ViewerUtils.showDocumentOldMethod(file);
        }
        catch (Throwable throwable) {
            this.showError(new ViewerException(a.z("export.inApplicationFailed"), throwable));
        }
    }

    private int readInt(byte[] byArray, int n2) {
        return (byArray[n2 + 0] & 0xFF) + ((byArray[n2 + 1] & 0xFF) << 8) + ((byArray[n2 + 2] & 0xFF) << 16) + (byArray[n2 + 3] << 24);
    }

    private boolean a(int n2, boolean bl2) throws ViewerException {
        int n3 = this.ao - this.an;
        if (n3 < n2) {
            byte[] byArray = this.f().getNextExportChunk();
            this.setProgress(this.getProgress() + 1);
            if (byArray == null) {
                if (bl2) {
                    throw new ViewerException(a.z("error.export.unexpected_end"));
                }
                return false;
            }
            if (this.am == null) {
                this.am = byArray;
                this.an = 0;
                this.ao = byArray.length;
            } else {
                if (this.am.length - n3 < byArray.length) {
                    byte[] byArray2 = new byte[n3 + byArray.length];
                    System.arraycopy(this.am, this.an, byArray2, 0, n3);
                    this.am = byArray2;
                } else {
                    System.arraycopy(this.am, this.an, this.am, 0, n3);
                }
                this.an = 0;
                this.ao = n3;
                System.arraycopy(byArray, 0, this.am, this.ao, byArray.length);
                this.ao += byArray.length;
            }
        }
        return true;
    }

    private File a(String string, String string2) throws IOException {
        this.an = 0;
        File file = null;
        String string3 = "";
        boolean bl2 = false;
        boolean bl3 = false;
        while (this.ao > this.an || this.getTotalProgress() > this.getProgress()) {
            int n2;
            FileOutputStream fileOutputStream;
            String string4;
            this.a(4, true);
            int n3 = this.readInt(this.am, this.an);
            if (n3 == -1) break;
            if (n3 > 512) {
                throw new ViewerException(0, a.z("error.export.data_wrong"), string, null, null, null, 0, new String(this.am, 0, this.ao));
            }
            this.an += 4;
            this.a(n3, true);
            String string5 = new String(this.am, this.an, n3, "UTF8");
            if (!bl3) {
                string4 = this.al.getProperty("layout");
                if (string4 == null) {
                    if (!string2.substring(string2.lastIndexOf(46)).equals(string5.substring(string5.lastIndexOf(46)))) {
                        string5 = string5.substring(0, string5.lastIndexOf(46)) + string2.substring(string2.lastIndexOf(46));
                    }
                    string2 = string2.substring(0, string2.lastIndexOf(47) + 1) + string5;
                }
                file = new File(string2);
                file.getParentFile().mkdirs();
                this.ap.add(file.getPath());
                fileOutputStream = new FileOutputStream(file);
                string3 = string5.substring(0, string5.lastIndexOf(46));
                bl3 = true;
            } else {
                StringBuffer stringBuffer = new StringBuffer(string2.substring(0, string2.lastIndexOf(47) + 1));
                stringBuffer.append(string3);
                if (!bl2) {
                    this.b(stringBuffer.toString());
                    bl2 = true;
                }
                stringBuffer.append('/');
                stringBuffer.append(string5);
                string4 = stringBuffer.toString();
                this.ap.add(string4);
                fileOutputStream = new FileOutputStream(string4);
            }
            this.an += n3;
            this.a(4, true);
            this.an += 4;
            for (n3 = this.readInt(this.am, this.an); n3 > 0; n3 -= n2) {
                this.a(1, true);
                n2 = Math.min(this.ao - this.an, n3);
                fileOutputStream.write(this.am, this.an, n2);
                this.an += n2;
            }
            fileOutputStream.close();
        }
        return file;
    }

    private File a(String object, int n2) throws IOException {
        Object object2;
        RenderData renderData = this.f();
        byte[] byArray = renderData.getNextExportChunk();
        if (byArray.length > 2 && byArray[0] == 80 && byArray[1] == 75 && !((String)object).endsWith(".zip")) {
            object2 = (String)object + ".zip";
            if (new File((String)object2).exists()) {
                int n3 = 1;
                while (new File((String)(object2 = (String)object + "(" + n3++ + ").zip")).exists()) {
                }
            }
            object = object2;
        }
        object2 = new File((String)object);
        this.ap.add(((File)object2).getPath());
        FileOutputStream fileOutputStream = new FileOutputStream((File)object2);
        for (int i2 = 1; i2 <= n2 && byArray != null; ++i2) {
            ((OutputStream)fileOutputStream).write(byArray);
            this.setProgress(1);
            if (i2 >= n2) break;
            byArray = renderData.getNextExportChunk();
        }
        ((OutputStream)fileOutputStream).close();
        return object2;
    }

    private void b(String string) {
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        } else if (!file.isDirectory()) {
            if (!file.delete()) {
                throw new RuntimeException("\n" + a.z("error.export.cannot_delete") + " " + string);
            }
            file.mkdirs();
        }
    }

    private synchronized RenderData f() {
        if (this.aj == null) {
            this.aj = this.ak.getCopy();
        }
        return this.aj;
    }
}

