/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.viewer.ReportView;
import com.inet.viewer.ViewerContext;
import com.inet.viewer.ViewerException;
import com.inet.viewer.ViewerUtils;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public abstract class Progress
implements Runnable {
    public static final int TYPE_PAGELOADER = 0;
    public static final int TYPE_PRINT = 1;
    public static final int TYPE_EXPORT = 2;
    public static final int TYPE_SEARCH = 3;
    public static final int TYPE_INVISIBLE = 4;
    public static final int STATUS_NOT_INITIALIZED = -1;
    public static final int STATUS_INITIALIZED = 0;
    public static final int STATUS_RUNNING = 1;
    public static final int STATUS_COMPLETED = 2;
    public static final int STATUS_CANCELED = 3;
    public static final int STATUS_ERROR = 4;
    public static final int STATUS_IDLE = 5;
    public static final String PROP_PROGRESS_STATUS = "ProgressStatus";
    public static final String PROP_PROGRESS_TOTAL = "ProgressTotal";
    public static final String PROP_PROGRESS_STEP = "ProgressStep";
    public static final String PROP_PROGRESS_INDETERMINATE = "ProgressIndeterminate";
    private int status = -1;
    protected final PropertyChangeSupport propertySupporter = new PropertyChangeSupport(this);
    private int type;
    private int dr;
    private int ds;
    private boolean dt = false;
    private String du;
    private ReportView dv;
    private ViewerContext p;
    private Component bO;
    Thread dw;

    public Progress(ReportView reportView, int n2) {
        this.type = n2;
        this.dv = reportView;
        if (reportView != null) {
            reportView.getReportViewer().getProgressPool().a(this);
            this.bO = reportView.getComponent();
            this.p = reportView.getReportViewer().getViewerContext();
        }
        this.setStatus(0);
    }

    public Progress(Component component, ViewerContext viewerContext, int n2) {
        this.type = n2;
        this.p = viewerContext;
        this.bO = component;
        this.setStatus(0);
    }

    public final void startProgress() {
        if (this.dw != null && this.dw.isAlive()) {
            throw new ViewerException("Progress '" + this.getName() + "' is already running");
        }
        this.dw = new Thread((Runnable)this, this.getName());
        this.dw.setPriority(5);
        this.setStatus(1);
        this.setErrorMessage(null);
        if (this.dt) {
            this.dw.setDaemon(true);
            this.setTotalProgress(1);
        }
        this.dw.start();
    }

    public abstract String getName();

    public abstract void cancel();

    public int getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilFinished() {
        try {
            Progress progress = this;
            synchronized (progress) {
                while (!this.isFinished()) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isIndeterminate() {
        return this.dt;
    }

    public void setIndeterminate(boolean bl2) {
        boolean bl3 = this.dt;
        this.dt = bl2;
        this.propertySupporter.firePropertyChange(PROP_PROGRESS_INDETERMINATE, bl3, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(int n2) {
        int n3 = this.status;
        this.status = n2;
        this.propertySupporter.firePropertyChange(PROP_PROGRESS_STATUS, n3, this.status);
        Progress progress = this;
        synchronized (progress) {
            this.notifyAll();
        }
    }

    public boolean isFinished() {
        boolean bl2 = this.status == 3 || this.status == 2 || this.status == 4;
        return bl2;
    }

    public boolean isCanceled() {
        return this.status == 3;
    }

    public boolean isErrored() {
        return this.status == 4;
    }

    public void setTotalProgress(int n2) {
        int n3 = this.dr;
        this.dr = n2;
        if (n2 == 0) {
            this.setStatus(5);
        } else if (this.getStatus() == 5) {
            this.setStatus(1);
        }
        this.propertySupporter.firePropertyChange(PROP_PROGRESS_TOTAL, n3, n2);
    }

    public int getTotalProgress() {
        return this.dr;
    }

    public void setProgress(int n2) {
        int n3 = this.ds;
        this.ds = n2;
        this.propertySupporter.firePropertyChange(PROP_PROGRESS_STEP, n3, this.ds);
    }

    public int getProgress() {
        return this.ds;
    }

    public ReportView getReportView() {
        return this.dv;
    }

    public int getStatus() {
        return this.status;
    }

    public String getErrorMessage() {
        return this.du;
    }

    public void setErrorMessage(String string) {
        this.du = string;
    }

    public void showError(Throwable throwable) {
        this.setErrorMessage(throwable.getMessage());
        this.setStatus(4);
        if (this.p == null) {
            ViewerUtils.printStackTrace(throwable);
        } else {
            this.p.showError(throwable, this.bO);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupporter.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupporter.removePropertyChangeListener(propertyChangeListener);
    }

    protected void cleanUp() {
        PropertyChangeListener[] propertyChangeListenerArray = this.propertySupporter.getPropertyChangeListeners();
        for (int i2 = 0; i2 < propertyChangeListenerArray.length; ++i2) {
            this.propertySupporter.removePropertyChangeListener(propertyChangeListenerArray[i2]);
        }
    }
}

