/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.viewer.FallbackFormatter;
import com.inet.viewer.PromptValue;
import com.inet.viewer.ch;
import com.inet.viewer.i18n.a;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;

public class RealtimeValidationPopup
implements ActionListener,
FocusListener,
DocumentListener,
PopupMenuListener {
    private JComponent dR;
    private int dG;
    private boolean dS;
    private Timer timer;
    private Popup dT;
    private JLabel dU;
    private JPanel dV;
    private boolean dW;
    private Point dX;
    private JComboBox dY;
    private boolean dZ;
    private boolean ea;
    private Class eb;
    private Constructor ec;
    private Class[] ed = new Class[]{String.class};
    private Color ee;
    public static final Color POPUP_BGCOLOR_NORMAL = new Color(255, 255, 225);
    public static final Color POPUP_BGCOLOR_ERROR = new Color(1.0f, 0.7f, 0.7f);
    public static final Color POPUP_BGCOLOR_INCOMPLETE = new Color(255, 227, 119);
    public static final Color LAYOUT_ERROR_BACKGROUND = new Color(1.0f, 0.7f, 0.7f);
    private Format ef;

    private RealtimeValidationPopup(int n2) {
        this.dG = n2;
        this.dU = new JLabel();
        this.dV = new JPanel();
        this.dV.setOpaque(true);
        this.dV.add(this.dU);
        this.dV.addMouseListener(new ch(this));
        this.dV.setBorder(BorderFactory.createBevelBorder(0, Color.GRAY, Color.BLACK));
        this.timer = new Timer(5000, this);
    }

    public RealtimeValidationPopup(JTextComponent jTextComponent, JComboBox jComboBox, int n2, boolean bl2) {
        this(n2);
        this.as();
        if (this.ef == null) {
            return;
        }
        this.dZ = bl2;
        jTextComponent.getDocument().addDocumentListener(this);
        if (jComboBox != null) {
            jComboBox.addActionListener(this);
            jComboBox.addPopupMenuListener(this);
            this.dY = jComboBox;
        }
        this.dR = jTextComponent;
        this.dR.addFocusListener(this);
        this.ee = this.dR.getBackground();
    }

    private void as() {
        this.ef = null;
        switch (this.dG % 128) {
            case 6: 
            case 7: {
                this.ef = this.dZ ? NumberFormat.getInstance(Locale.US) : PromptValue.NUMBERFORMAT;
                break;
            }
            case 9: {
                this.ef = this.dZ ? DateFormat.getDateInstance(3, Locale.US) : PromptValue.DATEFORMAT;
                break;
            }
            case 15: {
                this.ef = this.dZ ? DateFormat.getDateTimeInstance(3, 2, Locale.US) : PromptValue.DATETIMEFORMAT;
                break;
            }
            case 10: {
                this.ef = this.dZ ? DateFormat.getTimeInstance(2, Locale.US) : PromptValue.TIMEFORMAT;
                break;
            }
            default: {
                return;
            }
        }
    }

    private void aE() {
        if (this.dR instanceof JPasswordField) {
            return;
        }
        Object object = this.getValue();
        String string = object.toString();
        if (!this.dR.isEnabled() || !this.dR.isShowing() || object.toString().length() == 0 || this.dR instanceof JComboBox && ((JComboBox)this.dR).isPopupVisible() || (this.dG % 128 == 6 || this.dG % 128 == 7) && string.equals("-")) {
            if (!this.dR.isEnabled()) {
                this.dR.setBackground(UIManager.getDefaults().getColor("TextField.disabledBackground"));
            } else {
                this.dR.setBackground(POPUP_BGCOLOR_NORMAL);
            }
            this.hidePopup();
            return;
        }
        try {
            Object object2;
            if (object instanceof PromptValue) {
                if (((PromptValue)object).isOnlyDescription()) {
                    this.hidePopup();
                    return;
                }
                object2 = ((PromptValue)object).getDescription();
                if (object2 != null && ((String)object2).length() > 0) {
                    string = ((PromptValue)object).getValueString();
                }
            }
            object2 = null;
            object2 = this.ef.parseObject(string);
            String string2 = this.getFormatedText(object2);
            if (this.ea && this.eb != null) {
                if (this.eb == Object.class) {
                    this.eb = String.class;
                }
                this.ec = this.eb.getConstructor(this.ed);
                this.ec.newInstance(string);
            }
            this.dS = false;
            if (string2.equals(string)) {
                this.hidePopup();
            } else {
                Point point = this.dR.getLocationOnScreen();
                point.y += this.dR.getHeight();
                this.a(string2, POPUP_BGCOLOR_NORMAL, point);
            }
            this.dR.invalidate();
            this.dR.setBackground(POPUP_BGCOLOR_NORMAL);
        }
        catch (Exception exception) {
            if (this.a(this.ef, string)) {
                this.showIncompletePopup();
            }
            this.showErrorPopup();
        }
    }

    public String getFormatedText(Object object) {
        return this.ef.format(object);
    }

    private boolean a(Format format, String string) {
        boolean bl2 = false;
        if (format instanceof FallbackFormatter) {
            format = ((FallbackFormatter)format).getPrimaryFormat();
        }
        if (format instanceof SimpleDateFormat) {
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)format;
            String string2 = simpleDateFormat.toPattern();
            SimpleDateFormat simpleDateFormat2 = null;
            String string3 = string2;
            block2: for (int i2 = 1; i2 <= string2.length(); ++i2) {
                for (int i3 = 0; i3 <= string2.length() - i2; ++i3) {
                    string3 = string2.substring(i3, i3 + i2);
                    simpleDateFormat2 = new SimpleDateFormat(string3);
                    try {
                        Date date = simpleDateFormat2.parse(string);
                        String string4 = simpleDateFormat2.format(date);
                        String string5 = string.replaceAll("0", "");
                        String string6 = string4.replaceAll("0", "");
                        if (!string.equals(string4) && !string5.equals(string4) && !string.equals(string6) && !string5.equals(string6)) continue;
                        bl2 = true;
                        continue block2;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return bl2;
    }

    public void showErrorPopup() {
        Point point = this.dR.getLocationOnScreen();
        point.y += this.dR.getHeight();
        this.dS = true;
        String string = a.z("prompt.invalid_input");
        string = string + this.aF();
        this.a(string, POPUP_BGCOLOR_ERROR, point);
        this.dR.setBackground(LAYOUT_ERROR_BACKGROUND);
        this.dR.invalidate();
    }

    public void showIncompletePopup() {
        Point point = this.dR.getLocationOnScreen();
        point.y += this.dR.getHeight();
        this.dS = true;
        String string = a.z("prompt.incomplete_input");
        string = string + this.aF();
        this.a(string, POPUP_BGCOLOR_INCOMPLETE, point);
        this.dR.setBackground(POPUP_BGCOLOR_INCOMPLETE);
        this.dR.invalidate();
    }

    private String aF() {
        FallbackFormatter fallbackFormatter;
        switch (this.dG) {
            case 9: {
                fallbackFormatter = PromptValue.DATEFORMAT;
                break;
            }
            case 15: {
                fallbackFormatter = PromptValue.DATETIMEFORMAT;
                break;
            }
            case 10: {
                fallbackFormatter = PromptValue.TIMEFORMAT;
                break;
            }
            default: {
                fallbackFormatter = null;
            }
        }
        if (fallbackFormatter instanceof SimpleDateFormat) {
            return a.a("prompt.format_must_be", ((SimpleDateFormat)((Object)fallbackFormatter)).toPattern());
        }
        if (this.dG == 6 || this.dG == 7) {
            return a.z("prompt.expected_number");
        }
        return "";
    }

    private void a(String string, Color color, Point point) {
        string = this.j(string);
        this.dU.setText(string);
        this.dV.setBackground(color);
        if (!this.dW) {
            this.dX = point;
        } else {
            point = this.dX;
        }
        if (this.dT != null) {
            this.hidePopup();
        }
        this.dT = PopupFactory.getSharedInstance().getPopup(this.dR, this.dV, point.x, point.y);
        this.dT.show();
        this.dW = true;
        if (this.timer.isRunning()) {
            this.timer.restart();
        } else {
            this.timer.start();
        }
    }

    private String j(String string) {
        string = this.dS ? "<html>" + string + "</html>" : a.a("prompt.interpreted_as", string);
        return string;
    }

    private Object getValue() {
        if (this.dR instanceof JPasswordField) {
            return new String(((JPasswordField)this.dR).getPassword());
        }
        if (this.dR instanceof JTextComponent) {
            String string;
            String string2 = ((JTextComponent)this.dR).getText();
            if (this.dY == null) {
                return string2;
            }
            Object object = this.dY.getSelectedItem();
            if (this.dR != null && this.dY.isEditable() && object != null && !(string = object.toString()).equals(string2)) {
                return string2;
            }
            if (object == null) {
                object = "";
            }
            return object;
        }
        if (this.dR instanceof JComboBox) {
            return ((JComboBox)this.dR).getSelectedItem();
        }
        return null;
    }

    public void hidePopup() {
        if (this.dT != null) {
            this.dT.hide();
        }
        this.dW = false;
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
    }

    public void setCheckClassType(boolean bl2, Class clazz) {
        this.ea = bl2;
        this.eb = clazz;
    }

    public void setPromptType(int n2) {
        this.dG = n2;
        this.as();
    }

    public void unregister() {
        if (this.dR == null) {
            return;
        }
        if (this.dR instanceof JTextField) {
            ((JTextField)this.dR).getDocument().removeDocumentListener(this);
        } else if (this.dR instanceof JComboBox) {
            ((JComboBox)this.dR).removeActionListener(this);
            ((JComboBox)this.dR).removePopupMenuListener(this);
        }
        this.dR.removeFocusListener(this);
        if (this.dY != null) {
            this.dY.removeActionListener(this);
            this.dY.removePopupMenuListener(this);
        }
        this.dR.setBackground(this.ee);
    }

    public boolean isPopupError() {
        return this.dS;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.aE();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.aE();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.aE();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JComboBox) {
            this.aE();
        } else {
            this.hidePopup();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.aE();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.hidePopup();
    }

    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        this.hidePopup();
    }

    public void setFormat(Format format) {
        this.ef = format;
    }
}

