/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.viewer.ExportProgress;
import com.inet.viewer.Progress;
import com.inet.viewer.PromptData;
import com.inet.viewer.RenderData;
import com.inet.viewer.ReportView;
import com.inet.viewer.SwingPromptDialog;
import com.inet.viewer.SwingReportView;
import com.inet.viewer.SwingReportViewer;
import com.inet.viewer.SwingViewerUtils;
import com.inet.viewer.ViewerContext;
import com.inet.viewer.ViewerUtils;
import com.inet.viewer.ac;
import com.inet.viewer.ah;
import com.inet.viewer.eg;
import com.inet.viewer.exportdlg.e;
import com.inet.viewer.hc;
import com.inet.viewer.hd;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.beans.PropertyChangeListener;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.SwingUtilities;

public class SwingViewerContext
implements ViewerContext {
    private ac mb;
    private SwingReportViewer cc;

    @Deprecated
    public SwingViewerContext() {
        this.setViewer(null);
    }

    public SwingViewerContext(SwingReportViewer swingReportViewer) {
        this.setViewer(swingReportViewer);
    }

    public void showInfo() {
        Window window = SwingViewerUtils.getParentWindow(this.getViewer());
        ah ah2 = window instanceof Frame ? new ah((Frame)window) : new ah((Dialog)window);
        SwingUtilities.invokeLater(new hc(this, ah2));
    }

    public void showError(Throwable throwable, Object object) {
        SwingReportView swingReportView;
        if (this.getViewer() == null) {
            ViewerUtils.error("can not show error dialog because ViewerContext does not have a reference to the viewer! When creating a SwingViewerContext, you should pass in the Report Viewer in the constructor!");
            ViewerUtils.printStackTrace(throwable);
            return;
        }
        if (!this.getViewer().isVisible()) {
            ViewerUtils.printStackTrace(throwable);
            return;
        }
        if (object instanceof SwingReportView && ((eg)(swingReportView = (SwingReportView)object).cB()).ch()) {
            return;
        }
        SwingUtilities.invokeLater(new hd(this, throwable));
    }

    public void export(ReportView reportView) {
        reportView.export();
    }

    public Progress export(Component component, RenderData renderData, PropertyChangeListener propertyChangeListener) {
        e e2 = new e((Frame)component, (ViewerContext)this, null, null, new Properties(), Integer.MAX_VALUE);
        e2.setVisible(true);
        if (e2.getStatus() == 200) {
            return null;
        }
        Properties properties = e2.dP();
        String string = ((String)properties.get("export_fmt")).toLowerCase();
        if (string.equals("data")) {
            string = "csv";
        } else if (string.startsWith("ps")) {
            string = "ps";
        }
        properties.put("export_fmt", string);
        ExportProgress exportProgress = new ExportProgress(null, this, renderData, properties);
        if (propertyChangeListener != null) {
            exportProgress.addPropertyChangeListener(propertyChangeListener);
        }
        exportProgress.startProgress();
        return exportProgress;
    }

    public Progress export(Component component, RenderData renderData) {
        return this.export(component, renderData, null);
    }

    public void print(ReportView reportView) {
        reportView.print(1, -1, true);
    }

    public void showStatusMessage(ReportView reportView, String string, boolean bl2) {
        reportView.getStatusBar().setStatusMessage(string, bl2);
    }

    public void showUrl(String string, Properties properties) throws MalformedURLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        if (properties != null && properties.size() > 0) {
            String string2 = (String)properties.remove("stacktrace");
            stringBuffer.append('?');
            Enumeration<Object> enumeration = properties.keys();
            this.a(stringBuffer, properties, enumeration);
            while (enumeration.hasMoreElements()) {
                stringBuffer.append('&');
                this.a(stringBuffer, properties, enumeration);
            }
            if (string2 != null) {
                stringBuffer.append("&stacktrace=");
                try {
                    stringBuffer.append(URLEncoder.encode(string2, "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
        this.a(new URL(stringBuffer.toString()));
    }

    private void a(StringBuffer stringBuffer, Properties properties, Enumeration enumeration) {
        String string = (String)enumeration.nextElement();
        String string2 = null;
        try {
            string2 = URLEncoder.encode(properties.getProperty(string), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        stringBuffer.append(string);
        stringBuffer.append('=');
        stringBuffer.append(string2);
    }

    private void a(URL uRL) {
        try {
            if (ViewerUtils.useDesktopMethod("browse", new URI(uRL.toString()))) {
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            ViewerUtils.showDocumentOldMethod(uRL);
            return;
        }
        catch (Throwable throwable) {
            if (this.mb == null) {
                this.mb = new ac();
            }
            this.mb.a(uRL);
            return;
        }
    }

    public void setViewer(SwingReportViewer swingReportViewer) {
        this.cc = swingReportViewer;
    }

    public SwingReportViewer getViewer() {
        return this.cc;
    }

    public boolean showPrompts(PromptData[] promptDataArray, RenderData renderData) {
        SwingPromptDialog swingPromptDialog = new SwingPromptDialog();
        swingPromptDialog.execute(this.getViewer(), this.getViewer(), promptDataArray, renderData);
        return !swingPromptDialog.wasCanceled();
    }
}

