/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.viewer.Loader;
import com.inet.viewer.RenderData;
import com.inet.viewer.ViewerException;
import com.inet.viewer.ViewerUtils;
import com.inet.viewer.bw;
import com.inet.viewer.cb;
import com.inet.viewer.client.InetCookieHandler;
import java.awt.EventQueue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.CookieHandler;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.WeakHashMap;
import java.util.zip.Adler32;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class URLRenderData
implements RenderData {
    private static final String mm = com.inet.viewer.i18n.a.z("error.renderdata.ignoring_timeout");
    private final Properties mn = new Properties();
    private Properties al;
    private boolean mo;
    private String title;
    private String bb;
    private long mp = System.currentTimeMillis() / 1000L;
    private String mq = TimeZone.getDefault().getID();
    private boolean mr;
    private boolean ms;
    private a mt;
    private boolean mu;
    private String mv;
    private SSLSocketFactory mw;
    private HostnameVerifier hostnameVerifier;
    private WeakHashMap mx = new WeakHashMap();
    private static final Hashtable my = new Hashtable();

    public URLRenderData(String string) {
        this.setReportLocation(string);
    }

    public URLRenderData(URL uRL) {
        this.setReportLocation(uRL.toString());
    }

    public void setReportLocation(String string) {
        if (string == null) {
            return;
        }
        int n2 = string.indexOf(63);
        if (n2 >= 0) {
            String string2 = string.substring(n2 + 1);
            string = string.substring(0, n2 + 1);
            this.q(string2);
        } else {
            string = string + "?";
        }
        this.bb = string;
        this.reset();
    }

    private void q(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&=", true);
        boolean bl2 = true;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
            if (string4.equals("&")) {
                this.c(string2, string3);
                string2 = "";
                string3 = "";
                bl2 = true;
                continue;
            }
            if (string4.equals("=")) {
                bl2 = false;
                continue;
            }
            if (bl2) {
                string2 = string4;
                continue;
            }
            string3 = string4;
        }
        this.c(string2, string3);
    }

    private void c(String string, String string2) {
        try {
            String string3;
            String string4;
            if ("promptonrefresh".equalsIgnoreCase(string)) {
                if ("true".equalsIgnoreCase(string2)) {
                    this.setPromptOnRefresh(true);
                } else if ("false".equalsIgnoreCase(string2)) {
                    this.setPromptOnRefresh(false);
                }
                return;
            }
            try {
                string4 = URLDecoder.decode(string, "UTF-8").toLowerCase();
                string4 = this.r(string4);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ViewerUtils.debug("Error: " + string + " could not be decoded. Reason: ");
                illegalArgumentException.printStackTrace(ViewerUtils.getLogStream());
                string4 = string;
            }
            try {
                string3 = URLDecoder.decode(string2, "UTF-8");
                string3 = this.r(string3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ViewerUtils.debug("Error: " + string2 + " could not be decoded. Reason: ");
                illegalArgumentException.printStackTrace(ViewerUtils.getLogStream());
                string3 = string2;
            }
            this.mn.put(string4, string3);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ViewerUtils.error(unsupportedEncodingException.toString());
            this.mn.put(string, string2);
        }
    }

    private String r(String string) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder(string);
        int n3 = 0;
        while ((n3 = stringBuilder.indexOf("&#", n3)) >= 0 && (n2 = stringBuilder.indexOf(";", n3)) >= 0) {
            try {
                char c2 = (char)Integer.parseInt(stringBuilder.substring(n3 + 2, n2));
                stringBuilder.delete(n3, n2 + 1);
                stringBuilder.insert(n3, c2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n3;
        }
        return stringBuilder.toString();
    }

    public String getReportLocation() {
        return this.bb;
    }

    private String a(Properties properties) {
        StringBuilder stringBuilder = new StringBuilder();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string, "");
            stringBuilder.append(string);
            stringBuilder.append('=');
            stringBuilder.append(string2);
            if (!enumeration.hasMoreElements()) continue;
            stringBuilder.append('&');
        }
        return stringBuilder.toString();
    }

    private void a(Properties properties, URLConnection uRLConnection) throws IOException {
        uRLConnection.setDoOutput(true);
        uRLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        PrintWriter printWriter = new PrintWriter(uRLConnection.getOutputStream());
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string, "");
            printWriter.print(string + "=" + string2 + "&");
        }
        printWriter.close();
    }

    void a(a a2, Properties properties, String string, boolean bl2) throws IOException, ViewerException {
        int n2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        HttpURLConnection httpURLConnection;
        Object object5;
        boolean bl3 = false;
        Object object6 = this.bb;
        boolean bl4 = bl2 = bl2 || this.mu;
        if (bl2) {
            object5 = this.b(properties);
            if (object5 != null) {
                object6 = object5;
            } else {
                bl3 = true;
            }
        }
        if ((httpURLConnection = (HttpURLConnection)((URL)(object5 = new URL((String)object6))).openConnection()) instanceof HttpsURLConnection) {
            object4 = (HttpsURLConnection)httpURLConnection;
            if (this.mw != null) {
                ((HttpsURLConnection)object4).setSSLSocketFactory(this.mw);
            }
            if (this.hostnameVerifier != null) {
                ((HttpsURLConnection)object4).setHostnameVerifier(this.hostnameVerifier);
            }
        }
        if (this.mv != null) {
            httpURLConnection.setRequestProperty("Cookie", this.mv);
        }
        httpURLConnection.setRequestProperty("Accept-Encoding", "gzip, identity");
        this.mx.put(httpURLConnection, null);
        if (!bl2 || bl3) {
            this.a(properties, httpURLConnection);
        }
        httpURLConnection.connect();
        a2.mB = httpURLConnection;
        a2.mz = httpURLConnection.getInputStream();
        this.dc();
        object4 = httpURLConnection.getHeaderField("Set-Cookie");
        if (object4 != null) {
            object3 = CookieHandler.getDefault();
            if (object3 == null) {
                try {
                    object3 = (CookieHandler)Class.forName("java.net.CookieManager").newInstance();
                }
                catch (Throwable throwable) {
                    object3 = new InetCookieHandler();
                }
                CookieHandler.setDefault((CookieHandler)object3);
            }
            try {
                ((CookieHandler)object3).put(httpURLConnection.getURL().toURI(), httpURLConnection.getHeaderFields());
                Map<String, List<String>> map = ((CookieHandler)object3).get(httpURLConnection.getURL().toURI(), httpURLConnection.getHeaderFields());
                if (map.containsKey("Cookie") && (object2 = map.get("Cookie")) != null && object2.size() > 0 && (object = (String)object2.get(0)) != null && ((String)object).length() > 0) {
                    this.setCookie((String)object);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                ViewerUtils.printStackTrace(uRISyntaxException);
            }
        }
        a2.mA = httpURLConnection.getContentLength();
        object3 = httpURLConnection.getContentType();
        if (object3 == null) {
            throw new ViewerException(com.inet.viewer.i18n.a.z("error.renderdata.contentType_returns_null") + " " + httpURLConnection.getContentLength());
        }
        if ("gzip".equals(httpURLConnection.getContentEncoding())) {
            a2.mz = new GZIPInputStream(a2.mz, 8192);
            a2.mA = -1;
        }
        if ((n2 = ((String)object3).indexOf(59)) != -1) {
            object3 = ((String)object3).substring(0, n2);
        }
        if ((object2 = (String)my.get(object3)) == null || !this.d(string, (String)object2)) {
            if ("bin".equals(object2)) {
                object = new Loader();
                ((Loader)object).data = this.a(a2);
                ((Loader)object).readTokens();
            }
            this.dc();
            object = null;
            try {
                byte[] byArray = new byte[1024];
                int n3 = a2.mz.read(byArray);
                a2.mz.close();
                object = n3 > 0 ? Loader.a(byArray, 0, n3) : "no data";
            }
            catch (Throwable throwable) {
                ViewerUtils.printStackTrace(throwable);
            }
            throw new ViewerException(0, com.inet.viewer.i18n.a.z("error.renderdata.wrong_mime_type") + " " + (String)object3, string, null, null, null, 0, (String)object);
        }
    }

    String b(Properties properties) {
        String string = this.bb;
        String string2 = this.a(properties);
        if (!string.endsWith("?")) {
            string = string + "&";
        }
        if ((string = string + string2).length() > 1023 && !this.mu) {
            return null;
        }
        return string;
    }

    private boolean d(String string, String string2) {
        if (string.equalsIgnoreCase("data")) {
            string = "csv";
        } else if ("zip".equals(string2) && ("jpg".equals(string) || "png".equals(string) || "gif".equals(string) || "bmp".equals(string))) {
            return true;
        }
        return string.toLowerCase().startsWith(string2);
    }

    private byte[] a(Properties properties, String string) throws ViewerException {
        return this.a(properties, string, true);
    }

    private byte[] a(Properties properties, String string, boolean bl2) throws ViewerException {
        if (EventQueue.isDispatchThread()) {
            ViewerUtils.debug("contacting server on EDT...");
            ViewerUtils.printStackTrace(new ViewerException("debug info"));
        }
        while (bl2) {
            Object object;
            a a2 = new a();
            try {
                Object object2;
                boolean bl3 = true;
                try {
                    this.a(a2, properties, string, false);
                    bl3 = false;
                }
                catch (ViewerException viewerException) {
                    if (this.mu || viewerException.mH != null && viewerException.mH.length() > 0 || this.ms) {
                        throw viewerException;
                    }
                    ViewerUtils.debug("Encountered: " + viewerException.getMessage() + " while trying POST request.");
                }
                catch (IOException iOException) {
                    if (a2.mB instanceof HttpURLConnection) {
                        InputStream inputStream;
                        object2 = (HttpURLConnection)a2.mB;
                        int n2 = ((HttpURLConnection)object2).getResponseCode();
                        if (n2 == 401) {
                            throw iOException;
                        }
                        if (n2 >= 300 && n2 <= 399) {
                            ViewerUtils.debug("encountered HTTP " + n2 + " --> " + ((URLConnection)object2).getHeaderField("Location"));
                        }
                        if ((inputStream = ((HttpURLConnection)object2).getErrorStream()) != null) {
                            String string2 = ((URLConnection)object2).getContentType();
                            if ("gzip".equals(((URLConnection)object2).getContentEncoding())) {
                                inputStream = new GZIPInputStream(inputStream, 8192);
                            }
                            ViewerUtils.debug(this.a(this.a(inputStream), string2));
                        }
                    }
                    if (this.mu || this.ms) {
                        throw iOException;
                    }
                    ViewerUtils.debug("Encountered: " + iOException.getMessage() + " while trying POST request.");
                }
                if (!bl3) {
                    object = this.a(a2);
                    object2 = properties.get("cmd").toString();
                    if (object2 != null && (((String)object2).equals("get_pg_count") || ((String)object2).equals("ping")) || this.f((byte[])object) || this.mu) {
                        return object;
                    }
                    ViewerUtils.debug("Encountered Checksum Problem!");
                }
                ViewerUtils.debug(" => Fallback to HTTP GET Request instead of POST");
                this.a(a2, properties, string, true);
                return this.a(a2);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                this.dc();
                ViewerUtils.debug(mm);
            }
            catch (IOException iOException) {
                ViewerUtils.error("Problem when attemping to connect via GET with URL '" + this.bb + "'");
                this.dc();
                try {
                    if (a2.mB instanceof HttpURLConnection) {
                        Object object3;
                        object = (HttpURLConnection)a2.mB;
                        if (((HttpURLConnection)object).getResponseCode() == 504) {
                            ViewerUtils.debug(mm);
                            continue;
                        }
                        InputStream inputStream = ((HttpURLConnection)object).getErrorStream();
                        String string3 = ((URLConnection)object).getContentType();
                        if ("gzip".equals(((URLConnection)object).getContentEncoding())) {
                            inputStream = new GZIPInputStream(inputStream, 8192);
                        }
                        ByteArrayOutputStream byteArrayOutputStream = this.a(inputStream);
                        String string4 = (String)my.get(string3);
                        if ("bin".equals(string4)) {
                            try {
                                object3 = new Loader();
                                ((Loader)object3).data = byteArrayOutputStream.toByteArray();
                                ((Loader)object3).readTokens();
                            }
                            catch (ViewerException viewerException) {
                                throw viewerException;
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        object3 = this.a(byteArrayOutputStream, string3);
                        ViewerUtils.debug((String)object3);
                        if (((String)object3).startsWith("<html>")) {
                            throw ViewerException.createViewerExceptionWithMessage((String)object3, iOException);
                        }
                        ViewerException viewerException = ViewerException.createViewerException(iOException);
                        if (((String)object3).length() > 5) {
                            viewerException.mL = object3;
                        }
                        throw viewerException;
                    }
                    if (a2.mz != null) {
                        a2.mz.close();
                    }
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                throw ViewerException.createViewerException(iOException);
            }
            catch (Exception exception) {
                try {
                    a2.mz.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                this.dc();
                throw ViewerException.createViewerException(exception);
            }
        }
        return null;
    }

    private ByteArrayOutputStream a(InputStream inputStream) throws IOException {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        while ((n2 = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        return byteArrayOutputStream;
    }

    private String a(ByteArrayOutputStream byteArrayOutputStream, String string) {
        String string2;
        if (string != null) {
            int n2 = string.indexOf("charset=");
            if (n2 > 0) {
                char c2;
                char c3;
                string2 = string.substring(n2 + "charset=".length());
                int n3 = string2.length();
                if (n3 > 2 && (c3 = string2.charAt(0)) == (c2 = string2.charAt(n3 - 1)) && (c3 == '\'' || c3 == '\"')) {
                    string2 = string2.substring(1, n3 - 1);
                }
            } else {
                string2 = "utf8";
            }
        } else {
            string2 = "utf8";
        }
        try {
            return byteArrayOutputStream.toString(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return byteArrayOutputStream.toString();
        }
    }

    private boolean f(byte[] byArray) {
        int n2 = byArray.length - 4;
        if (n2 < 0) {
            return false;
        }
        int n3 = (byArray[n2++] << 24) + ((byArray[n2++] & 0xFF) << 16) + ((byArray[n2++] & 0xFF) << 8) + (byArray[n2++] & 0xFF);
        Adler32 adler32 = new Adler32();
        adler32.update(byArray, 0, byArray.length - 4);
        int n4 = (int)adler32.getValue();
        return n4 == n3;
    }

    void reset() {
        this.mt = null;
    }

    private byte[] a(a a2) throws IOException {
        return this.a(a2, a2.mA, true);
    }

    private byte[] a(a a2, int n2, boolean bl2) throws IOException {
        this.dc();
        if (n2 > 0) {
            byte[] byArray = new byte[n2];
            int n3 = 0;
            while (n2 > 0) {
                int n4 = a2.mz.read(byArray, n3, n2);
                if (n4 < 0) {
                    if (bl2) {
                        throw new ViewerException(com.inet.viewer.i18n.a.z("error.renderdata.wrong_packet_size_received") + " " + n3 + " " + com.inet.viewer.i18n.a.z("error.renderdata.bytes_expected") + " " + (n2 + n3));
                    }
                    if (n3 > 0) {
                        byte[] byArray2 = new byte[n3];
                        System.arraycopy(byArray, 0, byArray2, 0, n3);
                        return byArray2;
                    }
                    return null;
                }
                n2 -= n4;
                n3 += n4;
            }
            return byArray;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        int n5;
        while ((n5 = a2.mz.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n5);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getPageData(int n2) throws ViewerException {
        if (n2 < 1) {
            throw new ViewerException("Page out of allowed range: " + n2);
        }
        byte[] byArray = this.a(this.c("get_pg", n2), "bin");
        Loader loader = new Loader();
        loader.data = byArray;
        loader.readTokens();
        return byArray;
    }

    public byte[] refreshPageData(int n2) throws ViewerException {
        this.mr = true;
        this.ms = false;
        return this.a(this.c("rfsh", n2), "bin");
    }

    public int getPageCount() throws ViewerException {
        byte[] byArray = this.a(this.dg(), "bin");
        if (byArray.length == 4) {
            return (byArray[0] << 24) + ((byArray[1] & 0xFF) << 16) + ((byArray[2] & 0xFF) << 8) + (byArray[3] & 0xFF);
        }
        Loader loader = new Loader();
        loader.data = byArray;
        loader.readTokens();
        throw new ViewerException(new String("unknown data from the server: " + byArray));
    }

    public boolean isPageLimitExceeded() throws ViewerException {
        Properties properties = this.de();
        properties.put("cmd", "get_pg_limit");
        byte[] byArray = this.a(properties, "bin");
        bw bw2 = new bw();
        bw2.data = byArray;
        bw2.readTokens();
        return bw2.isPageLimitExceeded();
    }

    public byte[] getNextExportChunk() throws ViewerException {
        if (this.al == null) {
            throw new ViewerException(com.inet.viewer.i18n.a.z("error.renderdata.getChunkCount_needed"));
        }
        while (true) {
            try {
                if (this.mt == null) {
                    return null;
                }
                if (this.mt.mA < 0) {
                    byte[] byArray = this.a(this.mt, 4096, false);
                    if (byArray == null) {
                        this.mt = null;
                    }
                    return byArray;
                }
                if (this.mt.mA < 4096) {
                    byte[] byArray = this.a(this.mt);
                    this.mt = null;
                    return byArray;
                }
                this.mt.mA -= 4096;
                return this.a(this.mt, 4096, true);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                this.dc();
                ViewerUtils.debug(mm);
                continue;
            }
            catch (Exception exception) {
                try {
                    this.mt.mz.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                this.dc();
                throw ViewerException.createViewerException(exception);
            }
            break;
        }
    }

    public int getExportChunkCount(Properties properties) throws ViewerException {
        this.al = this.de();
        this.al.put("cmd", "export");
        if (properties != null) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.al.put(string, ViewerUtils.encode(properties.getProperty(string)));
            }
        } else {
            throw new IllegalArgumentException("Null is not supported as argument for getExportChunkCount.");
        }
        try {
            this.mt = new a();
            this.a(this.mt, this.al, this.al.getProperty("export_fmt"), false);
            return (int)Math.ceil((double)this.mt.mA / 4096.0);
        }
        catch (ViewerException viewerException) {
            if (this.mu || viewerException.mH != null && viewerException.mH.length() > 0 || this.ms) {
                throw viewerException;
            }
            ViewerUtils.debug("Encountered: " + viewerException.getMessage() + " while trying POST request.");
        }
        catch (SocketTimeoutException socketTimeoutException) {
            this.dc();
            ViewerUtils.debug(mm);
        }
        catch (IOException iOException) {
            if (this.mu || this.ms) {
                this.dc();
                throw ViewerException.createViewerException(iOException);
            }
            try {
                this.mt.mz.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ViewerUtils.debug("Encountered: " + iOException.getMessage() + " while trying POST request.");
        }
        catch (Exception exception) {
            try {
                this.mt.mz.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            this.dc();
            throw ViewerException.createViewerException(exception);
        }
        try {
            ViewerUtils.debug(" => Fallback to HTTP GET Request instead of POST");
            this.mt = new a();
            this.a(this.mt, this.al, this.al.getProperty("export_fmt"), true);
            return (int)Math.ceil((double)this.mt.mA / 4096.0);
        }
        catch (Exception exception) {
            try {
                this.mt.mz.close();
            }
            catch (Exception exception3) {
                // empty catch block
            }
            this.dc();
            throw ViewerException.createViewerException(exception);
        }
    }

    private void dc() throws ViewerException {
        if (this.ms) {
            this.ms = false;
            throw new ViewerException(com.inet.viewer.i18n.a.z("error.renderdata.page_rendering_canceled"));
        }
    }

    public byte[] getGroupTree() throws ViewerException {
        return this.a(this.df(), "bin");
    }

    public void setReportTitle(String string) {
        this.title = string;
    }

    public String getReportTitle() {
        return this.title;
    }

    private Properties dd() {
        Properties properties = new Properties();
        properties.put("viewer", "java2");
        properties.put("vgen", String.valueOf(this.mp));
        properties.put("timezone", String.valueOf(this.mq));
        return properties;
    }

    private Properties de() {
        Properties properties = this.dd();
        if (this.mn != null) {
            Enumeration<?> enumeration = this.mn.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                properties.put(ViewerUtils.encode(string), ViewerUtils.encode(this.mn.getProperty(string)));
            }
        }
        return properties;
    }

    private Properties c(String string, int n2) {
        Properties properties = this.de();
        if (this.mr && this.isPromptOnRefresh()) {
            properties.put("promptOnRefresh", "1");
        } else if (this.mr && !this.isPromptOnRefresh()) {
            properties.put("promptOnRefresh", "0");
        }
        this.mr = false;
        properties.put("cmd", string);
        properties.put("page", String.valueOf(n2));
        return properties;
    }

    private Properties df() {
        Properties properties = this.de();
        properties.put("cmd", "get_grouptree");
        return properties;
    }

    private Properties dg() {
        Properties properties = this.de();
        properties.put("cmd", "get_pg_count");
        return properties;
    }

    public final void setReportProperty(String string, String string2) {
        if (string2 == null) {
            this.mn.remove(string.toLowerCase());
        } else {
            this.mn.put(string.toLowerCase(), string2);
        }
        this.reset();
    }

    public final Properties getProperties() {
        this.reset();
        return this.mn;
    }

    public final String getReportProperty(String string) {
        return this.mn.getProperty(string);
    }

    public void setPromptOnRefresh(boolean bl2) {
        this.reset();
        this.mo = bl2;
    }

    public boolean isPromptOnRefresh() {
        return this.mo;
    }

    public RenderData getCopy() {
        URLRenderData uRLRenderData = new URLRenderData(this.getReportLocation());
        uRLRenderData.mr = this.mr;
        uRLRenderData.mu = this.mu;
        uRLRenderData.mn.putAll((Map<?, ?>)this.mn);
        uRLRenderData.mv = this.mv;
        uRLRenderData.mw = this.mw;
        uRLRenderData.hostnameVerifier = this.hostnameVerifier;
        return uRLRenderData;
    }

    public void stop() {
        this.ms = true;
        this.a(this.c("stop", 1), "bin", false);
        WeakHashMap weakHashMap = this.mx;
        this.mx = new WeakHashMap();
        for (URLConnection uRLConnection : weakHashMap.keySet()) {
            if (uRLConnection == null || !(uRLConnection instanceof HttpURLConnection)) continue;
            ((HttpURLConnection)uRLConnection).disconnect();
        }
    }

    public byte[] search(String string, int n2, int n3) {
        Properties properties = this.de();
        properties.put("cmd", "search");
        properties.put("phrase", ViewerUtils.encode(string));
        properties.put("page", Integer.toString(n2));
        properties.put("flags", Integer.toString(n3));
        return this.a(properties, "bin");
    }

    public byte[] getFontData(int n2) {
        Properties properties = this.de();
        properties.put("export_fmt", "font");
        properties.put("cmd", "get_pg");
        properties.put("page", Integer.toString(n2));
        return this.a(properties, "bin");
    }

    public void resetServerCacheTimeout() {
        Properties properties = this.de();
        properties.put("cmd", "ping");
        byte[] byArray = this.a(properties, "bin");
        cb cb2 = new cb();
        cb2.data = byArray;
        cb2.readTokens();
    }

    public void setForceUseGET(boolean bl2) {
        this.mu = bl2;
    }

    public boolean isForceUseGET() {
        return this.mu;
    }

    public void setCookie(String string) {
        this.mv = string;
    }

    public String getCookie() {
        return this.mv;
    }

    void dh() {
        this.ms = false;
    }

    public void setSslSocketFactory(SSLSocketFactory sSLSocketFactory) {
        this.mw = sSLSocketFactory;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    static {
        my.put("application/crystalclear", "bin");
        my.put("application/clearreports", "bin");
        my.put("application/pdf", "pdf");
        my.put("application/ps", "ps");
        my.put("application/msword", "rtf");
        my.put("application/rtf", "rtf");
        my.put("application/jra", "jra");
        my.put("application/jar", "jar");
        my.put("text/rtf", "rtf");
        my.put("application/vnd.ms-excel", "xls");
        my.put("text/x-comma-separated-values", "csv");
        my.put("text/comma-separated-values", "csv");
        my.put("text/xml", "xml");
        my.put("text/plain", "txt");
        my.put("text/html", "htm");
        my.put("image/svg+xml", "svg");
        my.put("image/bmp", "bmp");
        my.put("image/gif", "gif");
        my.put("image/png", "png");
        my.put("image/jpeg", "jpg");
        my.put("application/zip", "zip");
        my.put("application/vnd.oasis.opendocument.spreadsheet", "ods");
    }

    private static class a {
        private InputStream mz;
        private int mA;
        private URLConnection mB;

        private a() {
        }
    }
}

