/*
 * Decompiled with CFR 0.152.
 */
package com.inet.xmlrpc;

import com.inet.report.BaseUtils;
import com.inet.report.SystemPermissionChecker;
import com.inet.report.permissions.Permission;
import com.inet.report.permissions.ReportPermissions;
import com.inet.report.permissions.WebUserInfo;
import com.inet.report.permissions.WebUserInfoFactory;
import com.inet.report.util.w;
import com.inet.xmlrpc.DefaultInetXmlRpcReport;
import com.inet.xmlrpc.DefaultInetXmlRpcRepository;
import com.inet.xmlrpc.DefaultInetXmlRpcServer;
import com.inet.xmlrpc.InetXmlRpcReport;
import com.inet.xmlrpc.InetXmlRpcRepository;
import com.inet.xmlrpc.InetXmlRpcServer;
import com.inet.xmlrpc.XmlRpcDescription;
import com.inet.xmlrpc.XmlRpcPermission;
import com.inet.xmlrpc.XmlRpcSignature;
import com.inet.xmlrpc.a;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import redstone.xmlrpc.XmlRpcMessages;
import redstone.xmlrpc.XmlRpcServlet;

public class InetXmlRpcServlet
extends XmlRpcServlet
implements Servlet {
    private static final Class<?>[] crX = new Class[]{InetXmlRpcReport.class, InetXmlRpcServer.class, InetXmlRpcRepository.class};

    @Override
    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        w.a(servletConfig);
        DefaultInetXmlRpcReport defaultInetXmlRpcReport = new DefaultInetXmlRpcReport();
        DefaultInetXmlRpcServer defaultInetXmlRpcServer = new DefaultInetXmlRpcServer();
        DefaultInetXmlRpcRepository defaultInetXmlRpcRepository = new DefaultInetXmlRpcRepository();
        this.getXmlRpcServer().addInvocationHandler(defaultInetXmlRpcReport.getRpcContext(), (Object)defaultInetXmlRpcReport);
        this.getXmlRpcServer().addInvocationHandler(defaultInetXmlRpcServer.getRpcContext(), (Object)defaultInetXmlRpcServer);
        this.getXmlRpcServer().addInvocationHandler(defaultInetXmlRpcRepository.getRpcContext(), (Object)defaultInetXmlRpcRepository);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.setCharacterEncoding(XmlRpcMessages.getString((String)"XmlRpcServlet.Encoding"));
        httpServletResponse.setContentType(this.getContentType());
        Writer writer = new StringWriter(2048);
        this.getXmlRpcServer().execute((InputStream)httpServletRequest.getInputStream(), writer);
        String string = writer.toString();
        httpServletResponse.setContentLength(string.getBytes(XmlRpcMessages.getString((String)"XmlRpcServlet.Encoding")).length);
        writer = httpServletResponse.getWriter();
        writer.write(string);
        writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            WebUserInfo webUserInfo = WebUserInfoFactory.generateWebUserInfo(httpServletRequest, httpServletResponse, new a(this));
            if (webUserInfo == null) {
                return;
            }
            if (!SystemPermissionChecker.checkAccess(webUserInfo, Permission.INTERFACE_XMLRPC)) {
                httpServletResponse.setStatus(403);
                httpServletResponse.setContentType("text/html; charset=utf-8");
                PrintWriter printWriter = httpServletResponse.getWriter();
                printWriter.write("User does not have XML-RPC permissions!");
                printWriter.flush();
                printWriter.close();
                return;
            }
            super.service(httpServletRequest, httpServletResponse);
        }
        finally {
            WebUserInfoFactory.destroyWebUserInfo();
        }
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.setContentType("text/html; charset=utf-8");
        PrintWriter printWriter = httpServletResponse.getWriter();
        String string = this.getResourceAsString("apiref.html");
        String string2 = com.inet.shared.servlet.a.i(httpServletRequest).toString();
        String string3 = com.inet.shared.servlet.a.h(httpServletRequest);
        if (string3 != null) {
            string2 = string2 + string3;
        }
        string = string.replace("{%HOST:PORT%}", string2);
        StringBuilder stringBuilder = new StringBuilder();
        for (Class<?> clazz : crX) {
            Method[] methodArray = clazz.getDeclaredMethods();
            boolean bl2 = false;
            for (Method method : methodArray) {
                stringBuilder.append("<tr" + (bl2 ? " class=\"odd\"" : "") + ">\n");
                bl2 = !bl2;
                String string4 = "";
                XmlRpcSignature xmlRpcSignature = method.getAnnotation(XmlRpcSignature.class);
                if (xmlRpcSignature != null) {
                    string4 = xmlRpcSignature.value();
                }
                stringBuilder.append("<td>" + string4 + "</td>");
                String string5 = "";
                XmlRpcDescription xmlRpcDescription = method.getAnnotation(XmlRpcDescription.class);
                if (xmlRpcDescription != null) {
                    string5 = xmlRpcDescription.value();
                }
                stringBuilder.append("<td>" + string5 + "</td>");
                String string6 = "";
                XmlRpcPermission xmlRpcPermission = method.getAnnotation(XmlRpcPermission.class);
                string6 = xmlRpcPermission != null ? ReportPermissions.getStringRepresentation(xmlRpcPermission.value()) : "UNKNOWN";
                stringBuilder.append("<td>" + string6 + "</td>");
                stringBuilder.append("</tr>\n");
            }
        }
        string = string.replace("<!-- %APIDATA% -->", stringBuilder.toString());
        printWriter.println(string);
        printWriter.close();
    }

    private String getResourceAsString(String string) throws IOException {
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (inputStream == null) {
            BaseUtils.error("cannot find " + string + "!!!");
            return "<html><head></head><body><!-- %APIDATA% --></body></html>";
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            stringBuilder.append(string2);
        }
        String string3 = stringBuilder.toString();
        inputStream.close();
        return string3;
    }
}

